/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.LookAheadIteration;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.repository.sparql.query.QueueCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinExecutorBase<T>
extends LookAheadIteration<T, QueryEvaluationException> {
    protected static int NEXT_JOIN_ID = 1;
    protected final TupleExpr rightArg;
    protected final BindingSet bindings;
    protected volatile Thread evaluationThread;
    protected CloseableIteration<T, QueryEvaluationException> leftIter;
    protected CloseableIteration<T, QueryEvaluationException> rightIter;
    protected volatile boolean closed;
    protected boolean finished = false;
    protected QueueCursor<CloseableIteration<T, QueryEvaluationException>> rightQueue = new QueueCursor(1024);

    public JoinExecutorBase(CloseableIteration<T, QueryEvaluationException> leftIter, TupleExpr rightArg, BindingSet bindings) throws QueryEvaluationException {
        this.leftIter = leftIter;
        this.rightArg = rightArg;
        this.bindings = bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            this.handleBindings();
        }
        catch (Exception e) {
            this.toss(e);
        }
        finally {
            this.finished = true;
            this.rightQueue.done();
        }
    }

    protected abstract void handleBindings() throws Exception;

    public void addResult(CloseableIteration<T, QueryEvaluationException> res) {
        if (res instanceof EmptyIteration) {
            return;
        }
        try {
            this.rightQueue.put(res);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error adding element to right queue", e);
        }
    }

    public void done() {
    }

    public void toss(Exception e) {
        this.rightQueue.toss(e);
    }

    @Override
    public T getNextElement() throws QueryEvaluationException {
        while (this.rightIter != null || this.rightQueue.hasNext()) {
            if (this.rightIter == null) {
                this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (this.rightIter.hasNext()) {
                return (T)this.rightIter.next();
            }
            this.rightIter.close();
            this.rightIter = null;
        }
        return null;
    }

    @Override
    public void handleClose() throws QueryEvaluationException {
        this.closed = true;
        if (this.evaluationThread != null) {
            this.evaluationThread.interrupt();
        }
        if (this.rightIter != null) {
            this.rightIter.close();
            this.rightIter = null;
        }
        if (this.leftIter != null) {
            this.leftIter.close();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

