/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;

public class SPARQLRepositoryConfig
extends RepositoryImplConfigBase {
    public static final URI ENDPOINT = new URIImpl("http://www.openrdf.org/config/repository/sparql#endpoint");
    private String url;

    public SPARQLRepositoryConfig() {
        super("openrdf:SPARQLRepository");
    }

    public SPARQLRepositoryConfig(String url) {
        this.setURL(url);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.url == null) {
            throw new RepositoryConfigException("No URL specified for SPARQL repository");
        }
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        ValueFactory vf = graph.getValueFactory();
        if (this.url != null) {
            graph.add(implNode, ENDPOINT, vf.createURI(this.url), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            URI uri = GraphUtil.getOptionalObjectURI(graph, implNode, ENDPOINT);
            if (uri != null) {
                this.setURL(uri.stringValue());
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

