/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.MixedGraphMemStore;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class MixedGraphMem
extends GraphMemBase
implements Graph {
    protected MixedGraphMemStore mixedStore = new MixedGraphMemStore(this);

    public MixedGraphMem() {
        this(ReificationStyle.Minimal);
    }

    public MixedGraphMem(ReificationStyle style) {
        super(style);
    }

    @Override
    protected TripleStore createTripleStore() {
        return null;
    }

    @Override
    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.mixedStore.add(t);
        }
    }

    @Override
    public void performDelete(Triple t) {
        if (!this.getReifier().handledRemove(t)) {
            this.mixedStore.remove(t);
        }
    }

    @Override
    public int graphBaseSize() {
        return this.mixedStore.size();
    }

    @Override
    public boolean graphBaseContains(Triple t) {
        return this.isSafeForEquality(t) ? this.mixedStore.contains(t) : this.containsByFind(t);
    }

    @Override
    protected void destroy() {
        this.mixedStore = null;
    }

    @Override
    public boolean isEmpty() {
        this.checkOpen();
        return this.mixedStore.isEmpty();
    }

    @Override
    public void clear() {
        this.mixedStore.clear();
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        Triple t = m.asTriple();
        Node S = t.getSubject();
        Node P = t.getPredicate();
        Node O = t.getObject();
        return S.isConcrete() ? this.mixedStore.iterator(S, t) : (P.isConcrete() ? this.mixedStore.iterator(P, t) : (O.isURI() || O.isBlank() ? this.mixedStore.iterator(O, t) : this.mixedStore.iterator(m.asTriple())));
    }
}

