
#ifndef __DEFS_H__
#define __DEFS_H__

/* Disable old GTK+ functions */
#define GDK_DISABLE_DEPRECATED 1
#define GTK_DISABLE_DEPRECATED 1
#define GDK_DISABLE_SINGLE_INCLUDES 1
#define GTK_DISABLE_SINGLE_INCLUDES 1

#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <locale.h>
#include <ctype.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>

#include "intl.h"

/* Platform specific includes */

#include <X11/X.h>
#include <X11/Xatom.h>
#include <gdk/gdkx.h>

/* EB Library includes */

#include <eb/eb.h>
#include <eb/defs.h>
#include <eb/text.h>
#include <eb/font.h>
#include <eb/appendix.h>
#include <eb/error.h>
#include <eb/binary.h>

#ifndef PACKAGE
#define PACKAGE "eb123"
#endif

#define SEARCH_METHOD_FORWARD        0
#define SEARCH_METHOD_BACKWARD       1
#define SEARCH_METHOD_EXACTWORD      2
#define SEARCH_METHOD_KEYWORD        3
#define SEARCH_METHOD_MENU          10
#define SEARCH_METHOD_COPYRIGHT     11
#define SEARCH_METHOD_UNKNOWN       99

#define SEARCH_METHOD_MIN            0
#define SEARCH_METHOD_MAX            4

#define SEARCH_FORWARD      _("Forward")
#define SEARCH_BACKWARD     _("Backward")
#define SEARCH_EXACTWORD    _("Exactword")
#define SEARCH_KEYWORD      _("Keyword")
#define SEARCH_MENU         _("Menu")
#define SEARCH_COPYRIGHT    _("Copyright")

#define ENC_UTF8            "utf-8"
#define ENC_EUC_JP          "euc-jp"
#define ENC_SHIFT_JIS       "shift-jis"
#define ENC_ISO_2022_JP     "iso-2022-jp"
#define ENC_ASCII           "ascii"

typedef struct
{
    gboolean active, available;
    gchar *title, *path, *appendix_path, *subbook_dir;
    EB_Book *book;
    EB_Appendix *appendix;
    EB_Subbook_Code subbook_no, appendix_subbook_no;
} BOOK_INFO;

typedef struct _result_eb
{
    gchar *heading;
    EB_Position pos;
    EB_Book *book;
} RESULT;

struct _search_method
{
    gint  code;
    gchar *name;
};

enum
{
    COLOR_LINK,
    COLOR_KEYWORD,
    COLOR_AUDIO,
    COLOR_VIDEO,
    COLOR_TITLE,
    COLOR_N
};

enum
{
    DICT_ALIAS,
    DICT_BINFO,
    DICT_EDITABLE,
    DICT_N
};

struct _shortcut_command
{
    gchar *name;
    void (* func)();
};

typedef struct
{
    guint16 mask, layout;
    guint32 code;
    gboolean enabled;
} KEY_EVENT;

#include "log.h"

#endif /* __DEFS_H__ */

