
#define _GLOBAL
#include <sys/wait.h>

#include "defs.h"

#include "dictbar.h"
#include "dicts.h"
#include "headword.h"
#include "history.h"
#include "hook.h"
#include "mainwnd.h"
#include "preferences.h"
#include "selection.h"
#include "shortcut.h"
#include "textview.h"

void app_exit(GtkWidget *widget, gpointer   data)
{
    hooksets_finalize();

    gdk_window_get_root_origin(mainwnd.wnd->window, &mainwnd.x, &mainwnd.y);
    mainwnd.w = mainwnd.wnd->allocation.width;
    mainwnd.h = mainwnd.wnd->allocation.height;

    paned.treew = paned.tree->allocation.width;
    paned.treeh = paned.tree->allocation.height;

    history_save_words();
    preferences_save();
    dicts_save();
    shortcuts_save();
    gtk_main_quit ();
}

void app_quit()
{
    app_exit(NULL, NULL);
}

int main(int argc, char *argv[])
{
    gtk_init (&argc, &argv);

#ifdef ENABLE_NLS
    bindtextdomain(PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(PACKAGE, ENC_UTF8);
    textdomain(PACKAGE);
#endif

    preferences_init();
    eb_initialize_library();
    hooksets_init();

    preferences_load();
    dicts_load();
    history_load_words();
    shortcuts_load();

    mainwnd_create();

    gtk_main();
    hooksets_finalize();

    _exit(0);
}

