
#ifndef __EBOOK_H_
#define __EBOOK_H_

gint            ebook_search_method();
BOOK_INFO*      ebook_load(const gchar *path, int subbook_no);
GdkPixbuf*      ebook_load_image(EB_Book *book, EB_Position *pos);
void            ebook_free(BOOK_INFO *binfo);
gchar*          ebook_get_text(EB_Book *book, EB_Position *pos);
gchar*          ebook_get_raw_text(EB_Book *book, gint page, gint offset);
void            ebook_search(const gchar *word, gint method, GSequence *results, gint maxhits);
void            ebook_search_book(const gchar *word, gint method, GSequence *results, gint maxhits, BOOK_INFO *binfo);
void            ebook_menu_or_copyright(gboolean menu, GSequence *results);
GdkPixbuf*      ebook_read_gaiji(EB_Book *book, gchar *code);

enum
{
    IMAGE_TYPE_JPEG, 
    IMAGE_TYPE_COLOR_BMP, 
    IMAGE_TYPE_MONO_BMP,
    IMAGE_TYPE_GRAY_BMP 
};

struct _ebook
{
    GSequence   *results;
} ebook;

#endif
