
#include "defs.h"

#include "ebook.h"
#include "headword.h"
#include "history.h"
#include "mainwnd.h"
#include "textview.h"

enum
{
    HEADING_TITLE,
    HEADING_RESULT,
    HEADING_N
};

void headword_clear()
{
    gtk_list_store_clear(headword.store);
}

void headword_append(gpointer data, gpointer user_data)
{
    GtkTreeIter iter;
    RESULT *rp = (RESULT *)(data);
    gtk_list_store_append(headword.store, &iter);
    gtk_list_store_set(headword.store, &iter, HEADING_TITLE, rp->heading, HEADING_RESULT, rp, -1);
}

void headword_show_results()
{
    GtkTreeIter iter;
    GtkTreeSelection *select;
    headword_clear();
    g_sequence_foreach(mainwnd.results, headword_append, NULL);
    select = gtk_tree_view_get_selection(GTK_TREE_VIEW(headword.tree));
    if(gtk_tree_model_get_iter_first(GTK_TREE_MODEL(headword.store), &iter))
        gtk_tree_selection_select_iter(select, &iter);
    else
        textview_insert_message(textview.buffer, "No hit.");
}

static void heading_selection_changed(GtkTreeSelection *selection, gpointer data)
{
    GtkTreeIter iter;
    GtkTreeModel *model;
    RESULT *rp;

    if(!gtk_tree_selection_get_selected(selection, &model, &iter))
        return;

    gtk_tree_model_get(model, &iter, HEADING_RESULT, &rp, -1);
    mainwnd_open(rp);
}

static gint button_press_event(GtkWidget *widget, GdkEventButton *event)
{
    GtkTreeSelection *selection;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(headword.tree));
    if(selection)
        heading_selection_changed(selection, NULL);
    return FALSE;
}

static void headword_move(gboolean next)
{
    GtkTreeIter iter;
    GtkTreeModel *model;
    GtkTreeSelection *select;
    GtkTreePath *path;

    if(!headword.store)
        return;

    select = gtk_tree_view_get_selection(GTK_TREE_VIEW(headword.tree));
    if(!gtk_tree_selection_get_selected(select, &model, &iter))
        return;

    path = gtk_tree_model_get_path(model, &iter);

    next ? gtk_tree_path_next(path) : gtk_tree_path_prev(path);
    if(gtk_tree_model_get_iter(model, &iter, path))
    {
        gtk_tree_selection_select_iter(select, &iter);
        gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(headword.tree), path, NULL, TRUE, 0.5, 0.0);
    }
    gtk_tree_path_free(path);
}

void headword_next()
{
    headword_move(TRUE);
}

void headword_prev()
{
    headword_move(FALSE);
}

GtkWidget *create_headword_tree()
{
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;
    GtkTreeSelection *select;
    GtkWidget *scroll;

    scroll = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scroll), GTK_SHADOW_IN);

    headword.tree = gtk_tree_view_new();
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(headword.tree), FALSE);
    gtk_container_add(GTK_CONTAINER(scroll), headword.tree);
    g_signal_connect(G_OBJECT(headword.tree),"button_press_event", G_CALLBACK(button_press_event), (gpointer)NULL);

    renderer = gtk_cell_renderer_text_new();
    column = gtk_tree_view_column_new_with_attributes("Results", renderer, "text", HEADING_TITLE, NULL);
    gtk_tree_view_insert_column(GTK_TREE_VIEW(headword.tree), column, -1);
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);

    select = gtk_tree_view_get_selection(GTK_TREE_VIEW(headword.tree));
    gtk_tree_selection_set_mode(select, GTK_SELECTION_SINGLE);
    g_signal_connect(G_OBJECT(select), "changed", G_CALLBACK(heading_selection_changed), NULL);

    headword.store = gtk_list_store_new(HEADING_N, G_TYPE_STRING, G_TYPE_POINTER);
    gtk_tree_view_set_model(GTK_TREE_VIEW(headword.tree), GTK_TREE_MODEL(headword.store));

    return scroll;
}

