
#include "defs.h"

#include "dictbar.h"
#include "dump.h"
#include "history.h"
#include "libxml/tree.h"
#include "mainwnd.h"
#include "preferences.h"

void history_prev()
{
    GList *hist, *hist1;
    RESULT *res;

    hist = g_list_last(history.list);
    if(!hist)
        return;

    hist1 = g_list_previous(hist);
    if(!hist1)
        return;

    result_free((RESULT *)hist->data);
    history.list = g_list_delete_link(history.list, hist);
    
    res = (RESULT *)(hist1->data);
    mainwnd_open(res);
}

void history_next(RESULT *res)
{
    GList *hist = g_list_last(history.list);
    if(hist)
    {
        RESULT *res1 = (RESULT*)hist->data;
        if((res1->book == res->book) && (res1->pos.page == res->pos.page) && (res1->pos.offset == res->pos.offset))
            return;
    }
    history.list = g_list_append(history.list, result_duplicate(res));
}

RESULT *history_last_result()
{
    GList *hist = g_list_last(history.list);
    if(hist)
        return (RESULT*)hist->data;
    return NULL;
}

gboolean history_remove_word(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data)
{
    gchar *str, *tmp = (gchar*)data;
    GtkListStore *store = GTK_LIST_STORE(model);
    gtk_tree_model_get(model, iter, 0, &str, -1);
    if(!g_strcmp0(str, tmp))
    {
        gtk_list_store_remove(store, iter);
        return TRUE;
    }
    return FALSE;
}

void history_insert_word(const gchar *word)
{
    gboolean b;
    GtkTreeIter iter;
    GtkTreePath *path;
    GtkTreeModel *model = gtk_combo_box_get_model(GTK_COMBO_BOX(mainwnd.combo_word));

    gtk_tree_model_foreach(model, history_remove_word, (gpointer)word);
    gtk_tree_model_foreach(model, history_remove_word, (gpointer)word);
    while(gtk_tree_model_iter_n_children(model, NULL) > dictbar.word_hist)
    {
        path = gtk_tree_path_new_from_indices(dictbar.word_hist - 1, -1);
        b = gtk_tree_model_get_iter(model, &iter, path);
        gtk_tree_path_free(path);
        if(!b)  break;
        gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
    }
    gtk_combo_box_prepend_text(GTK_COMBO_BOX(mainwnd.combo_word), word);
    gtk_combo_box_set_active(GTK_COMBO_BOX(mainwnd.combo_word), 0);
    return;
}

gboolean history_save_word(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data)
{
    guchar *str;
    xmlNodePtr node = xmlAddChild((xmlNodePtr)data, xmlNewNode(NULL, (xmlChar*)"word"));
    gtk_tree_model_get(model, iter, 0, &str, -1);
    xmlNewProp(node, (xmlChar*)"val", str);
    g_free(str);
    return FALSE;
}

void history_save_words()
{
    gchar filename[PATH_MAX];
    GtkTreeModel *model = gtk_combo_box_get_model(GTK_COMBO_BOX(mainwnd.combo_word));
    xmlDocPtr doc = xmlNewDoc((xmlChar*)"1.0");
    doc->children = xmlNewDocRawNode(doc, NULL, (xmlChar*)"History", NULL);
    sprintf(filename, "%s%s%s", pref.user, G_DIR_SEPARATOR_S, FILENAME_HISTORY);
    gtk_tree_model_foreach(model, history_save_word, doc->children);
    xmlSaveFormatFileEnc(filename, doc, "utf8", 0);
    xmlFreeDoc(doc);
}

void history_load_word(void *ctx, const xmlChar *name, const xmlChar **atts)
{
    if(!g_strcmp0((gchar*)name, "word"))
        gtk_combo_box_append_text(GTK_COMBO_BOX(mainwnd.combo_word), (gchar*)atts[1]);
}

void history_load_words()
{
    gchar filename[PATH_MAX];
    xmlSAXHandler cb;
    sprintf(filename, "%s%s%s", pref.user, G_DIR_SEPARATOR_S, FILENAME_HISTORY);
    if(!g_file_test(filename, G_FILE_TEST_IS_REGULAR))
        return;
    memset(&cb, 0, sizeof(xmlSAXHandler));
    cb.startElement = &history_load_word;
    xmlDocPtr doc = xmlSAXParseFile(&cb, filename, 0);
    xmlFreeDoc(doc);
}

RESULT *result_new(EB_Book *book, EB_Position *pos)
{
    RESULT *res = g_new0(RESULT, 1);
    res->book = book;
    if(pos)
        memcpy(&res->pos, pos, sizeof(EB_Position));
    return res;
}

RESULT *result_duplicate(RESULT *rp)
{
    RESULT *result;
    
    g_assert(rp != NULL);

    result = g_new0(RESULT, 1);
    result_copy(result, rp);
    return result;
}

void result_copy(RESULT *to, RESULT *from)
{
    g_assert(from != NULL);
    g_assert(to != NULL);

    if(from->heading)
        to->heading = g_strdup(from->heading);

    to->book = from->book;
    to->pos = from->pos;
}

void result_free(gpointer data)
{
    RESULT *res = (RESULT*)data;
    if(res->heading)
        g_free(res->heading);
    g_free(res);
}

gboolean result_compare(RESULT *res1, RESULT *res2)
{
    if(res1->book != res2->book)
        return FALSE;
    if(res1->pos.page != res2->pos.page)
        return FALSE;
    if(res1->pos.offset != res2->pos.offset)
        return FALSE;
    return TRUE;
}

