
#include "defs.h"

#include "jcode.h"
#include "preferences.h"

gchar *iconv_convert(const gchar *icode, const gchar *ocode, const gchar *orig)
{
    gsize i, o;
    GError *err = NULL;
    return g_convert(orig, strlen(orig), ocode, icode, &i, &o, &err);
}

gboolean validate_euc(gchar *str)
{
    gchar *p = str;
    while(*p)
    {
        if(is_euc_printable((guchar*)p))
            p +=2;
        else if(isprint(*p))
            p ++;
        else if(isspace(*p))
        {
            *p = 0x20;
            p++;
        }
        else
            return FALSE;
    }
    return TRUE;
}

gboolean is_jis_printable(const guchar *buf)
{
    g_assert(buf != NULL);
    return ((0x21 <= buf[0]) && (buf[0] <= 0x74) && (0x21 <= buf[1]) && (buf[1] <= 0x7E));
}

gboolean is_euc_printable(const guchar *buf)
{
    g_assert(buf != NULL);
    return ((0xA1 <= buf[0]) && (buf[0] <= 0xF4) && (0xA1 <= buf[1]) && (buf[1] <= 0xFE));
}

gchar *fs_to_unicode(gchar *from)
{
    return iconv_convert(pref.codeset, ENC_UTF8, from);
}   

gchar *unicode_to_fs(gchar *from)
{
    return iconv_convert(ENC_UTF8, pref.codeset, from);
}
