
#include "defs.h"

#include <gdk/gdkkeysyms.h>
#include "dictbar.h"
#include "headword.h"
#include "history.h"
#include "shortcut.h"
#include "textview.h"

#include <gdk/gdkx.h>

extern struct _shortcut_command commands[];

GtkLabel* shortcut_hbox_get_label(GtkHBox *hbox)
{
    GList *list = gtk_container_get_children(GTK_CONTAINER(hbox));
    return GTK_LABEL(list->data);
}

GtkEntry* shortcut_hbox_get_entry(GtkHBox *hbox)
{
    GList *list = gtk_container_get_children(GTK_CONTAINER(hbox));
    return GTK_ENTRY(list->next->data);
}

void pref_shortcut_end(gboolean save)
{
    if(!save) return;
    shortcuts_uninstall();
    shortcuts_install();
    shortcuts_save();
    return;
}

void key_val_to_string(guint state, guint keyval, gchar *key)
{
    key[0] = '\0';

    if(state & GDK_CONTROL_MASK)
        strcat(key, "Ctrl + ");

    if(state & GDK_SHIFT_MASK)
        strcat(key, "Shift + ");

    if(state & GDK_LOCK_MASK)
        strcat(key, "Lock + ");

    if(state & GDK_MOD1_MASK) // Alt
        strcat(key, "Alt + ");

    if(state & GDK_MOD2_MASK) // Num Lock
            strcat(key, "NumLock + ");

    if(state & GDK_MOD3_MASK)
        strcat(key, "Mod3 + ");

    if(state & GDK_MOD4_MASK)
        strcat(key, "Mod4 + ");

    if(state & GDK_MOD5_MASK) // Scroll Lock
        strcat(key, "ScrollLock + ");

    if(state & GDK_BUTTON1_MASK)
        strcat(key, "Button1 + ");

    if(state & GDK_BUTTON2_MASK)
        strcat(key, "Button2 + ");

    if(state & GDK_BUTTON3_MASK)
        strcat(key, "Button3 + ");

    if(state & GDK_BUTTON4_MASK)
        strcat(key, "Button4 + ");

    if(state & GDK_BUTTON5_MASK)
        strcat(key, "Button5 + ");

    if(state & GDK_RELEASE_MASK)
        strcat(key, "Release + ");

    strcat(key, gdk_keyval_name(keyval));
}

static void lock_changed(GtkWidget *widget, gpointer data)
{
    shortcuts.ignore_locks = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

static gboolean grab_shortcut_key(GtkDialog *dlg, GdkEventKey *event, GtkHBox *hbox)
{
    gchar key[256];
    const gchar *command;

    switch (event->keyval){
    case GDK_Shift_L:
    case GDK_Shift_R:
    case GDK_Control_L:
    case GDK_Control_R:
    case GDK_Meta_L:
    case GDK_Meta_R:
    case GDK_Alt_L:
    case GDK_Alt_R:
    case GDK_Caps_Lock:
    case GDK_Shift_Lock:
    case GDK_Scroll_Lock:
    case GDK_Num_Lock:
    case GDK_Kana_Lock:
        return(FALSE);
        break;
    }

    if(shortcuts.ignore_locks)
        event->state = event->state & (~GDK_LOCK_MASK) & (~GDK_MOD2_MASK);
    key_val_to_string(event->state, event->keyval, key);

    gtk_entry_set_text(shortcut_hbox_get_entry(hbox), key);
    command = gtk_label_get_text(shortcut_hbox_get_label(hbox));
    KEY_EVENT *evt = (KEY_EVENT*)g_datalist_id_get_data(&shortcuts.list, g_quark_try_string(command));
    if(evt != NULL) {
        evt->mask = event->state;
        evt->code = event->keyval;
        evt->enabled = TRUE;
    }
    gtk_dialog_response(dlg, GTK_RESPONSE_OK);

    return(TRUE);
}

static void shortcut_edit(GtkWidget *widget, GtkHBox *hbox)
{
    //GtkEntry *entry = GTK_ENTRY(data);
    const gchar *command;
    GtkWidget* dlg = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE,
                                            _("Press a key (or a key combination) to add new shortcut,\n"
                                            "\"Clear\" to remove current shortcut,\n"
                                            "\"Cancel\" to close this message."));
    gtk_dialog_add_buttons(GTK_DIALOG(dlg), GTK_STOCK_CLEAR, GTK_RESPONSE_NO, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);

    gtk_window_set_title(GTK_WINDOW(dlg), _("Grabbing a key."));
    g_signal_connect(G_OBJECT(dlg), "key-press-event", G_CALLBACK(grab_shortcut_key), hbox);

    if(gtk_dialog_run(GTK_DIALOG(dlg)) == GTK_RESPONSE_NO) {
        gtk_entry_set_text(shortcut_hbox_get_entry(hbox), "");
        command = gtk_label_get_text(shortcut_hbox_get_label(hbox));
        KEY_EVENT *evt = (KEY_EVENT*)g_datalist_id_get_data(&shortcuts.list, g_quark_try_string(command));
        if(evt != NULL) {
            evt->mask = evt->code = 0;
            evt->enabled = FALSE;
        }
    }
    gtk_widget_destroy(dlg);
}

GtkWidget *pref_shortcut_start()
{
    gint i;
    GtkWidget *vbox, *vbox1, *hbox1, *scroll, *label, *entry, *button, *lock;
    gchar keystr[64];

    vbox = gtk_vbox_new(FALSE, 0);
    scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
    gtk_box_pack_start(GTK_BOX(vbox), scroll, TRUE, TRUE, 0);

    vbox1 = gtk_vbox_new(TRUE, 5);
    gtk_container_set_border_width(GTK_CONTAINER(vbox1), 5);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll), vbox1);

    for(i = 0; commands[i].name != NULL; i++)
    {
        hbox1 = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(vbox1), hbox1, FALSE, FALSE, 0);

        label = gtk_label_new(commands[i].name);
        gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 0);

        button = gtk_button_new_with_label("Edit...");
        gtk_box_pack_end(GTK_BOX(hbox1), button, FALSE, FALSE, 0);
        g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(shortcut_edit), hbox1);

        entry = gtk_entry_new();
        gtk_editable_set_editable(GTK_EDITABLE(entry), FALSE);
        gtk_box_pack_end(GTK_BOX(hbox1), entry, FALSE, FALSE, 0);

        KEY_EVENT *evt = (KEY_EVENT*)g_datalist_id_get_data(&shortcuts.list, g_quark_try_string(commands[i].name));
        if(evt ? evt->enabled : FALSE)
        {
            key_val_to_string(evt->mask, evt->code, keystr);
            gtk_entry_set_text(GTK_ENTRY(entry), keystr);
        }
    }

    lock = gtk_check_button_new_with_label(_("Ignore locks"));
    gtk_box_pack_start(GTK_BOX(vbox), lock, FALSE, FALSE, 0);
    gtk_widget_set_tooltip_text(lock, "Ignore Caps Lock and Num Lock key.");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lock), shortcuts.ignore_locks);
    g_signal_connect(G_OBJECT(lock), "clicked", G_CALLBACK(lock_changed), NULL);

    return vbox;
}

