
#include "defs.h"

#include "dicts.h"
#include "ebook.h"
#include "headword.h"
#include "jcode.h"
#include "history.h"
#include "render.h"
#include "textview.h"

#include <libxml/HTMLparser.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

void render_gaiji(gchar *code)
{
    GdkPixbuf *pixbuf;
    GtkTextIter iter;

    if(!(pixbuf = ebook_read_gaiji(render.book, code)))
        return;
    gtk_text_buffer_get_end_iter(render.buffer, &iter);
    gtk_text_buffer_insert_pixbuf(render.buffer, &iter, pixbuf);
}

void render_startElement(void *ctx, const xmlChar *name, const xmlChar **atts)
{
    GtkTextIter iter;
    gtk_text_buffer_get_end_iter(render.buffer, &iter);
    if(!g_strcmp0((char*)name, "gaiji") && atts[1])
    {
        render_gaiji((gchar *)atts[1]);
        return;
    }
    if(!g_strcmp0((char*)name, "jpeg") || !strcmp((char*)name, "bmp"))
    {
        EB_Position pos;
        GdkPixbuf *pixbuf;
        pos.page = strtol((gchar*)atts[1], NULL, 16);
        pos.offset = strtol((gchar*)atts[3], NULL, 16);
        pixbuf = ebook_load_image(render.book, &pos);
        if(pixbuf)
            gtk_text_buffer_insert_pixbuf(render.buffer, &iter, pixbuf);
        return;
    }
    gtk_text_buffer_create_mark(render.buffer, "link", &iter, TRUE);
}

void render_endElement(void *ctx, const xmlChar *name)
{
    gchar *color, type[16];
    GtkTextIter iter1, iter2;
    GtkTextTag *tag;
    if(!g_strcmp0((char*)name, "keyword"))
        color = textview.colors[COLOR_KEYWORD];
    else if(!g_strcmp0((char*)name, "reference") || !strcmp((char*)name, "candidate"))
    {
        color = textview.colors[COLOR_LINK];
        sprintf(type, "%s", "link");
    }
    else if(!g_strcmp0((char*)name, "wave"))
    {
        color = textview.colors[COLOR_AUDIO];
        sprintf(type, "%s", "audio");
    }
    else if(!g_strcmp0((char*)name, "movie"))
    {
        color = textview.colors[COLOR_VIDEO];
        sprintf(type, "%s", "video");
    }
    else
        return;
    GtkTextMark *mark = gtk_text_buffer_get_mark(render.buffer, "link");
    gtk_text_buffer_get_iter_at_mark(render.buffer, &iter1, mark);
    gtk_text_buffer_delete_mark(render.buffer, mark);
    gtk_text_buffer_get_end_iter(render.buffer, &iter2);
    tag = gtk_text_buffer_create_tag(render.buffer, NULL, "foreground", color, NULL);
    gtk_text_buffer_apply_tag(render.buffer, tag, &iter1, &iter2);
    render.link = result_new(render.book, NULL);
    g_object_set_data_full(G_OBJECT(tag), type, render.link, result_free);
}

void render_parse_link(gchar *str, EB_Position *p, int *size)
{
    gchar **ca = g_strsplit_set(str, "= >", 0);
    p->page = strtol(ca[1], NULL, 16);
    p->offset = strtol(ca[3], NULL, 16);
    if(!g_strcmp0(ca[4], "size"))
        *size = strtol(ca[5], NULL, 16);
    g_strfreev(ca);
}

void render_characters(void *ctx, const xmlChar *ch, int len)
{
    gchar *s = g_strstr_len((gchar*)ch, len, ">");
    GtkTextIter iter;
    if(s)
    {
        int size = 0;
        render_parse_link((gchar*)ch, &render.link->pos, &size);
        if(s)
        {
            GtkTextIter end;
            gtk_text_buffer_get_end_iter(render.buffer, &end);
            gtk_text_buffer_insert(render.buffer, &end, &(s[1]), -1);
        }
        return;
    }
    gtk_text_buffer_get_end_iter(render.buffer, &iter);
    gtk_text_buffer_insert(render.buffer, &iter, (gchar*)ch, len);
}

void render_title(gchar *title)
{
    GtkTextIter iter;
    GtkTextTag *tag;
    gtk_text_buffer_get_end_iter(render.buffer, &iter);
    tag = gtk_text_buffer_create_tag(render.buffer, NULL, "foreground", textview.colors[COLOR_TITLE], "justification", GTK_JUSTIFY_CENTER, "scale", 1.2, NULL);
    gtk_text_buffer_insert_with_tags(render.buffer, &iter, "---", -1, tag, NULL);
    gtk_text_buffer_insert_with_tags(render.buffer, &iter, title, -1, tag, NULL);
    gtk_text_buffer_insert_with_tags(render.buffer, &iter, "---", -1, tag, NULL);
    gtk_text_buffer_insert(render.buffer, &iter, "\n", -1);
}

void render_content(EB_Book *book, GtkTextBuffer *buffer, gchar *text)
{
    gchar *utf_text = iconv_convert(ENC_EUC_JP, ENC_UTF8, text);
    htmlSAXHandler cb;
    BOOK_INFO *binfo = dicts_find_binfo(book);
    render.book = book;
    render.buffer = buffer;
    memset(&cb, 0, sizeof(htmlSAXHandler));
    cb.startElement = &render_startElement;
    cb.endElement = &render_endElement;
    cb.characters = &render_characters;
    if(binfo)
        render_title(binfo->title);
    htmlDocPtr doc = htmlSAXParseDoc((xmlChar*)utf_text, ENC_UTF8, &cb, NULL);
    xmlFreeDoc(doc);
    g_free(utf_text);
}

