
#include "defs.h"
#include "ebook.h"
#include "headword.h"
#include "history.h"
#include "jcode.h"
#include "popupwnd.h"
#include "selection.h"

gint selection_copy(gpointer data)
{
    GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_PRIMARY);
    gchar *str = gtk_clipboard_wait_for_text(clipboard);
    static gchar *sel = NULL, *sel_prev = NULL;
    if(!str)
    {
        g_free(sel_prev);
        sel_prev = NULL;
        return TRUE;
    }
    g_strstrip(str);
    str = g_strdelimit(str, G_STR_DELIMITERS, '\n');
    gint len = strlen(str);
    if((len > selection.maxchar) || g_strrstr(str, "\n"))
    {
        g_free(sel_prev);
        sel_prev = NULL;
        g_free(str);
        return TRUE;
    }
    if(!sel)
    {
        sel = str;
        return TRUE;
    }
    if(strncmp(str, sel, selection.maxchar))
    {
        g_free(sel);
        sel = str;
        return TRUE;
    }
    g_free(str);
    if(sel_prev ? !strncmp(sel_prev, sel, selection.maxchar) : FALSE)
        return TRUE;
    popupwnd_search(sel);
    sel_prev = sel;
    sel = NULL;
    return TRUE;
}

void selection_lookup_start()
{
    if(selection.timeout_id != 0)
        g_source_remove(selection.timeout_id);
    selection.timeout_id = g_timeout_add(selection.interval, selection_copy, NULL);
    selection.lookup = TRUE;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(popupwnd.scan), TRUE);
}

void selection_lookup_stop()
{
    if(selection.timeout_id != 0)
        g_source_remove(selection.timeout_id);
    selection.timeout_id = 0;
    selection.lookup = FALSE;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(popupwnd.scan), FALSE);
    popupwnd_close(NULL, NULL);
}

void selection_toggled(GtkToggleButton *togglebutton, gpointer data)
{
    if(gtk_toggle_button_get_active(togglebutton))
        selection_lookup_start();
    else
        selection_lookup_stop();
}

