
#ifndef __TEXTVIEW_H__
#define __TEXTVIEW_H__

#include "defs.h"

GtkWidget*  textview_create();
GtkWidget*  textview_create_menu();
void        textview_create_textbuf();
void        textview_push_message(gchar *msg);
void        textview_scroll_down();
void        textview_set_pixels(gint n);
void        textview_scroll_up();
void        textview_copy_to_clipboard();
void        textview_clear_textbuf(GtkTextBuffer *buf);
void        textview_insert_message(GtkTextBuffer *buf, gchar *msg);
gint        textview_motion_notify(GtkWidget *widget, GdkEventMotion *event);
gint        textview_button_press(GtkWidget *widget, GdkEventButton *event);
GtkTextTag* textview_get_link_under_cursor(GtkWidget *widget, gint ex, gint ey);
void        textview_underline_lnk(GtkWidget *widget, GdkEventMotion *event, GtkTextTag **tag_lnk);

struct _textview
{
    gboolean        scroll_smooth;
    gint            scroll_step, scroll_time, scroll_margin, font_w, line_space, font_ascent;
    gchar           *colors[COLOR_N];
    GtkTextBuffer   *buffer;
    GtkTextTagTable *tag_table;
    GtkWidget       *view, *scroll, *menu;
} textview;

#endif /* __TEXTVIEW_H__ */
