
#include "defs.h"

#include "dicts.h"
#include "eb123.h"
#include "ebook.h"
#include "mainwnd.h"
#include "popupwnd.h"
#include "preferences.h"
#include "selection.h"
#include "textview.h"
#include "toolbar.h"

GtkWidget *toolbar_button(GtkCallback cb, gchar *id, gchar *tooltip_text, gboolean stock)
{
    GtkWidget *btn, *image;
    btn = gtk_button_new();

    if(stock)
    {
        image = gtk_image_new_from_stock(id, GTK_ICON_SIZE_SMALL_TOOLBAR);
        gtk_container_add(GTK_CONTAINER(btn), image);
    }
    else
        gtk_button_set_label(GTK_BUTTON(btn), id);

    gtk_button_set_relief(GTK_BUTTON(btn), GTK_RELIEF_NONE);
    g_signal_connect(G_OBJECT(btn), "pressed", G_CALLBACK(cb), NULL);
    gtk_widget_set_tooltip_text(btn, tooltip_text);
    return btn;
}

static void toolbar_show_menu(GtkWidget *w, gpointer data)
{
    ebook_menu_or_copyright(TRUE, mainwnd.results);
}

static void toolbar_show_copyright(GtkWidget *w, gpointer data)
{
    ebook_menu_or_copyright(FALSE, mainwnd.results);
}

GtkWidget *toolbar_create()
{
    GtkWidget *bbox, *bbox1, *btn;
    bbox = gtk_hbox_new(TRUE, 5);
    bbox1 = gtk_hbox_new(FALSE, 5);
    gtk_container_set_border_width(GTK_CONTAINER(bbox), 3);
    gtk_box_pack_start(GTK_BOX(bbox), bbox1, TRUE, TRUE, 0);

    popupwnd.scan = gtk_check_button_new_with_label(_("Scan"));
    GTK_WIDGET_UNSET_FLAGS(popupwnd.scan, GTK_CAN_FOCUS);
    gtk_widget_set_tooltip_text(popupwnd.scan, _("Scan selection"));
    g_signal_connect(G_OBJECT(popupwnd.scan), "toggled", G_CALLBACK(selection_toggled), NULL);
    if(selection.lookup)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(popupwnd.scan), TRUE);
    gtk_box_pack_start(GTK_BOX(bbox1), popupwnd.scan, FALSE, FALSE, 0);

    btn = toolbar_button(mainwnd_show_about, GTK_STOCK_ABOUT, _("About"), TRUE);
    gtk_box_pack_start(GTK_BOX(bbox1), btn, FALSE, FALSE, 0);

    btn = toolbar_button(app_exit, GTK_STOCK_QUIT, _("Quit program"), TRUE);
    gtk_box_pack_start(GTK_BOX(bbox1), btn, FALSE, FALSE, 0);

    bbox1 = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(bbox), bbox1, TRUE, TRUE, 0);
    btn = toolbar_button(toolbar_show_menu, "M", _("Search menu"), FALSE);
    gtk_box_pack_start(GTK_BOX(bbox1), btn, FALSE, FALSE, 0);
    btn = toolbar_button(toolbar_show_copyright, "©", _("Search copyright"), FALSE);
    gtk_box_pack_start(GTK_BOX(bbox1), btn, FALSE, FALSE, 0);

    btn = toolbar_button(preferences_show_cb, GTK_STOCK_PREFERENCES, _("Edit preferences"), TRUE);
    gtk_box_pack_end(GTK_BOX(bbox1), btn, FALSE, FALSE, 0);
    btn = toolbar_button(dicts_show, GTK_STOCK_SELECT_FONT, _("Add/Remove dictionaries"), TRUE);
    gtk_box_pack_end(GTK_BOX(bbox1), btn, FALSE, FALSE, 0);

    return bbox;
}

