/*
 * Decompiled with CFR 0.152.
 */
package fuku.player;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.Time;
import javax.swing.JApplet;

public final class VideoPlayerApplet
extends JApplet
implements ControllerListener {
    private Player _player = null;
    private Component _progressBar = null;
    private Component _visualComp = null;
    private Component _controlComp = null;

    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        try {
            URL url = new URL(this.getDocumentBase(), this.getParameter("file"));
            this._player = Manager.createPlayer((URL)url);
            this._player.addControllerListener((ControllerListener)this);
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (NoPlayerException e) {
            System.err.println(e.getMessage());
        }
    }

    public void start() {
        if (this._player != null) {
            this._player.start();
        }
    }

    public void stop() {
        if (this._player != null) {
            this._player.stop();
            this._player.deallocate();
        }
    }

    public void destroy() {
        this.getContentPane().removeAll();
        this._progressBar = null;
        this._visualComp = null;
        this._controlComp = null;
        if (this._player != null) {
            this._player.close();
            this._player = null;
        }
    }

    public synchronized void controllerUpdate(ControllerEvent evt) {
        if (this._player == null) {
            return;
        }
        if (evt instanceof RealizeCompleteEvent) {
            this._player.stop();
            if (this._visualComp == null) {
                this._visualComp = this._player.getVisualComponent();
                if (this._visualComp != null) {
                    this.getContentPane().add(this._visualComp, "Center");
                }
            }
            if (this._controlComp == null) {
                this._controlComp = this._player.getControlPanelComponent();
                if (this._controlComp != null) {
                    this.getContentPane().add(this._controlComp, "South");
                }
            }
            this.validate();
        } else if (evt instanceof CachingControlEvent) {
            CachingControlEvent e = (CachingControlEvent)evt;
            CachingControl cc = e.getCachingControl();
            if (this._progressBar == null) {
                this._progressBar = cc.getProgressBarComponent();
                if (this._progressBar != null) {
                    this.getContentPane().add(this._progressBar, "North");
                    this.validate();
                }
            }
            if (this._progressBar != null && e.getContentProgress() == cc.getContentLength()) {
                this.getContentPane().remove(this._progressBar);
                this._progressBar = null;
                this.validate();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            this._player.setMediaTime(new Time(0L));
        } else if (evt instanceof ControllerErrorEvent) {
            ControllerErrorEvent e = (ControllerErrorEvent)evt;
            System.err.println(e.getMessage());
        }
    }
}

