/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.SubAppendix;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBFile;
import fuku.eb4j.util.ByteUtil;
import java.io.File;

public final class Appendix {
    private String _appendixPath = null;
    private int _appendixType = -1;
    private SubAppendix[] _sub = null;

    Appendix(String path) throws EBException {
        this._appendixPath = path;
        File dir = new File(path);
        if (!dir.isDirectory()) {
            throw new EBException(0, path);
        }
        if (!dir.canRead()) {
            throw new EBException(1, path);
        }
        this._loadCatalog(dir);
    }

    public String getPath() {
        return this._appendixPath;
    }

    public int getAppendixType() {
        return this._appendixType;
    }

    public int getSubAppendixCount() {
        int ret = 0;
        if (this._sub != null) {
            ret = this._sub.length;
        }
        return ret;
    }

    public SubAppendix[] getSubAppendixes() {
        return this._sub;
    }

    public SubAppendix getSubAppendix(int index) {
        if (index < 0 || index >= this._sub.length) {
            return null;
        }
        return this._sub[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadCatalog(File dir) throws EBException {
        EBFile file = null;
        try {
            file = new EBFile(dir, "catalog", 0);
            this._appendixType = 0;
        }
        catch (EBException e) {
            file = new EBFile(dir, "catalogs", 0);
            this._appendixType = 1;
        }
        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            bis.readFully(b, 0, b.length);
            int subCount = ByteUtil.getInt2(b, 0);
            if (subCount <= 0) {
                throw new EBException(5, file.getPath());
            }
            this._sub = new SubAppendix[subCount];
            b = new byte[Book.SIZE_CATALOG[this._appendixType]];
            int off = 2 + Book.SIZE_TITLE[this._appendixType];
            for (int i = 0; i < subCount; ++i) {
                bis.readFully(b, 0, b.length);
                String path = new String(b, off, 8).trim();
                this._sub[i] = new SubAppendix(this, path);
            }
        }
        finally {
            bis.close();
        }
    }
}

