/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.util;

public final class CompareUtil {
    private CompareUtil() {
    }

    public static int compareToCanonical(byte[] key, byte[] pattern, boolean exact) {
        int klen = key.length;
        int plen = pattern.length;
        for (int i = 0; i < klen; ++i) {
            if (i >= plen) {
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                if (exact) {
                    while (i < plen && pattern[i] == 0) {
                        ++i;
                    }
                    return i - plen;
                }
                return 0;
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte == pByte) continue;
            return kByte - pByte;
        }
        if (klen < plen && exact) {
            return -(pattern[klen] & 0xFF);
        }
        return 0;
    }

    public static int compareToLatin(byte[] key, byte[] pattern, boolean exact) {
        int klen = key.length;
        int plen = pattern.length;
        for (int i = 0; i < klen; ++i) {
            if (i >= plen) {
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                if (exact) {
                    while (i < plen && (pattern[i] == 32 || pattern[i] == 0)) {
                        ++i;
                    }
                    return i - plen;
                }
                return 0;
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte == pByte) continue;
            return kByte - pByte;
        }
        if (klen < plen && exact) {
            return -(pattern[klen] & 0xFF);
        }
        return 0;
    }

    public static int compareTo(byte[] key, byte[] pattern, boolean exact) {
        int klen = key.length;
        int plen = pattern.length;
        for (int i = 0; i < klen; i += 2) {
            if (i >= plen) {
                return key[i] & 0xFF;
            }
            if (key[i] == 0) {
                if (exact) {
                    return -(pattern[i] & 0xFF);
                }
                return 0;
            }
            if (i + 1 >= klen || i + 1 >= plen) {
                return (key[i] & 0xFF) - (pattern[i] & 0xFF);
            }
            int kByte = key[i] & 0xFF;
            int pByte = pattern[i] & 0xFF;
            if (kByte != pByte) {
                return kByte - pByte;
            }
            kByte = key[i + 1] & 0xFF;
            pByte = pattern[i + 1] & 0xFF;
            if (kByte == pByte) continue;
            return kByte - pByte;
        }
        if (klen < plen && exact) {
            return -(pattern[klen] & 0xFF);
        }
        return 0;
    }
}

