/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.tool;

import fuku.eb4j.Book;
import fuku.eb4j.EBException;
import fuku.eb4j.SubBook;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.util.ByteUtil;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

public final class EBDump {
    private static final String _PROGRAM = "fuku.eb4j.tool.EBDump";
    private static final String DEFAULT_BOOK_DIR = ".";
    private static final LongOpt[] LONGOPT = new LongOpt[]{new LongOpt("subbook", 1, null, 115), new LongOpt("page", 1, null, 112), new LongOpt("offset", 1, null, 111), new LongOpt("position", 1, null, 80), new LongOpt("dump", 1, null, 100), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
    private Book _book = null;

    public static void main(String[] args) {
        int c;
        Getopt g = new Getopt(_PROGRAM, args, "s:p:o:P:d:hv", LONGOPT);
        int subindex = 0;
        long page = 1L;
        int off = 0;
        long pos = -1L;
        int size = 0;
        String arg = null;
        block21: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 115: {
                    arg = g.getOptarg();
                    try {
                        subindex = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("fuku.eb4j.tool.EBDump: invalid subbook index `" + arg + "'");
                        System.exit(1);
                    }
                    if (subindex <= 0) {
                        System.err.println("fuku.eb4j.tool.EBDump: invalid subbook index `" + arg + "'");
                        System.exit(1);
                    }
                    --subindex;
                    continue block21;
                }
                case 112: {
                    arg = g.getOptarg();
                    try {
                        page = Long.parseLong(arg, 16);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("fuku.eb4j.tool.EBDump: invalid page number `" + arg + "'");
                        System.exit(1);
                    }
                    if (page > 0L) continue block21;
                    System.err.println("fuku.eb4j.tool.EBDump: invalid page number `" + arg + "'");
                    System.exit(1);
                    continue block21;
                }
                case 111: {
                    arg = g.getOptarg();
                    try {
                        off = Integer.parseInt(arg, 16);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("fuku.eb4j.tool.EBDump: invalid offset number `" + arg + "'");
                        System.exit(1);
                    }
                    if (off >= 0) continue block21;
                    System.err.println("fuku.eb4j.tool.EBDump: invalid offset number `" + arg + "'");
                    System.exit(1);
                    continue block21;
                }
                case 80: {
                    arg = g.getOptarg();
                    try {
                        pos = Long.parseLong(arg, 16);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("fuku.eb4j.tool.EBDump: invalid position `" + arg + "'");
                        System.exit(1);
                    }
                    if (pos >= 0L) continue block21;
                    System.err.println("fuku.eb4j.tool.EBDump: invalid position `" + arg + "'");
                    System.exit(1);
                    continue block21;
                }
                case 100: {
                    arg = g.getOptarg();
                    try {
                        size = Integer.parseInt(arg, 16);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("fuku.eb4j.tool.EBDump: invalid dump size `" + arg + "'");
                        System.exit(1);
                    }
                    if (size > 0) continue block21;
                    System.err.println("fuku.eb4j.tool.EBDump: invalid dump size `" + arg + "'");
                    System.exit(1);
                    continue block21;
                }
                case 104: {
                    EBDump._usage(0);
                    continue block21;
                }
                case 118: {
                    EBDump._version();
                    continue block21;
                }
            }
            EBDump._usage(1);
        }
        String path = null;
        int idx = g.getOptind();
        if (idx + 1 == args.length) {
            path = args[idx];
        } else if (idx + 1 > args.length) {
            path = DEFAULT_BOOK_DIR;
        } else {
            System.err.println("fuku.eb4j.tool.EBDump: too many arguments");
            EBDump._usage(1);
        }
        try {
            EBDump ebdump = new EBDump(path);
            if (pos < 0L) {
                pos = BookInputStream.getPosition((long)page, (int)off);
            }
            ebdump._dump(subindex, pos, size);
        }
        catch (EBException e) {
            System.err.println("fuku.eb4j.tool.EBDump: " + e.getMessage());
        }
    }

    private static void _usage(int status) {
        if (status != 0) {
            System.out.println("Try `java fuku.eb4j.tool.EBDump --help' for more information");
        } else {
            System.out.println("Usage: java fuku.eb4j.tool.EBDump [option...] [book-directory]");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("  -s INTEGER  --subbook INTEGER");
            System.out.println("                             subbook index number");
            System.out.println("  -p LONG  --page LONG");
            System.out.println("                             page number (hex)");
            System.out.println("  -o INTEGER  --offset INTEGER");
            System.out.println("                             offset number (hex)");
            System.out.println("  -P LONG  --position LONG");
            System.out.println("                             position (hex)");
            System.out.println("  -d INTEGER  --dump INTEGER");
            System.out.println("                             dump size (hex)");
            System.out.println("  -h  --help                 display this help and exit");
            System.out.println("  -v  --version              output version information and exit");
            System.out.println("");
            System.out.println("Argument:");
            System.out.println("  book-directory             top directory of a book");
            System.out.println("                             (default: .)");
            System.out.println("");
            System.out.println("Report bugs to <fukumoto@users.sourceforge.jp>.");
        }
        System.exit(status);
    }

    private static void _version() {
        System.out.println("fuku.eb4j.tool.EBDump 0.3.5");
        System.out.println("Copyright (c) 2002-2004 by Hisaya FUKUMOTO.");
        System.out.println("All right reserved.");
        System.exit(0);
    }

    private EBDump(String path) throws EBException {
        this._book = new Book(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _dump(int subindex, long pos, int size) throws EBException {
        SubBook sub = this._book.getSubBook(subindex);
        if (sub == null) {
            return;
        }
        if (size <= 0) {
            size = 2048;
        }
        BookInputStream bis = sub.getTextFile().getInputStream();
        byte[] b = new byte[size];
        try {
            bis.seek(pos);
            bis.readFully(b, 0, b.length);
        }
        finally {
            bis.close();
        }
        long page = BookInputStream.getPage((long)pos);
        long pos2 = pos + (long)size;
        long start = pos - (pos & 0xFL);
        long end = pos2;
        if ((end & 0xFL) > 0L) {
            end += 16L - end % 16L;
        }
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        long i = 0L;
        for (i = start; i < end; i += 16L) {
            int j;
            if (pos + (long)idx >= page * 2048L) {
                ++page;
            }
            buf.append(this._toHexString(page)).append(':');
            int offset = (int)(i % 2048L);
            buf.append(this._toHexString(offset)).append(' ');
            int k = 0;
            for (j = 0; j < 16; ++j) {
                if (j == 8) {
                    buf.append(' ');
                }
                buf.append(' ');
                if (i + (long)j >= pos && i + (long)j < pos2) {
                    buf.append(this._toHexString(b[idx + k]));
                    ++k;
                    continue;
                }
                buf.append("  ");
            }
            buf.append("  ");
            for (j = 0; j < 16; j += 2) {
                if (i + (long)j >= pos && i + (long)j < pos2) {
                    int high = b[idx++] & 0xFF;
                    if (i + (long)j + 1L >= pos && i + (long)j + 1L < pos2) {
                        int low = b[idx++] & 0xFF;
                        if (high > 32 && high < 127 && low > 32 && low < 127) {
                            buf.append(ByteUtil.jisx0208ToString((byte[])b, (int)(idx - 2), (int)2));
                            continue;
                        }
                        if (high > 32 && high > 127 && low > 160 && low < 255) {
                            buf.append("??");
                            continue;
                        }
                        if (high > 160 && high < 255 && low > 32 && low < 127) {
                            buf.append("??");
                            continue;
                        }
                        buf.append("..");
                        continue;
                    }
                    buf.append(". ");
                    continue;
                }
                buf.append(' ');
                if (i + (long)j + 1L >= pos && i + (long)j + 1L < pos2) {
                    ++idx;
                    buf.append('.');
                    continue;
                }
                buf.append(' ');
            }
            System.out.println(buf.toString());
            System.out.flush();
            buf.delete(0, buf.length());
        }
    }

    private String _toHexString(byte hex) {
        return this._toHexString(Integer.toHexString(hex & 0xFF), 2);
    }

    private String _toHexString(int hex) {
        return this._toHexString(Integer.toHexString(hex), 3);
    }

    private String _toHexString(long hex) {
        return this._toHexString(Long.toHexString(hex), 5);
    }

    private String _toHexString(String str, int length) {
        StringBuffer buf = new StringBuffer(str.toUpperCase());
        int len = str.length();
        len = len < length ? length - len : 0;
        for (int i = 0; i < len; ++i) {
            buf.insert(0, '0');
        }
        return buf.toString();
    }
}

