package fuku.eb4j.io;

import java.io.*;

/**
 * ファイル情報クラス。
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.5
 */
final class FileInfo {

    /** ファイル */
    File file = null;
    /** フォーマット形式 */
    int format = EBFile.FORMAT_PLAIN;

    /** ファイルサイズ */
    long fileSize = 0;
    /** 実ファイルサイズ */
    long realFileSize = 0;
    /** スライスサイズ */
    int sliceSize = BookInputStream.PAGE_SIZE;

    /** 圧縮レベル (for EBZIP) */
    int zipLevel = 0;
    /** インデックスサイズ (for EBZIP) */
    int zipIndexSize = 0;
    /** CRC (for EBZIP) */
    long zipCrc = 0;

    /** インデックステーブルの位置 (for EPWING) */
    long epwingIndexPos = 0;
    /** インデックステーブルのサイズ (for EPWING) */
    long epwingIndexSize = 0;
    /** 頻度テーブルの位置 (for EPWING) */
    long epwingFreqPos = 0;
    /** 頻度テーブルのサイズ (for EPWING) */
    long epwingFreqSize = 0;
    /** ハフマンツリーのルートノード (for EPWING) */
    HuffmanNode epwingRootNode = null;

    /** インデックス開始位置 (for S-EBXA) */
    long sebxaIndexPos = 0;
    /** 圧縮本文開始位置 (for S-EBXA) */
    long sebxaBasePos = 0;
    /** 本文開始位置 (for S-EBXA) */
    long sebxaStartPos = 0;
    /** 本文終了位置 (for S-EBXA) */
    long sebxaEndPos = 0;


    /**
     * コンストラクタ。
     *
     */
    FileInfo() {
        super();
    }
}

// end of FileInfo.java
