package fuku.webbook;

/**
 * 文字種別判別クラス。
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.5
 */
public final class CharType {

    /**
     * コンストラクタ。
     *
     */
    private CharType() {
        super();
    }


    /**
     * 英字かどうかを判定します。
     *
     * @param ch 文字
     * @return 英字の場合はtrue、そうでない場合はfalse
     */
    public static boolean isAlpha(char ch) {
        if ((ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z')) {
            return true;
        }
        return false;
    }

    /**
     * 数字かどうかを判定します。
     *
     * @param ch 文字
     * @return 数字の場合はtrue、そうでない場合はfalse
     */
    public static boolean isDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        return false;
    }

    /**
     * 16進数での数字かどうかを判定します。
     *
     * @param ch 文字
     * @return 16進数での数字の場合はtrue、そうでない場合はfalse
     */
    public static boolean isXDigit(char ch) {
        if ((ch >= 'a' && ch <= 'f')
            || (ch >= 'A' && ch <= 'F')
            || (ch >= '0' && ch <= '9')) {
            return true;
        }
        return false;
    }

    /**
     * 英字または数字かどうかを判定します。
     *
     * @param ch 文字
     * @return 英字または数字の場合はtrue、そうでない場合はfalse
     */
    public static boolean isAlphaNum(char ch) {
        if ((ch >= 'a' && ch <= 'z')
            || (ch >= 'A' && ch <= 'Z')
            || (ch >= '0' && ch <= '9')) {
            return true;
        }
        return false;
    }

    /**
     * 空白文字かどうかを調べます。
     *
     * @param ch 文字
     * @return 空白文字の場合はtrue、そうでない場合はfalse
     */
    public static boolean isSpace(char ch) {
        if (ch == ' ' || ch == '\f'
            || ch == '\n' || ch == '\r' || ch == '\t') {
            return true;
        }
        return false;
    }
}

// end of CharType.java
