package fuku.webbook;

import java.io.*;
import java.net.*;
import javax.servlet.*;

/**
 * WebBookイベントリスナクラス。
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.5
 */
public final class WebBookListener implements ServletContextListener {

    /**
     * Webアプリケーションが要求を処理する準備ができたときに呼び出されます。
     *
     * @param evt サーブレットコンテキストイベント
     */
    public void contextInitialized(ServletContextEvent evt) {
        ServletContext context = evt.getServletContext();
        WebBook webbook = new WebBook();
        String config = context.getInitParameter("config");
        URL url = null;
        try {
            url = context.getResource(config);
        } catch (MalformedURLException e) {
        }
        if (url != null) {
            context.log("load configuration file: " + url.toString());
            try {
                webbook.setConfig(new WebBookConfig(url, context));
            } catch (Exception e) {
                context.log("failed to initialization", e);
            }
        }
        context.setAttribute("webbook", webbook);
    }

    /**
     * サーブレットコンテキストがシャットダウン処理に入ると呼び出されます。
     *
     * @param evt サーブレットコンテキストイベント
     */
    public void contextDestroyed(ServletContextEvent evt) {
        ServletContext context = evt.getServletContext();
        context.removeAttribute("webbook");
    }
}

// end of WebBookListener.java
