package fuku.webbook;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import fuku.eb4j.SubBook;
import fuku.eb4j.Result;

/**
 * WebBookサーブレットクラス。
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.5
 */
public final class WebBookServlet extends HttpServlet {

    /** デフォルトの文字セット */
    private static final String CHARSET = "UTF-8";


    /**
     * GETリクエストの処理。
     *
     * @param req クライアントからのリクエスト
     * @param res クライアントへ返すレスポンス
     * @exception ServletException GETに相当するリクエストが処理できない場合
     * @exception IOException GETリクエストの処理中に入出力エラーが発生した場合
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {
        doPost(req, res);
    }

    /**
     * POSTリクエストの処理。
     *
     * @param req クライアントからのリクエスト
     * @param res クライアントへ返すレスポンス
     * @exception ServletException POSTに相当するリクエストが処理できない場合
     * @exception IOException POSTリクエストの処理中に入出力エラーが発生した場合
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {

        // サーブレットコンテキストから書籍管理オブジェクト取得
        WebBook webbook = (WebBook)getServletContext().getAttribute("webbook");

        req.setCharacterEncoding(CHARSET);
        HttpSession session = req.getSession(true);

        // アクション
        String act = req.getParameter("act");
        if (act == null) {
            act = "";
        }

        Result[][] results = null;
        try {
            if (act.equals("wordsearch")) {
                // 前方一致/後方一致/完全一致/条件検索
                String word = req.getParameter("word");
                String book = req.getParameter("book");
                int method = Integer.parseInt(req.getParameter("method"));
                // 最大数をクッキーから取得
                int max = 10;
                Cookie[] cookies = req.getCookies();
                if (cookies != null) {
                    int len = cookies.length;
                    for (int i=0; i<len; i++) {
                        if (cookies[i].getName().equals("webbook")) {
                            String v = cookies[i].getValue();
                            try {
                                max = Integer.parseInt(v.substring(1, 2)) * 10;
                            } catch (NumberFormatException e) {
                            } catch (IndexOutOfBoundsException e) {
                            }
                        }
                    }
                }
                if (word != null && word.trim().length() > 0) {
                    results = webbook.search(req.getRemoteHost(),
                                             book, word, method, max);
                }
            } else if (act.equals("multisearch")) {
                // 複合検索
                String book = req.getParameter("book");
                int multi =  Integer.parseInt(req.getParameter("multi"));
                String host = req.getRemoteHost();
                SubBook sub = webbook.getSubBook(host, book);
                if (sub != null) {
                    int count = sub.getMultiEntryCount(multi);
                    ArrayList list = new ArrayList(count);
                    for (int i=0; i<count; i++) {
                        list.add(_convert(req.getParameter("key" + i)));
                    }
                    String[] keys = (String[])list.toArray(new String[0]);
                    results = webbook.search(host, book, multi, keys);
                }
            } else if (act.equals("preference")) {
                // 設定をクッキーに保存
                StringBuffer val = new StringBuffer(4);
                val.append(req.getParameter("method"));
                val.append(req.getParameter("num"));
                val.append(req.getParameter("inline"));
                val.append(req.getParameter("applet"));
                Cookie cookie = new Cookie("webbook", val.toString());
                cookie.setMaxAge(Integer.MAX_VALUE);
                cookie.setSecure(false);
                res.addCookie(cookie);
            }
        } catch (NumberFormatException e) {
        }

        if (session != null) {
            session.setAttribute("results", results);
        }

        String target = req.getParameter("target");
        if (target == null) {
            target = "index.html";
        }
        req.getRequestDispatcher(target).forward(req, res);
    }

    /**
     * 文字列中に含まれる"[N-####]/[W-####]"を"\####"に変換します。
     *
     * @param str 変換対象文字列
     * @return 変換後の文字列
     */
    private String _convert(String str) {
        if (str == null) {
            return new String();
        }
        StringBuffer buf = new StringBuffer(str);

        // 半角外字
        int idx1 = buf.indexOf("[N-", 0);
        int idx2 = 0;
        while (idx1 >= 0) {
            buf.replace(idx1, idx1+3, "\\");
            idx2 = buf.indexOf("]", idx1+1);
            buf.deleteCharAt(idx2);
            idx1 = buf.indexOf("[N-", idx2+1);
        }

        // 全角外字
        idx1 = buf.indexOf("[W-", 0);
        idx2 = 0;
        while (idx1 >= 0) {
            buf.replace(idx1, idx1+3, "\\");
            idx2 = buf.indexOf("]", idx1+1);
            buf.deleteCharAt(idx2);
            idx1 = buf.indexOf("[W-", idx2+1);
        }

        return buf.toString();
    }
}

// end of WebBookServlet.java
