package fuku.xml2eb;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ErrorHandler;

import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.Log;

/**
 * エラーハンドラ。
 *
 * @author Hisaya FUKUMOTO
 */
class LoggingErrorHandler implements ErrorHandler {

    /** ログ */
    private transient Log _log = null;


    /**
     * コンストラクタ。
     *
     */
    public LoggingErrorHandler() {
        super();
        _log = LogFactory.getLog(getClass());
    }


    /**
     * 回復できないエラーの通知を受け取ります。
     *
     * @param exp SAX構文解析例外にカプセル化されたエラー情報
     * @exception SAXException SAX例外
     */
    public void fatalError(SAXParseException exp) throws SAXException {
        _log.fatal("[" + exp.getLineNumber()
                   + ":" + exp.getColumnNumber() + "] "
                   + exp.getMessage());
    }

    /**
     * 回復可能なエラーの通知を受け取ります。
     *
     * @param exp SAX構文解析例外にカプセル化されたエラー情報
     * @exception SAXException SAX例外
     */
    public void error(SAXParseException exp) throws SAXException {
        _log.error("[" + exp.getLineNumber()
                   + ":" + exp.getColumnNumber() + "] "
                   + exp.getMessage());
    }

    /**
     * 警告の通知を受け取ります。
     *
     * @param exp SAX構文解析例外にカプセル化されたエラー情報
     * @exception SAXException SAX例外
     */
    public void warning(SAXParseException exp) throws SAXException {
        _log.warn("[" + exp.getLineNumber()
                  + ":" + exp.getColumnNumber() + "] "
                  + exp.getMessage());
    }
}

// end of LoggingErrorHandler.java
