package fuku.eb4j;

import java.io.*;

import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.util.ByteUtil;

/**
 * եȥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
*/
public final class ExtFont {

    /** ѥեȤ򼨤 */
    static final int WIDE = 0;
    /** ȾѥեȤ򼨤 */
    static final int NARROW = 1;

    /** 16ɥåȤΥեȤ򼨤 */
    public static final int FONT_16 = 0;
    /** 24ɥåȤΥեȤ򼨤 */
    public static final int FONT_24 = 1;
    /** 30ɥåȤΥեȤ򼨤 */
    public static final int FONT_30 = 2;
    /** 48ɥåȤΥեȤ򼨤 */
    public static final int FONT_48 = 3;

    /** եȥ */
    private static final int[][] FONT_SIZE = {
        // (FONT_WIDTH / 8) * FONT_HEIGHT
        {32, 72,120, 288}, {16, 48, 60, 144}};
    /** եȤ */
    private static final int[][] FONT_WIDTH = {
        {16, 24, 32, 48}, {8, 16, 16, 24}};
    /** եȤι⤵ */
    private static final int[] FONT_HEIGHT = {16, 24, 30, 48};


    /**  */
    private SubBook _sub = null;
    /** μ */
    private int _fontType = -1;


    /** ե */
    private EBFile[] _file = new EBFile[2];
    /** ϥڡ */
    private long[] _page = new long[2];

    /** ʸ */
    private int[] _start = new int[2];
    /** λʸ */
    private int[] _end = new int[2];


    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param type μ
     * @see ExtFont#FONT_16
     * @see ExtFont#FONT_24
     * @see ExtFont#FONT_30
     * @see ExtFont#FONT_48
     * @exception IllegalArgumentException μबʾ
     */
    ExtFont(SubBook sub, int type) {
        super();
        _sub = sub;
        if (type < FONT_16 || type > FONT_48) {
            throw new IllegalArgumentException("Illegal font type: "
                                               + Integer.toString(type));
        }
        _fontType = type;
    }


    /**
     * ξɤ߹ߤޤ
     *
     * @param kind Ⱦ/
     * @exception EBException եɤ߹˥顼ȯ
     * @see ExtFont#WIDE
     * @see ExtFont#NARROW
     */
    private void _loadFont(int kind) throws EBException {
        byte[] b = new byte[16];

        BookInputStream bis = _file[kind].getInputStream();
        try {
            bis.seek(_page[kind], 0);
            bis.readFully(b, 0, b.length);
        } finally {
            bis.close();
        }

        int charCount = ByteUtil.getInt2(b, 12);
        if (charCount == 0) { // ʸ0ξϳ¸ߤʤ
            _file[kind] = null;
            return;
        }

        _start[kind] = ByteUtil.getInt2(b, 10);
        if (_sub.getBook().getCharCode() == Book.CHARCODE_ISO8859_1) {
            _end[kind] = (_start[kind]
                          + ((charCount / 0xfe) << 8)
                          + (charCount % 0xfe) - 1);
            if ((_end[kind] & 0xff) > 0xfe) {
                _end[kind] += 0x03;
            }
            if ((_start[kind] & 0xff) < 0x01
                || (_start[kind] & 0xff) > 0xfe
                || _start[kind] < 0x0001
                || _end[kind] > 0x1efe) {
                throw new EBException(EBException.UNEXP_FILE,
                                      _file[kind].getPath());
            }
        } else {
            _end[kind] = (_start[kind]
                          + ((charCount / 0x5e) << 8)
                          + (charCount % 0x5e) - 1);
            if ((_end[kind] & 0xff) > 0x7e) {
                _end[kind] += 0xa3;
            }
            if ((_start[kind] & 0xff) < 0x21
                || (_start[kind] & 0xff) > 0x7e
                || _start[kind] < 0xa121
                || _end[kind] > 0xfe7e) {
                throw new EBException(EBException.UNEXP_FILE,
                                      _file[kind].getPath());
            }
        }
    }

    /**
     * Ⱦѳե֤ޤ
     *
     * @return ե
     */
    public EBFile getNarrowFontFile() {
        if (_file[NARROW] == null) {
            return null;
        }
        return _file[NARROW];
    }

    /**
     * ѳե֤ޤ
     *
     * @return ե
     */
    public EBFile getWideFontFile() {
        if (_file[WIDE] == null) {
            return null;
        }
        return _file[WIDE];
    }

    /**
     * Ⱦѳꤷޤ
     *
     * @param file ե
     * @param page ϥڡ
     * @exception EBException եɤ߹˥顼ȯ
     */
    void setNarrowFont(EBFile file, long page) throws EBException {
        _file[NARROW] = file;
        _page[NARROW] = page;
        _loadFont(NARROW);
    }

    /**
     * ѳꤷޤ
     *
     * @param file ե
     * @param page ϥڡ
     * @exception EBException եɤ߹˥顼ȯ
     */
    void setWideFont(EBFile file, long page) throws EBException {
        _file[WIDE] = file;
        _page[WIDE] = page;
        _loadFont(WIDE);
    }

    /**
     * ¸ߤ뤫ɤ֤ޤ
     *
     * @return ¸ߤtrueǤʤfalse
     */
    public boolean hasFont() {
        if (_file[NARROW] == null && _file[WIDE] == null) {
            return false;
        }
        return true;
    }

    /**
     * Ⱦѳ¸ߤ뤫ɤ֤ޤ
     *
     * @return Ⱦѳ¸ߤtrueǤʤfalse
     */
    public boolean hasNarrowFont() {
        if (_file[NARROW] == null) {
            return false;
        }
        return true;
    }

    /**
     * ѳ¸ߤ뤫ɤ֤ޤ
     *
     * @return ѳ¸ߤtrueǤʤfalse
     */
    public boolean hasWideFont() {
        if (_file[WIDE] == null) {
            return false;
        }
        return true;
    }

    /**
     * μ֤ޤ
     *
     * @return μ
     * @see ExtFont#FONT_16
     * @see ExtFont#FONT_24
     * @see ExtFont#FONT_30
     * @see ExtFont#FONT_48
     */
    public int getFontType() {
        return _fontType;
    }

    /**
     * եȤι⤵֤ޤ
     *
     * @return եȤι⤵
     */
    public int getFontHeight() {
        return FONT_HEIGHT[_fontType];
    }

    /**
     * Ⱦѳγʸɤ֤ޤ
     *
     * @return Ⱦѳγʸ
     */
    public int getNarrowFontStart() {
        return _start[NARROW];
    }

    /**
     * ѳγʸɤ֤ޤ
     *
     * @return ѳγʸ
     */
    public int getWideFontStart() {
        return _start[WIDE];
    }

    /**
     * Ⱦѳνλʸɤ֤ޤ
     *
     * @return Ⱦѳνλʸ
     */
    public int getNarrowFontEnd() {
        return _end[NARROW];
    }

    /**
     * ѳνλʸɤ֤ޤ
     *
     * @return ѳνλʸ
     */
    public int getWideFontEnd() {
        return _end[WIDE];
    }

    /**
     * Ⱦѳ֤ޤ
     *
     * @return Ⱦѳ
     */
    public int getNarrowFontWidth() {
        return FONT_WIDTH[NARROW][_fontType];
    }

    /**
     * ѳ֤ޤ
     *
     * @return ѳ
     */
    public int getWideFontWidth() {
        return FONT_WIDTH[WIDE][_fontType];
    }

    /**
     * ȾѳΥ֤ޤ
     *
     * @return ȾѳΥ
     */
    public int getNarrowFontSize() {
        return FONT_SIZE[NARROW][_fontType];
    }

    /**
     * ѳΥ֤ޤ
     *
     * @return ѳΥ
     */
    public int getWideFontSize() {
        return FONT_SIZE[WIDE][_fontType];
    }

    /**
     * ꤵ줿ʸɤȾѳӥåȥޥåץǡ֤ޤ
     *
     * @param code ʸ
     * @return ȾѳΥӥåȥޥåץǡ (¸ߤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     */
    public byte[] getNarrowFont(int code) throws EBException {
        return _getFont(NARROW, code);
    }

    /**
     * ꤵ줿ʸɤѳӥåȥޥåץǡ֤ޤ
     *
     * @param code ʸ
     * @return ѳΥӥåȥޥåץǡ (¸ߤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     */
    public byte[] getWideFont(int code) throws EBException {
        return _getFont(WIDE, code);
    }

    /**
     * ꤵ줿ʸɤγӥåȥޥåץǡ֤ޤ
     *
     * @param kind Ⱦ/
     * @param code ʸ
     * @return Υӥåȥޥåץǡ (¸ߤʤnull)
     * @exception EBException եɤ߹˥顼ȯ
     * @see ExtFont#WIDE
     * @see ExtFont#NARROW
     */
    private byte[] _getFont(int kind, int code) throws EBException {
        if (_file[kind] == null) {
            return null;
        }
        if (code < _start[kind] || code > _end[kind]) {
            return null;
        }

        int index = 0;
        if (_sub.getBook().getCharCode() == Book.CHARCODE_ISO8859_1) {
            if ((code & 0xff) < 0x01 || (code & 0xff) > 0xfe) {
                return null;
            }
            index = (((code >>> 8) - (_start[kind] >>> 8)) * 0xfe
                     + ((code & 0xff) - (_start[kind] & 0xff)));
        } else {
            if ((code & 0xff) < 0x21 || (code & 0xff) > 0x7e) {
                return null;
            }
            index = (((code >>> 8) - (_start[kind] >>> 8)) * 0x5e
                     + ((code & 0xff) - (_start[kind] & 0xff)));
        }

        int size = FONT_SIZE[kind][_fontType];
        int off = ((index / (1024 / size)) * 1024
                   + (index % (1024 / size)) * size);

        byte[] b = new byte[size];
        BookInputStream bis = _file[kind].getInputStream();
        try {
            bis.seek(_page[kind]+1, off);
            bis.readFully(b, 0, b.length);
        } finally {
            bis.close();
        }
        return b;
    }
}

// end of ExtFont.java
