package fuku.eb4j.hook;

import fuku.eb4j.SubAppendix;
import fuku.eb4j.SubBook;
import fuku.eb4j.EBException;
import fuku.eb4j.util.ByteUtil;

/**
 * ǥեȥץ󥹲ù饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public class DefaultHook extends HookAdapter {

    /** ϹԿ */
    private int _maxLine = 500;

    /** ȾɽϤƤ뤫ɤ򼨤ե饰 */
    private boolean _narrow = false;
    /** Կ */
    private int _line = 0;

    /** ʸХåե */
    private StringBuffer _buf = new StringBuffer(2048);

    /** Ͽѥ */
    private SubAppendix _appendix = null;


    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     */
    public DefaultHook(SubBook sub) {
        this(sub, 500);
    }

    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param maxLine ɤ߹߹Կ
     */
    public DefaultHook(SubBook sub, int maxLine) {
        super();
        _appendix = sub.getAppendix();
        _maxLine = maxLine;
    }


    /**
     * ٤ƤϤ򥯥ꥢޤ
     *
     */
    public void clear() {
        _buf.delete(0, _buf.length());
        _narrow = false;
        _line = 0;
    }

    /**
     * եåˤäƲù줿֥Ȥ֤ޤ
     *
     * @return ʸ󥪥֥
     */
    public Object getObject() {
        return _buf.toString();
    }

    /**
     * Ϥǽɤ֤ޤ
     *
     * @return ޤϤĤtrueǤʤfalse
     */
    public boolean isMoreInput() {
        if (_line >= _maxLine) {
            return false;
        }
        return true;
    }

    /**
     * ʸɲäޤ
     *
     * @param str ʸ
     */
    public void append(String str) {
        if (_narrow) {
            str = ByteUtil.wideToNarrow(str);
        }
        _buf.append(str);
    }

    /**
     * ɲäޤ<BR>
     * ϿѥåʸлѤʤ
     * "[GAIJI=Ncode]", "[GAIJI=Wcode]"Ѵɲäޤ
     *
     * @param code ʸ
     */
    public void append(int code) {
        String str = null;
        if (_narrow) {
            if (_appendix != null) {
                try {
                    str = _appendix.getNarrowFontAlt(code);
                } catch (EBException e) {
                }
            }
            if (str == null) {
                str = "[GAIJI=n" + Integer.toHexString(code).toUpperCase() + "]";
            }
        } else {
            if (_appendix != null) {
                try {
                    str = _appendix.getWideFontAlt(code);
                } catch (EBException e) {
                }
            }
            if (str == null) {
                str = "[GAIJI=w" + Integer.toHexString(code).toUpperCase() + "]";
            }
        }
        _buf.append(str);
    }

    /**
     * ȾɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginNarrow() {
        _narrow = true;
    }

    /**
     * Ⱦɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endNarrow() {
        _narrow = false;
    }

    /**
     * Ԥɽץ󥹤ФեåǤ
     *
     */
    public void newLine() {
        _buf.append('\n');
        _line++;
    }
}

// end of DefaultHook.java
