package fuku.eb4j.io;

import java.io.*;
import java.util.*;

import fuku.eb4j.EBException;

/**
 * ϥȥ꡼δ쥯饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public abstract class BookInputStream {

    /** ڡ */
    public static final int PAGE_SIZE = 2048;

    /** ե */
    protected FileInfo _info = null;
    /** ϥȥ꡼ */
    protected RandomAccessFile _stream = null;
    /** եݥ󥿰 */
    protected long _filePos = 0;

    /** å */
    protected byte[] _cache = new byte[PAGE_SIZE];
    /** åǡΥեݥ󥿰 */
    protected long _cachePos = -1;


    /**
     * 󥹥ȥ饯
     *
     * @param info ե
     */
    protected BookInputStream(FileInfo info) {
        super();
        _info = info;
    }


    /**
     * ΥեΥե륵֤ޤ
     *
     * @return ե륵
     */
    public final long getFileSize() {
        return _info.fileSize;
    }

    /**
     * Υեμ¥ե륵֤ޤ
     *
     * @return ¥ե륵
     */
    public final long getRealFileSize() {
        return _info.realFileSize;
    }

    /**
     * ΥեΥ饤֤ޤ
     *
     * @return 饤
     */
    public final int getSliceSize() {
        return _info.sliceSize;
    }

    /**
     * Υե򳫤ޤ
     *
     * @exception EBException ϥ顼ȯ
     */
    protected final void open() throws EBException {
        if (_stream != null) {
            close();
        }

        try {
            _stream = new RandomAccessFile(_info.file, "r");
        } catch (FileNotFoundException e) {
            EBException exp =  new EBException(EBException.FILE_NOT_FOUND,
                                               _info.file.getPath());
            exp.setStackTrace(e.getStackTrace());
            throw exp;
        }
        _filePos = 0;
    }

    /**
     * ΥեĤޤ
     *
     */
    public final void close() {
        if (_stream != null) {
            try {
                _stream.close();
            } catch (IOException e) {
            }
            _stream = null;
        }
    }

    /**
     * Υե뤫b.lengthХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @exception EBException ϥ顼ȯ
     */
    public final void readFully(byte[] b) throws EBException {
        readFully(b, 0, b.length);
    }

    /**
     * Υե뤫lenХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @param off ǡγϥեå
     * @param len ɤ߹ޤХȿ
     * @exception EBException ϥ顼ȯ
     */
    public final void readFully(byte[] b, int off, int len) throws EBException {
        int rlen = len;
        int offset = off;
        while (rlen > 0) {
            int n = read(b, offset, rlen);
            if (n == -1) {
                throw new EBException(EBException.FAILED_READ_FILE,
                                      _info.file.getPath());
            }
            rlen -= n;
            offset += n;
        }
    }

    /**
     * Υե뤫b.lengthХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @return Хåեɤ߹ޤ줿ХȤι׿
     *         (ȥ꡼νãƥǡʤ-1)
     * @exception EBException ϥ顼ȯ
     */
    public final int read(byte[] b) throws EBException {
        return read(b, 0, b.length);
    }

    /**
     * Υե뤫lenХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @param off ǡγϥեå
     * @param len ɤ߹ޤХȿ
     * @return Хåեɤ߹ޤ줿ХȤι׿
     *         (ȥ꡼νãƥǡʤ-1)
     * @exception EBException ϥ顼ȯ
     */
    public abstract int read(byte[] b, int off, int len) throws EBException;

    /**
     * ֤˥եݥ󥿤ꤷޤ
     *
     * @param page ڡֹ
     * @param offset ڡ⥪եå
     */
    public final void seek(long page, int offset) {
        seek(getPosition(page, offset));
    }

    /**
     * ֤˥եݥ󥿤ꤷޤ
     *
     * @param pos ǡ
     */
    public final void seek(long pos) {
        if (pos < 0) {
            _filePos = 0;
        } else if (pos > _info.fileSize) {
            _filePos = _info.fileSize;
        } else {
            _filePos = pos;
        }
    }

    /**
     * Υե뤫b.lengthХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @return Хåեɤ߹ޤ줿ХȤι׿
     *         (ȥ꡼νãƥǡʤ-1)
     * @exception EBException ϥ顼ȯ
     */
    protected final int readRaw(byte[] b) throws EBException {
        return readRaw(b, 0, b.length);
    }

    /**
     * Υե뤫lenХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @param off ǡγϥեå
     * @param len ɤ߹ޤХȿ
     * @return Хåեɤ߹ޤ줿ХȤι׿
     *         (ȥ꡼νãƥǡʤ-1)
     * @exception EBException ϥ顼ȯ
     */
    protected final int readRaw(byte[] b, int off, int len) throws EBException {
        int ret = -1;
        try {
            ret = _stream.read(b, off, len);
        } catch (IOException e) {
            throw new EBException(EBException.FAILED_READ_FILE,
                                  _info.file.getPath(), e);
        }
        return ret;
    }

    /**
     * Υե뤫b.lengthХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @exception EBException ϥ顼ȯ
     */
    protected final void readRawFully(byte[] b) throws EBException {
        readRawFully(b, 0, b.length);
    }

    /**
     * Υե뤫lenХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @param off ǡγϥեå
     * @param len ɤ߹ޤХȿ
     * @exception EBException ϥ顼ȯ
     */
    protected final void readRawFully(byte[] b, int off, int len) throws EBException {
        try {
            _stream.readFully(b, off, len);
        } catch (EOFException e) {
            throw new EBException(EBException.FAILED_READ_FILE,
                                  _info.file.getPath(), e);
        } catch (IOException e) {
            throw new EBException(EBException.FAILED_READ_FILE,
                                  _info.file.getPath(), e);
        }
    }

    /**
     * եƬΰ֤֤ޤ
     *
     * @param page ڡֹ
     * @param offset ڡ⥪եå
     * @return Ƭΰ
     */
    public static final long getPosition(long page, int offset) {
        return (page - 1) * PAGE_SIZE + offset;
    }

    /**
     * ڡֹ֤ޤ
     *
     * @param pos Ƭΰ
     * @return ڡֹ
     */
    public static final long getPage(long pos) {
        return pos / PAGE_SIZE + 1;
    }

    /**
     * ڡ⥪եåȤ֤ޤ
     *
     * @param pos Ƭΰ
     * @return ڡ⥪եå
     */
    public static final int getOffset(long pos) {
        return (int)(pos % PAGE_SIZE);
    }
}

// end of BookInputStream.java
