package fuku.eb4j.io;

import java.io.*;
import java.util.*;

import fuku.eb4j.EBException;
import fuku.eb4j.util.ByteUtil;

/**
 * EPWINGνϥȥ꡼९饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class EPWINGInputStream extends BookInputStream {

    /**
     * 󥹥ȥ饯
     *
     * @param info ե
     * @exception EBException ϥ顼ȯ
     */
    EPWINGInputStream(FileInfo info) throws EBException {
        super(info);
        synchronized (info) {
            if (info.realFileSize <= 0) {
                try {
                    open();
                    _init();
                } finally {
                    close();
                }
            }
        }
    }


    /**
     * EPWINGΥեޤ
     *
     * @exception EBException ϥ顼ȯ
     */
    private void _init() throws EBException {
        try {
            _info.realFileSize = _stream.length();
        } catch (IOException e) {
            throw new EBException(EBException.FAILED_READ_FILE,
                                  _info.file.getPath(), e);
        }

        byte[] b = new byte[512];

        // إåɤ߹
        int len = 32;
        if (_info.format == EBFile.FORMAT_EPWING6) {
            len += 16;
        }
        readRawFully(b, 0, len);

        _info.epwingIndexPos = ByteUtil.getLong4(b, 0);
        _info.epwingIndexSize = ByteUtil.getLong4(b, 4);
        _info.epwingFreqPos = ByteUtil.getLong4(b, 8);
        _info.epwingFreqSize = ByteUtil.getLong4(b, 12);
        if (_info.epwingIndexSize < 36 || _info.epwingFreqSize < 512) {
            throw new EBException(EBException.UNEXP_FILE, _info.file.getPath());
        }

        // ե륵μ
        long pos = _info.epwingIndexPos + (_info.epwingIndexSize - 36) / 36 * 36;
        try {
            _stream.seek(pos);
        } catch (IOException e) {
            throw new EBException(EBException.FAILED_SEEK_FILE,
                                  _info.file.getPath(), e);
        }
        readRawFully(b, 0, 36);
        _info.fileSize = (_info.epwingIndexSize / 36) * (PAGE_SIZE * 16);
        for (int i=0; i<16; i++) {
            int p = i * 2 + 4 + 2;
            if (ByteUtil.getInt2(b, p) == 0) {
                _info.fileSize = _info.fileSize - PAGE_SIZE * (16 - i);
                break;
            }
        }

        int leaf32 = 0;
        int leaf16 = 0;
        if (_info.format == EBFile.FORMAT_EPWING) {
            leaf16 = (int)((_info.epwingFreqSize - (256 * 2)) / 4);
        } else {
            leaf16 = 0x400;
            leaf32 = (int)((_info.epwingFreqSize - (leaf16 * 4) - (256 * 2)) / 6);
        }

        List list = null;
        // 32bitǡΥϥեޥΡɺ
        if (_info.format == EBFile.FORMAT_EPWING6) {
            list = new ArrayList(leaf32 + leaf16 + 256 + 1);
            len = b.length - (b.length % 6);
            try {
                _stream.seek(_info.epwingFreqPos);
            } catch (IOException e) {
                throw new EBException(EBException.FAILED_SEEK_FILE,
                                      _info.file.getPath(), e);
            }
            readRawFully(b, 0, len);
            for (int i=0, off=0; i<leaf32; i++, off+=6) {
                if (off >= b.length) {
                    readRawFully(b, 0, len);
                    off = 0;
                }
                long value = ByteUtil.getLong4(b, off);
                int freq = ByteUtil.getInt2(b, off+4);
                list.add(new HuffmanNode(value, freq, HuffmanNode.LEAF_32));
            }
        } else {
            list = new ArrayList(leaf16 + 256 + 1);
        }

        // 16bitǡΥϥեޥΡɺ
        len = b.length - (b.length % 4);
        try {
            _stream.seek(_info.epwingFreqPos + leaf32 * 6);
        } catch (IOException e) {
            throw new EBException(EBException.FAILED_SEEK_FILE,
                                  _info.file.getPath(), e);
        }
        readRawFully(b, 0, len);
        for (int i=0, off=0; i<leaf16; i++, off+=4) {
            if (off >= b.length) {
                readRawFully(b, 0, len);
                off = 0;
            }
            long value = ByteUtil.getInt2(b, off);
            int freq = ByteUtil.getInt2(b, off+2);
            list.add(new HuffmanNode(value, freq, HuffmanNode.LEAF_16));
        }

        // 8bitǡΥϥեޥΡɺ
        try {
            _stream.seek(_info.epwingFreqPos + leaf32 * 6 + leaf16 * 4);
        } catch (IOException e) {
            throw new EBException(EBException.FAILED_SEEK_FILE,
                                  _info.file.getPath(), e);
        }
        readRawFully(b, 0, b.length);
        for (int i=0, off=0; i<256; i++, off+=2) {
            int freq = ByteUtil.getInt2(b, off);
            list.add(new HuffmanNode(i, freq, HuffmanNode.LEAF_8));
            off += 2;
        }

        // EOFǡΥϥեޥΡɺ
        list.add(new HuffmanNode(256, 1, HuffmanNode.LEAF_EOF));

        // ϥեޥĥ꡼κ
        _info.epwingRootNode = HuffmanNode.makeTree(list);
    }

    /**
     * EPWINGΥե뤫b.lengthХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @param off ǡγϥեå
     * @param len ɤ߹ޤХȿ
     * @return Хåեɤ߹ޤ줿ХȤι׿
     *         (ȥ꡼νãƥǡʤ-1)
     * @exception EBException ϥ顼ȯ
     */
    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            if (_info.fileSize <= _filePos) {
                if (rlen == 0) {
                    return -1;
                } else {
                    return rlen;
                }
            }
            // åκ
            if (_cachePos < 0
                || _filePos < _cachePos
                || _cachePos + PAGE_SIZE <= _filePos) {
                _cachePos = _filePos - (_filePos % PAGE_SIZE);

                // ǥåɤ߹
                long pos = _info.epwingIndexPos + _filePos / (PAGE_SIZE * 16) * 36;
                try {
                    _stream.seek(pos);
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_SEEK_FILE,
                                          _info.file.getPath(), e);
                }
                byte[] buf = new byte[36];
                readRawFully(buf, 0, buf.length);

                // ڡ֤μ
                int offset = (int)(4 + (_filePos / PAGE_SIZE % 16) * 2);
                long pagePos = (ByteUtil.getLong4(buf, 0)
                                + ByteUtil.getInt2(buf, offset));

                // ̥ڡǥɤƥåɤ߹
                try {
                    _stream.seek(pagePos);
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_SEEK_FILE,
                                          _info.file.getPath(), e);
                }
                _decode();
            }

            // å夫ǡμ
            int n = (int)(PAGE_SIZE - (_filePos % PAGE_SIZE));
            if (len - rlen < n) {
                n = len - rlen;
            }
            if (_info.fileSize - _filePos < n) {
                n = (int)(_info.fileSize - _filePos);
            }
            int p = (int)(_filePos - _cachePos);
            System.arraycopy(_cache, p, b, off+rlen, n);
            rlen += n;
            _filePos += n;
        }
        return rlen;
    }

    /**
     * 沽ޤ
     *
     * @exception EBException ϥ顼ȯ
     */
    private void _decode() throws EBException {
        byte[] b = new byte[PAGE_SIZE];
        int inPos = 0;
        int inLen = 0;
        int outPos = 0;
        int outLen = 0;
        int bitIndex = 7;

        if (_info.format == EBFile.FORMAT_EPWING6) {
            // ̷μ
            readRawFully(b, 0, 1);
            if ((b[0] & 0xff) != 0) {
                // ̵̤ʤΤǤΤޤɤ߹
                readRawFully(_cache, 0, PAGE_SIZE);
                return;
            }
        }

        while (outLen < PAGE_SIZE) {
            HuffmanNode node = _info.epwingRootNode;
            while (!node.isLeaf()) {
                // ǡʤмɤ߹
                if (inLen <= inPos) {
                    inLen = readRaw(b, 0, b.length);
                    if (inLen <=0) {
                        throw new EBException(EBException.UNEXP_FILE,
                                              _info.file.getPath());
                    }
                    inPos = 0;
                }
                int bit = (b[inPos] >>> bitIndex) & 0x01;
                if (bit == 1) {
                    node = node.getLeft();
                } else {
                    node = node.getRight();
                }
                if (node == null) {
                    throw new EBException(EBException.UNEXP_FILE,
                                          _info.file.getPath());
                }

                if (bitIndex > 0) {
                    bitIndex--;
                } else {
                    bitIndex = 7;
                    inPos++;
                }
            }

            if (node.getLeafType() == HuffmanNode.LEAF_EOF) {
                // Ĥ
                if (outLen < PAGE_SIZE) {
                    Arrays.fill(_cache, outPos, _cache.length, (byte)'\0');
                    outLen = PAGE_SIZE;
                }
                break;
            } else if (node.getLeafType() == HuffmanNode.LEAF_32) {
                if (outLen >= PAGE_SIZE - 1) {
                    _cache[outPos] = (byte)((node.getValue() >>> 24) & 0xff);
                    outPos++;
                    outLen++;
                } else if (outLen >= PAGE_SIZE - 2) {
                    _cache[outPos] = (byte)((node.getValue() >>> 24) & 0xff);
                    _cache[outPos+1] = (byte)((node.getValue() >>> 16) & 0xff);
                    outPos += 2;
                    outLen += 2;
                } else if (outLen >= PAGE_SIZE - 3) {
                    _cache[outPos] = (byte)((node.getValue() >>> 24) & 0xff);
                    _cache[outPos+1] = (byte)((node.getValue() >>> 16) & 0xff);
                    _cache[outPos+2] = (byte)((node.getValue() >>> 8) & 0xff);
                    outPos += 3;
                    outLen += 3;
                } else {
                    _cache[outPos+1] = (byte)((node.getValue() >>> 24) & 0xff);
                    _cache[outPos+2] = (byte)((node.getValue() >>> 16) & 0xff);
                    _cache[outPos+2] = (byte)((node.getValue() >>> 8) & 0xff);
                    _cache[outPos+3] = (byte)(node.getValue() & 0xff);
                    outPos += 4;
                    outLen += 4;
                }
            } else if (node.getLeafType() == HuffmanNode.LEAF_16) {
                if (outLen >= PAGE_SIZE - 1) {
                    _cache[outPos] = (byte)((node.getValue() >>> 8) & 0xff);
                    outPos++;
                    outLen++;
                } else {
                    _cache[outPos] = (byte)((node.getValue() >>> 8) & 0xff);
                    _cache[outPos+1] = (byte)(node.getValue() & 0xff);
                    outPos += 2;
                    outLen += 2;
                }
            } else {
                _cache[outPos] = (byte)node.getValue();
                outPos++;
                outLen++;
            }
        }
    }
}

// end of EPWINGInputStream.java
