package fuku.eb4j.io;

import java.util.*;

/**
 * ϥեޥΡɥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
final class HuffmanNode implements Comparable {

    /** EOFեΡ */
    static final int LEAF_EOF = 0;
    /** 8bitեΡ */
    static final int LEAF_8 = 1;
    /** 16bitեΡ */
    static final int LEAF_16 = 2;
    /** 32bitեΡ */
    static final int LEAF_32 = 3;

    /** եΡɤμ */
    private int _leafType = -1;
    /**  */
    private long _value = -1L;
    /** и */
    private int _frequency = 0;
    /** ҥΡ */
    private HuffmanNode _left = null;
    /** ҥΡ */
    private HuffmanNode _right = null;


    /**
     * 󥹥ȥ饯 (եΡ)
     *
     * @param value 
     * @param frequency и
     * @param leafType եΡɤμ
     */
    HuffmanNode(long value, int frequency, int leafType) {
        _value = value;
        _frequency = frequency;
        _leafType = leafType;
    }

    /**
     * 󥹥ȥ饯 (ޥΡ)
     *
     * @param left ҥΡ
     * @param right ҥΡ
     */
    HuffmanNode(HuffmanNode left, HuffmanNode right) {
        _left = left;
        _right = right;
        _frequency = _left.getFrequency() + _right.getFrequency();
    }


    /**
     * եΡɤμ֤ޤ
     *
     * @return եΡɤμ
     */
    int getLeafType() {
        return _leafType;
    }

    /**
     * ֤ͤޤ
     *
     * @return 
     */
    long getValue() {
        return _value;
    }

    /**
     * и֤ͤޤ
     *
     * @return и
     */
    int getFrequency() {
        return _frequency;
    }

    /**
     * ҥΡɤ֤ޤ
     *
     * @return ҥΡ
     */
    HuffmanNode getLeft() {
        return _left;
    }

    /**
     * ҥΡɤ֤ޤ
     *
     * @return ҥΡ
     */
    HuffmanNode getRight() {
        return _right;
    }

    /**
     * եΡɤޥΡɤȽ̤ޤ
     *
     * @return եΡɤǤtrueޥΡɤǤfalse
     */
    boolean isLeaf() {
        if (_right == null && _left == null) {
            return true;
        }
        return false;
    }

    /**
     * 2ĤΥΡɤνиͤӤޤ
     *
     * @param obj оݤΥΡ
     * @return ΥΡɤͤΡɤͤ0
     *         ΥΡɤͤΡɤͤ꾮0꾮͡
     *         ΥΡɤͤΡɤͤ礭0礭
     */
    public int compareTo(Object obj) {
        int ret = _frequency - ((HuffmanNode)obj).getFrequency();
        return ret;
    }

    /**
     * ϥեޥĥ꡼ޤ
     *
     * @param list HuffmanNodeΥꥹ
     * @return 롼ȥΡ
     */
    static HuffmanNode makeTree(List list) {
        while (list.size() > 1) {
            // ͤǤ⾮Ρ
            HuffmanNode node1 = (HuffmanNode)Collections.min(list);
            list.remove(node1);
            // ͤ˾Ρ
            HuffmanNode node2 = (HuffmanNode)Collections.min(list);
            list.remove(node2);
            // ޥΡɤκ
            list.add(new HuffmanNode(node1, node2));
        }
        return (HuffmanNode)list.get(0);
    }
}

// end of HuffmanNode.java
