package fuku.eb4j.io;

import java.io.*;

import fuku.eb4j.EBException;

/**
 * ̵̷νϥȥ꡼९饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class PlainInputStream extends BookInputStream {

    /**
     * 󥹥ȥ饯
     *
     * @param info ե
     * @exception EBException ϥ顼ȯ
     */
    PlainInputStream(FileInfo info) throws EBException {
        super(info);
        synchronized (info) {
            if (info.realFileSize <= 0) {
                try {
                    open();
                    info.realFileSize = _stream.length();
                    info.fileSize = info.realFileSize;
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_READ_FILE,
                                          info.file.getPath(), e);
                } finally {
                    close();
                }
            }
        }
    }


    /**
     * Υե뤫lenХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @param off ǡγϥեå
     * @param len ɤ߹ޤХȿ
     * @return Хåեɤ߹ޤ줿ХȤι׿
     *         (ȥ꡼νãƥǡʤ-1)
     * @exception EBException ϥ顼ȯ
     */
    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            if (_info.fileSize <= _filePos) {
                // ȥ꡼ν
                if (rlen == 0) {
                    // ǡɤ߹Ǥʤ-1
                    return -1;
                } else {
                    // ǡɤ߹ǤХХȿ֤
                    return rlen;
                }
            }
            // åκ
            if (_cachePos < 0
                || _filePos < _cachePos
                || _cachePos + PAGE_SIZE <= _filePos) {
                // åΥǡ
                // _filePosΰ֤ޤޤڡƬ
                _cachePos = _filePos - (_filePos % PAGE_SIZE);

                // ڡΥǡ򥭥åɤ߹
                try {
                    _stream.seek(_cachePos);
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_SEEK_FILE,
                                          _info.file.getPath(), e);
                }
                int readLen = PAGE_SIZE;
                if (_info.fileSize < _cachePos + PAGE_SIZE) {
                    readLen = (int)(_info.fileSize - _cachePos);
                }
                readRawFully(_cache, 0, readLen);
            }

            // å夫ǡμ
            int cacheLen = PAGE_SIZE;
            if (_info.fileSize < _cachePos + PAGE_SIZE) {
                cacheLen = (int)(_info.fileSize - _cachePos);
            }
            int rest = (int)(cacheLen - (_filePos % PAGE_SIZE));
            if (len - rlen < rest) {
                rest = len - rlen;
            }
            if (_info.fileSize - _filePos < rest) {
                rest = (int)(_info.fileSize - _filePos);
            }
            int p = (int)(_filePos % PAGE_SIZE);
            System.arraycopy(_cache, p, b, off+rlen, rest);
            rlen += rest;
            _filePos += rest;
        }
        return rlen;
    }
}

// end of PlainInputStream.java
