package fuku.webbook;

import java.awt.*;
import java.io.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.*;

import fuku.eb4j.SubBook;
import fuku.eb4j.ExtFont;
import fuku.eb4j.EBException;
import fuku.eb4j.hook.HookAdapter;
import fuku.eb4j.util.ByteUtil;
import fuku.eb4j.util.ImageUtil;

/**
 * HTMLѥץ󥹲ù饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class HTMLHook extends HookAdapter {

    /** ǥץ쥤䥢ץå */
    private static final String AUDIO_PLAYER = "fuku.player.AudioPlayerApplet";
    /** ӥǥץ쥤䥢ץå */
    private static final String VIDEO_PLAYER = "fuku.player.VideoPlayerApplet";
    /** ץåȤJARե */
    private static final String ARCHIVE = "player.jar";
    /** ץåȤ (ǥ) */
    private static final String AUDIO_WIDTH = "32";
    /** ץåȤι⤵ (ǥ) */
    private static final String AUDIO_HEIGHT = "16";
    /** ץåȤ (ӥǥ) */
    private static final String VIDEO_WIDTH = "320";
    /** ץåȤι⤵ (ӥǥ) */
    private static final String VIDEO_HEIGHT = "260";

    /** ϹԿ */
    private static final int MAX_LINE = 500;

    /** ϥѡѥ */
    private static final String[] SCHEME = {
        "http://", "ftp://", "https://"
    };

    /** ȾɽϤƤ뤫ɤ򼨤ե饰 */
    private boolean _narrow = false;
    /** ǥ */
    private int _indent = 0;
    /** ͥѥå */
    private Stack _stack = new Stack();

    /** Կ */
    private int _line = 0;

    /** ǥեȤʿ */
    private Color _default = Color.BLACK;
    /** ɽʿ */
    private Color _keyword = Color.RED;
    /** 󥫡ɽʿ */
    private Color _anchor = Color.BLUE;

    /** ߤʿ */
    private Color _foreground = _default;
    /** ߤطʿ */
    private Color _background = Color.WHITE;

    /**  */
    private SubBook _sub = null;

    /** HTMLǡ */
    private StringBuffer _html = new StringBuffer(2048);
    /** ʸХåե */
    private StringBuffer _buf = new StringBuffer(256);
    /** ϥХåե */
    private StringBuffer _output = _html;

    /** HTMLХåեȾѳϰ */
    private int _position = 0;

    /** ȻURL */
    private String _href = null;
    /** ХʥǡեURL */
    private String _base = "./";

    /** Υ饤ɽ */
    private boolean _inline = false;
    /** ץåȤλ */
    private boolean _applet = false;

    /** Υ/MPEGư */
    private int _width = -1;
    /** Υ/MPEGưι⤵ */
    private int _height = -1;
    /** 顼ΰ */
    private long _pos = -1L;
    /** 顼JPEGǤ뤳Ȥ򼨤ե饰 */
    private boolean _jpeg = false;

    /** ץåȥѥ᡼ */
    private StringBuffer _file = new StringBuffer(128);


    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param href ȻURL
     * @param base ХʥǡΥ١URL
     */
    public HTMLHook(SubBook sub, String href, String base) {
        super();
        _sub = sub;
        _href = href;

        if (base == null) {
            _base = "./";
        } else {
            if (!base.endsWith("/")) {
                _base = base + "/";
            } else {
                _base = base;
            }
        }
    }

    /**
     * Υ饤ɽꤷޤ
     *
     * @param inline 򥤥饤ɽtureǤʤfalse
     */
    public void setInline(boolean inline) {
        _inline = inline;
    }

    /**
     * ץåȤλѤꤷޤ
     *
     * @param applet ץåȤѤtureǤʤfalse
     */
    public void setApplet(boolean applet) {
        _applet = applet;
    }

    /**
     * ǥեȤʿꤷޤ
     *
     * @param color ꤹ뿧
     */
    public void setForegroundColor(Color color) {
        if (color != null) {
            if (_foreground.equals(_default)) {
                _foreground = color;
            }
            _default = color;
        }
    }

    /**
     * طʿꤷޤ
     *
     * @param color ꤹ뿧
     */
    public void setBackgroundColor(Color color) {
        if (color != null) {
            _background = color;
        }
    }

    /**
     * ɳϻʿꤷޤ
     *
     * @param color ꤹ뿧
     */
    public void setKeywordColor(Color color) {
        if (color != null) {
            if (_foreground.equals(_keyword)) {
                _foreground = color;
            }
            _keyword = color;
        }
    }

    /**
     * ȳϻʿꤷޤ
     *
     * @param color ꤹ뿧
     */
    public void setAnchorColor(Color color) {
        if (color != null) {
            if (_foreground.equals(_anchor)) {
                _foreground = color;
            }
            _anchor = color;
        }
    }

    /**
     * ٤ƤϤ򥯥ꥢޤ
     *
     */
    public void clear() {
        _html.delete(0, _html.length());
        _buf.delete(0, _buf.length());
        _narrow = false;
        _indent = 0;
        _line = 0;
    }

    /**
     * եåˤäƲù줿֥Ȥ֤ޤ
     *
     * @return HTMLʸ
     */
    public Object getObject() {
        if (!_stack.empty()) {
            _html.append("</DD></DL>");
            _indent = ((Integer)_stack.pop()).intValue();
            while (!_stack.empty()) {
                _html.append("</DD></DL>");
                _indent = ((Integer)_stack.pop()).intValue();
            }
        }
        return _html.toString();
    }

    /**
     * Ϥǽɤ֤ޤ
     *
     * @return ޤϤĤtrueǤʤfalse
     */
    public boolean isMoreInput() {
        if (_line >= MAX_LINE) {
            return false;
        }
        return true;
    }

    /**
     * ʸɲäޤ
     *
     * @param str ʸ
     */
    public void append(String str) {
        if (_narrow) {
            str = ByteUtil.wideToNarrow(str);
        }
        StringBuffer tmp = new StringBuffer(str);
        int idx = tmp.indexOf("&");
        while (idx >= 0) {
            tmp.replace(idx, idx+1, "&amp;");
            idx = tmp.indexOf("&", idx+5);
        }
        idx = tmp.indexOf("<");
        while (idx >= 0) {
            tmp.replace(idx, idx+1, "&lt;");
            idx = tmp.indexOf("<", idx+4);
        }
        idx = tmp.indexOf(">");
        while (idx >= 0) {
            tmp.replace(idx, idx+1, "&gt;");
            idx = tmp.indexOf(">", idx+4);
        }
        _output.append(tmp);
    }

    /**
     * ɲäޤ
     *
     * @param code ʸ
     */
    public void append(int code) {
        // ϥե̾
        int fore = _foreground.getRGB() | 0xff000000;
        int back = _background.getRGB() | 0xff000000;
        String height = Integer.toString(_sub.getFont().getFontHeight());
        String width = null;
        String prefix = null;
        if (_narrow) {
            prefix = "N";
            width = Integer.toString(_sub.getFont().getNarrowFontWidth());
        } else {
            prefix = "W";
            width = Integer.toString(_sub.getFont().getWideFontWidth());
        }
        String alt = prefix + height
            + "-" + Integer.toHexString(code).toUpperCase();

        // HTMLɲ
        _output.append("<IMG class=\"gaiji\" src=\"");
        _output.append(_base).append(alt);
        _output.append("_F-");
        _output.append(Integer.toHexString(fore).substring(2).toUpperCase());
        _output.append("_B-");
        _output.append(Integer.toHexString(back).substring(2).toUpperCase());
        _output.append(".png\" ");
        _output.append("width=\"").append(width).append("\" ");
        _output.append("height=\"").append(height).append("\" ");
        _output.append("alt=\"[").append(alt).append("]\">");
    }

    /**
     * ȾɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginNarrow() {
        _narrow = true;
        _position = _html.length();
    }

    /**
     * Ⱦɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endNarrow() {
        _narrow = false;
        _addLink();
    }

    /**
     * դɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginSubscript() {
        _output.append("<SUB>");
    }

    /**
     * դɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endSubscript() {
        _output.append("</SUB>");
    }

    /**
     * դɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginSuperscript() {
        _output.append("<SUP>");
    }

    /**
     * դɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endSuperscript() {
        _output.append("</SUP>");
    }

    /**
     * Ƭλɽץ󥹤ФեåǤ
     *
     * @param indent 
     */
    public void setIndent(int indent) {
        if (indent < 0) {
            return;
        }
        if (_output.length() <= 0) {
            _indent = indent;
            return;
        }
        if (indent > _indent) {
            _stack.push(new Integer(_indent));
            _indent = indent;
            _output.append("<DL><DT></DT><DD>");
        } else {
            while (indent < _indent) {
                if (_stack.empty()) {
                    break;
                }
                _output.append("</DD></DL>");
                _indent = ((Integer)_stack.pop()).intValue();
            }
        }
    }

    /**
     * Ԥɽץ󥹤ФեåǤ
     *
     */
    public void newLine() {
        _output.append("<BR>");
        _line++;
    }

    /**
     * ԶػߤγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginNoNewLine() {
        _output.append("<NOBR>");
    }

    /**
     * Զػߤνλɽץ󥹤ФեåǤ
     *
     */
    public void endNoNewLine() {
        _output.append("</NOBR>");
    }

    /**
     * ĴɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginEmphasis() {
        _output.append("<EM>");
    }

    /**
     * Ĵɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endEmphasis() {
        _output.append("</EM>");
    }

    /**
     * ʸγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginDecoration() {
        _output.append("<U>");
    }

    /**
     * ʸνλɽץ󥹤ФեåǤ
     *
     */
    public void endDecoration() {
        _output.append("</U>");
    }

    /**
     * ʣ縡θȤʤγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginCandidate() {
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * ʣ縡θȤʤνλɽץ󥹤ФեåǤ<BR>
     * ȤʤϤ˺٤ʬƤ뤳Ȥ򼨤ޤ
     *
     * @param pos γؤθǡΰ
     */
    public void endCandidateGroup(long pos) {
        _output = _html;
        if (_href != null) {
            _output.append("<A href=\"").append(_href);
            _output.append("&pos=").append(Long.toHexString(pos));
            _output.append("\">").append(_buf).append("</A>");
        }
    }

    /**
     * ʣ縡θȤʤνλɽץ󥹤ФեåǤ<BR>
     * Ȥʤ줬ºݤ˸ϸȤƻȤΤǤ뤳Ȥ򼨤ޤ
     *
     */
    public void endCandidateLeaf() {
        _output = _html;
        _output.append(_buf);
    }

    /**
     * ̰֤ΥƥȥǡλȳϤɽץ󥹤ФեåǤ
     *
     */
    public void beginReference() {
        _foreground = _anchor;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * ̰֤ΥƥȥǡλȽλɽץ󥹤ФեåǤ
     *
     * @param pos ΰ
     */
    public void endReference(long pos) {
        _output = _html;
        if (_href != null) {
            _output.append("<A href=\"").append(_href);
            _output.append("&pos=").append(Long.toHexString(pos));
            _output.append("\">").append(_buf).append("</A>");
        }
        _foreground = _default;
    }

    /**
     * ɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginKeyword() {
        _foreground = _keyword;
        _output.append("<SPAN class=\"keyword\">");
    }

    /**
     * ɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endKeyword() {
        _foreground = _default;
        _output.append("</SPAN>");
    }

    /**
     * ΥλȳϤɽץ󥹤ФեåǤ
     *
     * @param width 
     * @param height ι⤵
     */
    public void beginMonoGraphic(int width, int height) {
        _width = width;
        _height = height;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * ΥλȽλɽץ󥹤ФեåǤ
     *
     * @param pos ǡΰ
     */
    public void endMonoGraphic(long pos) {
        _output = _html;
        if (_width >= 0 && _height >= 0) {
            int len = _output.length();
            if (len >= 4 && _output.lastIndexOf("<BR>") == len-4) {
                _output.append("<BR>");
            }
            if (_inline || _buf.length() <= 0) {
                if (_buf.length() > 0) {
                    _output.append(_buf).append("<BR>");
                }
                _output.append("<IMG src=\"");
                _output.append(_base).append("M-");
                _output.append(Long.toHexString(pos).toUpperCase());
                _output.append("_W-");
                _output.append(Integer.toHexString(_width).toUpperCase());
                _output.append("_H-");
                _output.append(Integer.toHexString(_height).toUpperCase());
                _output.append(".png\" ");
                _output.append("width=\"").append(Integer.toString(_width)).append("\" ");
                _output.append("height=\"").append(Integer.toString(_height)).append("\" ");
                _output.append("alt=\"").append(_buf).append("\">");
            } else {
                _output.append("<A href=\"");
                _output.append(_base).append("M-");
                _output.append(Long.toHexString(pos).toUpperCase());
                _output.append("_W-");
                _output.append(Integer.toHexString(_width).toUpperCase());
                _output.append("_H-");
                _output.append(Integer.toHexString(_height).toUpperCase());
                _output.append(".png\">").append(_buf).append("</A>");
            }
        }
    }

    /**
     * DIB饤󥫥顼λȳϤɽץ󥹤ФեåǤ
     *
     * @param pos ǡΰ
     */
    public void beginInlineColorDIB(long pos) {
        _pos = pos;
        _jpeg = false;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * JPEG饤󥫥顼λȳϤɽץ󥹤ФեåǤ
     *
     * @param pos ǡΰ
     */
    public void beginInlineColorJPEG(long pos) {
        _pos = pos;
        _jpeg = true;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * 饤󥫥顼λȽλɽץ󥹤ФեåǤ
     *
     */
    public void endInlineColorGraphic() {
        _output = _html;
        if (_pos >= 0) {
            String suffix = null;
            if (_jpeg) {
                suffix = ".jpeg";
            } else {
                suffix = ".png";
            }
            int len = _output.length();
            if (len >= 4 && _output.lastIndexOf("<BR>") == len-4) {
                _output.append("<BR>");
            }
            if (_buf.length() > 0) {
                _output.append(_buf).append("<BR>");
            }
            _output.append("<IMG src=\"");
            _output.append(_base).append("C-");
            _output.append(Long.toHexString(_pos).toUpperCase());
            _output.append(suffix).append("\" ");
            _output.append("alt=\"").append(_buf).append("\">");
        }
    }

    /**
     * DIB顼λȳϤɽץ󥹤ФեåǤ
     *
     * @param pos ǡΰ
     */
    public void beginColorDIB(long pos) {
        _pos = pos;
        _jpeg = false;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * JPEG顼λȳϤɽץ󥹤ФեåǤ
     *
     * @param pos ǡΰ
     */
    public void beginColorJPEG(long pos) {
        _pos = pos;
        _jpeg = true;
        _buf.delete(0, _buf.length());
        _output = _buf;
    }

    /**
     * 顼λȽλɽץ󥹤ФեåǤ
     *
     */
    public void endColorGraphic() {
        _output = _html;
        if (_pos >= 0) {
            String suffix = null;
            if (_jpeg) {
                suffix = ".jpeg";
            } else {
                suffix = ".png";
            }
            int len = _output.length();
            if (len >= 4 && _output.lastIndexOf("<BR>") == len-4) {
                _output.append("<BR>");
            }
            if (_inline || _buf.length() <= 0) {
                if (_buf.length() > 0) {
                    _output.append(_buf).append("<BR>");
                }
                _output.append("<IMG src=\"");
                _output.append(_base).append("C-");
                _output.append(Long.toHexString(_pos).toUpperCase());
                _output.append(suffix).append("\" ");
                _output.append("alt=\"").append(_buf).append("\">");
            } else {
                _output.append("<A href=\"");
                _output.append(_base).append("C-");
                _output.append(Long.toHexString(_pos).toUpperCase());
                _output.append(suffix).append("\">").append(_buf).append("</A>");
            }
        }
    }

    /**
     * WAVEγϤɽץ󥹤ФեåǤ
     *
     * @param start WAVEǡγϰ
     * @param end WAVEǡνλ
     */
    public void beginWaveSound(long start, long end) {
        _foreground = _anchor;

        _file.delete(0, _file.length());
        _file.append(_base).append("S-");
        _file.append(Long.toHexString(start).toUpperCase());
        _file.append("_E-");
        _file.append(Long.toHexString(end).toUpperCase());
        _file.append(".wav");

        // HTMLɲ
        _output.append("<A href=\"").append(_file).append("\">");
    }

    /**
     * WAVEνλɽץ󥹤ФեåǤ
     *
     */
    public void endWaveSound() {
        _output.append("</A>");
        if (_applet) {
            _output.append("<APPLET ");
            _output.append("code=\"").append(AUDIO_PLAYER).append("\" ");
            _output.append("archive=\"").append(ARCHIVE).append("\" ");
            _output.append("align=\"absbottom\" ");
            _output.append("width=\"").append(AUDIO_WIDTH).append("\" ");
            _output.append("height=\"").append(AUDIO_HEIGHT).append("\">");
            _output.append("<PARAM name=\"file\" ");
            _output.append("value=\"").append(_file).append("\">");
            _output.append("</APPLET>");
        }
        _foreground = _default;
    }

    /**
     * MPEGưγϤɽץ󥹤ФեåǤ
     *
     * @param filename MPEGե̾
     */
    public void beginMPEG(String filename) {
        File mpeg = _sub.getMovieFile(filename);
        if (mpeg == null) {
            return;
        }
        _foreground = _anchor;

        _file.delete(0, _file.length());
        _file.append(_base).append(mpeg.getName()).append(".mpeg");

        // HTMLɲ
        _output.append("<A href=\"").append(_file).append("\">");
    }

    /**
     * MPEGưνλɽץ󥹤ФեåǤ
     *
     */
    public void endMPEG() {
        if (_foreground.equals(_anchor)) {
            _output.append("</A>");
            if (_applet) {
                _output.append("<BR><APPLET ");
                _output.append("code=\"").append(VIDEO_PLAYER).append("\" ");
                _output.append("archive=\"").append(ARCHIVE).append("\" ");
                _output.append("width=\"").append(VIDEO_WIDTH).append("\" ");
                _output.append("height=\"").append(VIDEO_HEIGHT).append("\">");
                _output.append("<PARAM name=\"file\" ");
                _output.append("value=\"").append(_file).append("\">");
                _output.append("</APPLET><BR>");
            }
            _foreground = _default;
        }
    }

    /**
     * ϥѡ󥯤ɲäޤ
     *
     */
    private void _addLink() {
        int idx1, idx2, len;
        int i, j;
        char ch;
        String addr, link;

        for (i=0; i<SCHEME.length; i++) {
            idx1 = _html.indexOf(SCHEME[i], _position);
            while (idx1 >= 0) {
                idx2 = idx1 + SCHEME[i].length();
                len = _html.length();
                for (j=idx2; j<len; j++) {
                    ch = _html.charAt(j);
                    if ((ch >= 'a' && ch <= 'z')
                        || (ch >= 'A' && ch <= 'Z')
                        || (ch >= '0' && ch <= '9')
                        || ch == '-' || ch == '_' || ch == '.' || ch == '~'
                        || ch == '+' || ch == '&' || ch == '?' || ch == '#'
                        || ch == ':' || ch == '/' || ch == '=' || ch == '%') {
                        idx2++;
                    } else {
                        break;
                    }
                }
                if ((idx2 - idx1) > SCHEME[i].length()) {
                    addr = _html.substring(idx1, idx2);
                    link = "<A href=\"" + addr + "\" target=\"_top\">";
                    _html.insert(idx1, link);
                    idx2 += link.length();
                    _html.insert(idx2, "</A>");
                    idx2 += 4;
                }
                idx1 = _html.indexOf(SCHEME[i], idx2);
            }
        }

        // E-Mail
        idx1 = _html.indexOf("@", _position+1);
        while (idx1 >= 0) {
            idx2 = idx1 + 1;
            len = _html.length();
            for (i=idx2; i<len; i++) {
                ch = _html.charAt(i);
                if ((ch >= 'a' && ch <= 'z')
                    || (ch >= 'A' && ch <= 'Z')
                    || (ch >= '0' && ch <= '9')
                    || ch == '-' || ch == '_' || ch == '.' || ch == '~'
                    || ch == '+' || ch == '&' || ch == '?' || ch == '#'
                    || ch == ':' || ch == '/' || ch == '=' || ch == '%') {
                    idx2++;
                } else {
                    break;
                }
            }
            for (i=idx1; i>0; i--) {
                ch = _html.charAt(i-1);
                if ((ch >= 'a' && ch <= 'z')
                    || (ch >= 'A' && ch <= 'Z')
                    || (ch >= '0' && ch <= '9')
                    || ch == '-' || ch == '_' || ch == '.' || ch == '~'
                    || ch == '+' || ch == '&' || ch == '?' || ch == '#'
                    || ch == ':' || ch == '/' || ch == '=' || ch == '%') {
                    idx1--;
                } else {
                    break;
                }
            }
            if ((idx2 - idx1) > 3) {
                addr = _html.substring(idx1, idx2);
                link = "<A href=\"mailto:" + addr + "\">";
                _html.insert(idx1, link);
                idx2 += link.length();
                _html.insert(idx2, "</A>");
                idx2 += 4;
            }
            idx1 = _html.indexOf("@", idx2);
        }
    }
}

// end of HTMLHook.java
