package fuku.webbook;

import java.awt.Color;
import java.io.*;
import java.nio.*;
import java.nio.channels.*;
import javax.servlet.*;
import javax.servlet.http.*;

import fuku.eb4j.SubBook;
import fuku.eb4j.EBException;
import fuku.eb4j.util.ImageUtil;

/**
 * ꥽ǡ֥åȥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class ResourceServlet extends HttpServlet {

    /** PNG */
    private static final int PNG = 0;
    /** JPEG */
    private static final int JPEG = 1;
    /** WAV */
    private static final int WAV = 2;
    /** MPEG */
    private static final int MPEG = 3;

    /** ǥ */
    private static final String[] MEDIA_TYPE = {
        ".png", ".jpeg", ".wav", ".mpeg"
    };

    /** MIME */
    private static final String[] MIME_TYPE = {
        "image/png", "image/jpeg", "audio/x-wav", "video/mpeg"
    };

    /**
     * GETꥯȤν
     *
     * @param req 饤Ȥ׵ᤷꥯ
     * @param res 饤Ȥ֤쥹ݥ
     * @exception ServletException GETꥯȤǤʤ
     * @exception IOException GETꥯȤνϥ顼ȯ
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {
        doPost(req, res);
    }

    /**
     * POSTꥯȤν
     *
     * @param req 饤Ȥ׵ᤷꥯ
     * @param res 饤Ȥ֤쥹ݥ
     * @exception ServletException POSTꥯȤǤʤ
     * @exception IOException POSTꥯȤνϥ顼ȯ
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null || path.length() <= 0) {
            return;
        }

        // ǥפ
        int type = -1;
        for (type=0; type<MEDIA_TYPE.length; type++) {
            if (path.endsWith(MEDIA_TYPE[type])) {
                res.setContentType(MIME_TYPE[type]);
                break;
            }
        }
        if (type < 0) {
            return;
        }
        ServletOutputStream out = res.getOutputStream();

        // ׵оݤΥե
        File file = new File(path);
        String name = file.getName();
        // ֥åȥƥȤҴ֥Ȥ
        WebBook webbook = (WebBook)getServletContext().getAttribute("webbook");

        File cacheFile = null;
        boolean cacheFlag = false;
        switch (type) {
            case JPEG:
                cacheFlag = webbook.isImageCache();
                break;
            case WAV:
                cacheFlag = webbook.isSoundCache();
                break;
            default:
                int prefix = name.charAt(0);
                if (prefix == 'N' || prefix == 'W') {
                    cacheFlag = webbook.isGaijiCache();
                } else if (prefix == 'M' || prefix == 'C') {
                    cacheFlag = webbook.isImageCache();
                }
                break;
        }
        if (cacheFlag) {
            // å夬н
            cacheFile = new File(webbook.getCacheDir(), path);
            if (cacheFile.exists()) {
                _send(out, cacheFile);
                return;
            }
        }

        SubBook sub = webbook.getSubBook(file.getParentFile().getName());
        if (sub == null) {
            return;
        }

        // ǡɤ߹
        int idx1, idx2, idx3;
        long pos1, pos2;
        byte[] b = null;
        File f = null;
        try {
            switch (type) {
                case PNG:
                    int prefix = name.charAt(0);
                    if (prefix == 'N' || prefix == 'W') {
                        // 
                        boolean narrow = false;
                        if (prefix == 'N') {
                            narrow = true;
                        }
                        idx1 = name.indexOf('-');
                        idx2 = name.indexOf("_F-", idx1+1);
                        idx3 = name.indexOf("_B-", idx2+3);
                        int code = Integer.parseInt(name.substring(idx1+1, idx2), 16);
                        int fore = Integer.parseInt(name.substring(idx2+3, idx3), 16);
                        int back = Integer.parseInt(name.substring(idx3+3, name.length()-4), 16);
                        b = _getData(sub, narrow, code, fore, back);
                    } else if (prefix == 'M') {
                        // Υ
                        idx1 = name.indexOf('-');
                        idx2 = name.indexOf("_W-", idx1+1);
                        idx3 = name.indexOf("_H-", idx2+3);
                        pos1 = Long.parseLong(name.substring(idx1+1, idx2), 16);
                        int width = Integer.parseInt(name.substring(idx2+3, idx3), 16);
                        int height = Integer.parseInt(name.substring(idx3+3, name.length()-4), 16);
                        b = _getData(sub, pos1, width, height);
                    } else if (prefix == 'C') {
                        // 顼
                        pos1 = Long.parseLong(name.substring(2, name.length()-4), 16);
                        b = _getData(sub, pos1);
                    }
                    break;
                case JPEG:
                    pos1 = Long.parseLong(name.substring(2, name.length()-5), 16);
                    b = _getData(sub, pos1);
                    break;
                case WAV:
                    idx1 = name.indexOf('-');
                    idx2 = name.indexOf("_E-", idx1+1);
                    pos1 = Long.parseLong(name.substring(idx1+1, idx2), 16);
                    pos2 = Long.parseLong(name.substring(idx2+3, name.length()-4), 16);
                    b = _getData(sub, pos1, pos2);
                    break;
                case MPEG:
                    f = sub.getMovieFile(name.substring(0, name.length()-5));
                    break;
                default:
                    break;
            }
        } catch (NumberFormatException e) {
            f = null;
            b = null;
        }

        // ν
        if (f != null) {
            _send(out, f);
        } else if (b != null) {
            // å¸
            _store(cacheFile, b);
            out.write(b, 0, b.length);
        }
    }

    /**
     * ᡼֤ޤ
     *
     * @param sub 
     * @param narrow Ⱦ/ѥե饰
     * @param code Υ
     * @param fore ʿ
     * @param back طʿ
     * @return PNGǡ
     */
    private byte[] _getData(SubBook sub,
                            boolean narrow, int code, int fore, int back) {
        byte[] data = null;
        int width = 0;
        try {
            if (narrow) {
                if (!sub.getFont().hasNarrowFont()) {
                    return null;
                }
                data = sub.getFont().getNarrowFont(code);
                width = sub.getFont().getNarrowFontWidth();
            } else {
                if (!sub.getFont().hasWideFont()) {
                    return null;
                }
                data = sub.getFont().getWideFont(code);
                width = sub.getFont().getWideFontWidth();
            }
        } catch (EBException e) {
            System.err.println("WebBook: " + e.getMessage());
            return null;
        }
        if (data == null) {
            return null;
        }
        int height = sub.getFont().getFontHeight();
        return ImageUtil.bitmapToPNG(data, width, height,
                                     new Color(fore), new Color(back), true, 9);
    }

    /**
     * Υ֤ޤ
     *
     * @param sub 
     * @param pos ΰ
     * @param width 
     * @param height ι⤵
     * @return PNGǡ
     */
    private byte[] _getData(SubBook sub, long pos, int width, int height) {
        byte[] data = null;
        try {
            data = sub.getGraphicData().getMonoGraphic(pos, width, height);
        } catch (EBException e) {
            System.err.println("WebBook: " + e.getMessage());
            return null;
        }
        if (data == null) {
            return null;
        }
        return ImageUtil.bitmapToPNG(data, width, height,
                                     Color.BLACK, Color.WHITE, false, 9);
    }

    /**
     * 顼֤ޤ
     *
     * @param sub 
     * @param pos ΰ
     * @return PNGǡ
     */
    private byte[] _getData(SubBook sub, long pos) {
        byte[] data = null;
        try {
            data = sub.getGraphicData().getColorGraphic(pos);
        } catch (EBException e) {
            System.err.println("WebBook: " + e.getMessage());
            return null;
        }
        if (data == null) {
            return null;
        }
        return ImageUtil.dibToPNG(data, 9);
    }

    /**
     * WAVE֤ޤ
     *
     * @param sub 
     * @param start ϰ
     * @param end λ
     * @return WAVEǡ
     */
    private byte[] _getData(SubBook sub, long start, long end) {
        byte[] data = null;
        try {
            data = sub.getSoundData().getWaveSound(start, end);
        } catch (EBException e) {
            System.err.println("WebBook: " + e.getMessage());
            return null;
        }
        return data;
    }

    /**
     * ǡե¸ޤ
     *
     * @param file ե
     * @param data ǡ
     */
    private void _store(File file, byte[] data) {
        if (file == null || data == null) {
            return;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileChannel channel = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            channel = fos.getChannel();
            channel.write(ByteBuffer.wrap(data));
        } catch (IOException e) {
            System.err.println("WebBook: " + e.getMessage());
        } finally {
            if (channel != null) {
                try {
                    channel.close();
                } catch (IOException e) {
                }
            }
        }
    }

    /**
     * եƤϤޤ
     *
     * @param out ϥȥ꡼
     * @param file ϥե
     */
    private void _send(OutputStream out, File file) {
        BufferedInputStream bis = null;
        byte[] b = new byte[4096];
        int n = 0;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            while ((n=bis.read(b, 0, b.length)) >= 0) {
                out.write(b, 0, n);
            }
        } catch (IOException e) {
            System.err.println("WebBook: " + e.getMessage());
        } finally {
            if (bis != null) {
                try {
                    bis.close();
                } catch (IOException e) {
                }
            }
        }
    }
}

// end of ResourceServlet.java
