/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2TerminateInstancesRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.InstanceModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.CallbackAction;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TerminateInstanceAction
extends CallbackAction
implements ISelectionChangedListener {
    private List<InstanceModel> models = new ArrayList<InstanceModel>();

    public TerminateInstanceAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("TerminateInstanceAction.0"));
        this.setEnabled(false);
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/monitor_delete.png"));
    }

    public void run() {
        super.run();
        Job job = new Job(Messages.getString("TerminateInstanceAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("TerminateInstanceAction.3"), 10);
                monitor.setTaskName(Messages.getString("TerminateInstanceAction.4"));
                EC2ServiceProvider provider = Activator.getDefault().getProvider();
                monitor.worked(2);
                try {
                    ElasticComputingCloudInterface ec2 = provider.getEC2();
                    monitor.setTaskName(Messages.getString("TerminateInstanceAction.5"));
                    EC2TerminateInstancesRequest tt = new EC2TerminateInstancesRequest();
                    for (InstanceModel model : TerminateInstanceAction.this.models) {
                        tt.addInstanceId(model.getInstanceId());
                    }
                    ec2.terminateInstances(tt);
                    monitor.setTaskName(Messages.getString("TerminateInstanceAction.6"));
                    EC2DescribeInstanceRequest request = new EC2DescribeInstanceRequest();
                    final List instances = ec2.describeInstance(request);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TerminateInstanceAction.this.getHandler().onDescribeInstancesExecuted(instances);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("TerminateInstanceAction.7"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.models = new ArrayList<InstanceModel>();
        if (selection != null && !selection.isEmpty()) {
            List list = selection.toList();
            for (Object object : list) {
                if (!(object instanceof InstanceModel)) continue;
                this.models.add((InstanceModel)object);
                this.setEnabled(true);
            }
            if (list.isEmpty()) {
                this.setEnabled(false);
            }
        }
    }
}

