/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.api.amazon;

import com.xerox.amazonws.ec2.AddressInfo;
import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.AwsApiException;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2Address;
import jp.co.intellilink.aws.api.transport.EC2AssociateRequest;
import jp.co.intellilink.aws.api.transport.EC2AttachVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2AuthorizeRequest;
import jp.co.intellilink.aws.api.transport.EC2AvailabilityZone;
import jp.co.intellilink.aws.api.transport.EC2BundleInstance;
import jp.co.intellilink.aws.api.transport.EC2BundleInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2CancelBundleRequest;
import jp.co.intellilink.aws.api.transport.EC2ComfirmProductRequest;
import jp.co.intellilink.aws.api.transport.EC2ConsoleOutput;
import jp.co.intellilink.aws.api.transport.EC2CreateKeyPairRequest;
import jp.co.intellilink.aws.api.transport.EC2CreateSecurityGroupRequest;
import jp.co.intellilink.aws.api.transport.EC2CreateSnapshotRequest;
import jp.co.intellilink.aws.api.transport.EC2CreateVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2DeleteSecurityGroupRequest;
import jp.co.intellilink.aws.api.transport.EC2DeleteSnapshotRequest;
import jp.co.intellilink.aws.api.transport.EC2DeleteVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2DeregisterImageRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeAddressRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeAvailabilityZonesRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeBundleTasksRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeImageAttributeRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeImagesRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeKeyPairsRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeRegionsRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeSecurityGroupRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeSnapshotRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeVolumesRequest;
import jp.co.intellilink.aws.api.transport.EC2DetacheVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2DisassociateAddressRequest;
import jp.co.intellilink.aws.api.transport.EC2GetConsoleOutputRequest;
import jp.co.intellilink.aws.api.transport.EC2Image;
import jp.co.intellilink.aws.api.transport.EC2ImageAttribute;
import jp.co.intellilink.aws.api.transport.EC2Instance;
import jp.co.intellilink.aws.api.transport.EC2KeyPair;
import jp.co.intellilink.aws.api.transport.EC2ModifyAttributeRequest;
import jp.co.intellilink.aws.api.transport.EC2Permission;
import jp.co.intellilink.aws.api.transport.EC2Product;
import jp.co.intellilink.aws.api.transport.EC2RebootInstancesRequest;
import jp.co.intellilink.aws.api.transport.EC2Region;
import jp.co.intellilink.aws.api.transport.EC2RegisterImageRequest;
import jp.co.intellilink.aws.api.transport.EC2ReleaseAddressRequest;
import jp.co.intellilink.aws.api.transport.EC2Reservation;
import jp.co.intellilink.aws.api.transport.EC2ResetImageAttributeRequest;
import jp.co.intellilink.aws.api.transport.EC2RevokeSecurityGroupIngressRequest;
import jp.co.intellilink.aws.api.transport.EC2RunInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2SecurityGroup;
import jp.co.intellilink.aws.api.transport.EC2Snapshot;
import jp.co.intellilink.aws.api.transport.EC2TerminateInstancesRequest;
import jp.co.intellilink.aws.api.transport.EC2Volume;

public class EC2Typica
implements ElasticComputingCloudInterface {
    private Jec2 jec2;
    private String name;
    private String desc;

    public void configure(String accessKey, String secretKey) {
        this.jec2 = new Jec2(accessKey, secretKey);
    }

    public EC2Address allocateAddress() {
        try {
            String address = this.jec2.allocateAddress();
            return new EC2Address(address);
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public EC2Address associateAddress(EC2AssociateRequest request) {
        try {
            this.jec2.associateAddress(request.getInstanceId(), request.getPublicIp());
            return new EC2Address(request.getInstanceId(), request.getPublicIp());
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public EC2Volume attachVolume(EC2AttachVolumeRequest request) {
        return null;
    }

    public EC2SecurityGroup authorizeSecurityGroup(EC2AuthorizeRequest request) {
        return null;
    }

    public EC2BundleInstance bundleInstance(EC2BundleInstanceRequest request) {
        return null;
    }

    public EC2BundleInstance cancelBundleInstance(EC2CancelBundleRequest request) {
        return null;
    }

    public EC2Product comfirmProduct(EC2ComfirmProductRequest request) {
        return null;
    }

    public EC2KeyPair createKeyPair(EC2CreateKeyPairRequest request) {
        try {
            KeyPairInfo keyPairInfo = this.jec2.createKeyPair(request.getKeyName());
            return new EC2KeyPair(keyPairInfo.getKeyName(), keyPairInfo.getKeyFingerprint(), keyPairInfo.getKeyMaterial());
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public EC2SecurityGroup createSecurityGroup(EC2CreateSecurityGroupRequest request) {
        try {
            this.jec2.createSecurityGroup(request.getName(), request.getDesc());
            return new EC2SecurityGroup(request.getName(), request.getDesc());
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public EC2Snapshot createSnapshot(EC2CreateSnapshotRequest request) {
        return null;
    }

    public EC2Volume createVolume(EC2CreateVolumeRequest request) {
        return null;
    }

    public EC2KeyPair deleteKeyPair(EC2KeyPair request) {
        try {
            this.jec2.deleteKeyPair(request.getKeyName());
            return request;
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public EC2SecurityGroup deleteSecurityGroup(EC2DeleteSecurityGroupRequest request) {
        return null;
    }

    public EC2Snapshot deleteSnapshot(EC2DeleteSnapshotRequest request) {
        return null;
    }

    public EC2Volume deleteVolume(EC2DeleteVolumeRequest request) {
        return null;
    }

    public EC2Image deregisterImage(EC2DeregisterImageRequest request) {
        return null;
    }

    public List<EC2Address> describeAddress(EC2DescribeAddressRequest request) {
        try {
            List addresses = this.jec2.describeAddresses(new ArrayList());
            ArrayList<EC2Address> rv = new ArrayList<EC2Address>();
            for (AddressInfo addressInfo : addresses) {
                EC2Address r = new EC2Address(addressInfo.getInstanceId(), addressInfo.getPublicIp());
                rv.add(r);
            }
            return rv;
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public List<EC2AvailabilityZone> describeAvailabilityZones(EC2DescribeAvailabilityZonesRequest request) {
        try {
            List zones = this.jec2.describeAvailabilityZones(new ArrayList());
            ArrayList<EC2AvailabilityZone> list = new ArrayList<EC2AvailabilityZone>();
            for (AvailabilityZone availabilityZone : zones) {
                EC2AvailabilityZone zone = new EC2AvailabilityZone();
                zone.setZoneName(availabilityZone.getName());
                list.add(zone);
            }
            return list;
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public List<EC2BundleInstance> describeBundleTasks(EC2DescribeBundleTasksRequest request) {
        return null;
    }

    public List<EC2ImageAttribute> describeImageAttribute(EC2DescribeImageAttributeRequest request) {
        return null;
    }

    public List<EC2Image> describeImages(EC2DescribeImagesRequest request) {
        try {
            List images = this.jec2.describeImages(new ArrayList());
            ArrayList<EC2Image> rv = new ArrayList<EC2Image>();
            for (ImageDescription desc : images) {
                EC2Image image = new EC2Image();
                image.setImageId(desc.getImageId());
                image.setArchitecture(desc.getArchitecture());
                image.setImageLocation(desc.getImageLocation());
                image.setImageOwnerId(desc.getImageOwnerId());
                image.setImageType(desc.getImageType());
                image.setKernelId(desc.getKernelId());
                image.setPlatform("typica not implements");
                image.setRamdiskId(desc.getRamdiskId());
                rv.add(image);
            }
            return rv;
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public List<EC2Instance> describeInstance(EC2DescribeInstanceRequest request) {
        try {
            List instances = this.jec2.describeInstances(new ArrayList());
            ArrayList<EC2Instance> rv = new ArrayList<EC2Instance>();
            for (ReservationDescription reserve : instances) {
                List groups = reserve.getGroups();
                List instance = reserve.getInstances();
                for (ReservationDescription.Instance ins : instance) {
                    EC2Instance r = new EC2Instance();
                    r.setId(ins.getInstanceId());
                    r.setImageId(ins.getImageId());
                    r.setInstanceState(ins.getStateCode());
                    r.setInstanceType(ins.getInstanceType().name());
                    r.setKeyName(ins.getKeyName());
                    r.setPrivateDnsName(ins.getPrivateDnsName());
                    r.setDnsName(ins.getDnsName());
                    r.setPlacement(ins.getAvailabilityZone());
                    r.setLaunchTime(ins.getLaunchTime().getTime());
                    r.setReason(ins.getReason());
                    r.setReservationId(reserve.getReservationId());
                    for (String group : groups) {
                        EC2SecurityGroup g = new EC2SecurityGroup(group, "");
                        r.addGroup(g);
                    }
                    rv.add(r);
                }
            }
            return rv;
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public List<EC2KeyPair> describeKeyPairs(EC2DescribeKeyPairsRequest request) {
        try {
            List keyPairs = this.jec2.describeKeyPairs(new ArrayList());
            ArrayList<EC2KeyPair> rv = new ArrayList<EC2KeyPair>();
            for (KeyPairInfo keyPairInfo : keyPairs) {
                EC2KeyPair keyPair = new EC2KeyPair(keyPairInfo.getKeyName(), keyPairInfo.getKeyFingerprint(), keyPairInfo.getKeyMaterial());
                rv.add(keyPair);
            }
            return rv;
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public List<EC2Region> describeRegions(EC2DescribeRegionsRequest request) {
        return null;
    }

    public List<EC2SecurityGroup> describeSecurityGroups(EC2DescribeSecurityGroupRequest request) {
        try {
            List groups = this.jec2.describeSecurityGroups(new ArrayList());
            ArrayList<EC2SecurityGroup> rv = new ArrayList<EC2SecurityGroup>();
            for (GroupDescription groupDescription : groups) {
                EC2SecurityGroup group = new EC2SecurityGroup(groupDescription.getName(), this.getDescription());
                group.setOwnerId(group.getOwnerId());
                List permissions = groupDescription.getPermissions();
                for (GroupDescription.IpPermission ipPermission : permissions) {
                    EC2Permission permission = new EC2Permission();
                    List ipRanges = ipPermission.getIpRanges();
                    StringBuilder builder = this.extractIpRange(ipRanges);
                    permission.setCidrIp(builder.toString());
                    permission.setFromPort(ipPermission.getFromPort());
                    permission.setToPort(ipPermission.getToPort());
                    permission.setIpProtocol(ipPermission.getProtocol());
                    List pairs = ipPermission.getUidGroupPairs();
                    this.extractGroup(permission, pairs);
                    group.addPermission(permission);
                }
                rv.add(group);
            }
            return rv;
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    private void extractGroup(EC2Permission permission, List<String[]> pairs) {
        if (pairs == null) {
            return;
        }
        for (String[] pair : pairs) {
            permission.addPair(pair[0], pair[1]);
        }
    }

    private StringBuilder extractIpRange(List<String> ipRanges) {
        if (ipRanges == null || ipRanges.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipRanges) {
            builder.append(ip);
            builder.append(",");
        }
        builder.deleteCharAt(builder.lastIndexOf(","));
        return builder;
    }

    public List<EC2Snapshot> describeSnapshot(EC2DescribeSnapshotRequest request) {
        return null;
    }

    public List<EC2Volume> describeVolumes(EC2DescribeVolumesRequest request) {
        return null;
    }

    public List<EC2Volume> detacheVolume(EC2DetacheVolumeRequest volume) {
        return null;
    }

    public List<EC2Address> disassociateAddress(EC2DisassociateAddressRequest request) {
        return null;
    }

    public List<EC2ConsoleOutput> getConsoleOutput(EC2GetConsoleOutputRequest reqeust) {
        return null;
    }

    public List<EC2ImageAttribute> modifyImageAttribute(EC2ModifyAttributeRequest request) {
        return null;
    }

    public List<EC2Instance> rebootInstances(EC2RebootInstancesRequest request) {
        return null;
    }

    public List<EC2Image> registerImage(EC2RegisterImageRequest request) {
        return null;
    }

    public List<EC2Address> releaseAddress(EC2ReleaseAddressRequest request) {
        try {
            this.jec2.releaseAddress(request.getPublicIp());
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public List<EC2Image> resetImageAttribute(EC2ResetImageAttributeRequest request) {
        return null;
    }

    public List<EC2SecurityGroup> revokeSecurityGroupIngress(EC2RevokeSecurityGroupIngressRequest reqeust) {
        return null;
    }

    public EC2Reservation runInstances(EC2RunInstanceRequest request) {
        LaunchConfiguration lc = new LaunchConfiguration(request.getImageId());
        lc.setAvailabilityZone(request.getAvailabilityZone());
        lc.setInstanceType(InstanceType.getTypeFromString((String)request.getInstanceType()));
        lc.setKeyName(request.getKeyName());
        if (!"".equals(request.getKernelId())) {
            lc.setKernelId(request.getKernelId());
        }
        if (!"".equals(request.getRamdiskId())) {
            lc.setRamdiskId(request.getRamdiskId());
        }
        lc.setMinCount(request.getMinCount());
        lc.setMaxCount(request.getMaxCount());
        ArrayList<String> securityGroup = new ArrayList<String>();
        securityGroup.add(request.getGroupId());
        lc.setSecurityGroup(securityGroup);
        try {
            this.jec2.runInstances(lc);
            EC2Reservation reservation = new EC2Reservation();
            return reservation;
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
    }

    public List<EC2Instance> terminateInstances(EC2TerminateInstancesRequest request) {
        try {
            this.jec2.terminateInstances(request.getInstanceId());
        }
        catch (EC2Exception e) {
            throw new AwsApiException((Throwable)e);
        }
        return null;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void configureFile(File privateKey, File certifiedKey) {
    }

    public void configureUrl(String url) {
    }
}

