/*
 * Decompiled with CFR 0.152.
 */
package com.muimi.webwiz;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SelectContainerWizardPage
extends WizardPage {
    private IProject project;
    private IPath webFolder;
    private Text webFolderText;
    private Button classpathCheckbox;
    private Button sourceAttachCheckbox;

    protected SelectContainerWizardPage(IStructuredSelection selection) {
        super("Select Folder");
        this.setTitle("Select Folder");
        this.setDescription("Select web folder and so on...");
        Object selectElement = selection.getFirstElement();
        IResource resource = this.getResource(selectElement);
        if (resource instanceof IContainer) {
            this.webFolder = resource.getFullPath();
        }
    }

    private IResource getResource(Object element) {
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            this.project = javaElement.getJavaProject().getProject();
            IPath path = javaElement.getResource().getFullPath();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            return workspace.getRoot().findMember(path);
        }
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Web Folder");
        this.webFolderText = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.webFolderText.setLayoutData((Object)data);
        this.webFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectContainerWizardPage.this.validatePage();
            }
        });
        Button button = new Button(composite, 2048);
        button.setText("\u9078\u629e");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(Display.getDefault().getActiveShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "select WebFolder");
                dialog.setInitialSelections(new Object[]{SelectContainerWizardPage.this.webFolder});
                int ret = dialog.open();
                if (ret == 0) {
                    IPath path = (IPath)dialog.getResult()[0];
                    SelectContainerWizardPage.this.webFolderText.setText(path.toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(composite, 0);
        label.setText("\u30af\u30e9\u30b9\u30d1\u30b9\u3092\u901a\u3059");
        this.sourceAttachCheckbox = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.sourceAttachCheckbox.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText("\u30bd\u30fc\u30b9\u3092\u6dfb\u4ed8\u3059\u308b");
        this.classpathCheckbox = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.classpathCheckbox.setLayoutData((Object)data);
        this.setControl((Control)composite);
        this.initField();
    }

    private void initField() {
        if (this.webFolder != null) {
            this.webFolderText.setText(this.webFolder.toString());
        }
        this.classpathCheckbox.setSelection(true);
        this.sourceAttachCheckbox.setSelection(true);
    }

    private void validatePage() {
        String text = this.webFolderText.getText();
        if (text == null || text.length() == 0) {
            this.setPageComplete(false);
            this.setErrorMessage("webFolder is required");
            return;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(text)) == null) {
            this.setPageComplete(false);
            this.setErrorMessage("webFolder is invalid");
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public IContainer getWebFolder() {
        String text = this.webFolderText.getText();
        return (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(text));
    }

    public boolean isClasspathSelected() {
        return this.classpathCheckbox.getSelection();
    }

    public boolean isSourceAttachSelected() {
        return this.sourceAttachCheckbox.getSelection();
    }
}

