/*
 * Decompiled with CFR 0.152.
 */
package com.muimi.webwiz;

import com.muimi.webwiz.WebResourceDesc;
import com.muimi.webwiz.WebtoolsPlugin;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WebLibDesc {
    private WebResourceDesc webDesc;
    private String libName;
    private String src;
    private String javadoc;

    public WebLibDesc(WebResourceDesc webDesc, String libName) {
        this.webDesc = webDesc;
        this.libName = libName;
    }

    public IPath getSourcePath() {
        if (this.src == null) {
            return null;
        }
        String path = "resource/" + this.webDesc.getPath() + "/src/" + this.src;
        path = WebtoolsPlugin.getDefault().getResourcePath(path);
        Path srcPath = new Path(path);
        return srcPath;
    }

    public URL getJavaDocURL() {
        if (this.javadoc == null) {
            return null;
        }
        try {
            if (this.javadoc.startsWith("http://") || this.javadoc.startsWith("file://")) {
                return new URL(this.javadoc);
            }
            String path = "resource/" + this.webDesc.getPath() + "/src/" + this.javadoc;
            path = WebtoolsPlugin.getDefault().getResourcePath(path);
            if (path == null) {
                return null;
            }
            return new File(path).toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
            WebtoolsPlugin.logError("fail to attach javadoc. check javadoc location. javadoc='" + this.javadoc + "'", e);
            return null;
        }
    }

    public String getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(String javadoc) {
        this.javadoc = javadoc;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }
}

