/*
 * Decompiled with CFR 0.152.
 */
package com.muimi.webwiz;

import com.muimi.webwiz.WebLibDesc;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebResourceDesc {
    private String label;
    private String path;
    private Map libMap;

    public static WebResourceDesc createByDescFile(String path, File file) {
        WebResourceDesc webDesc = new WebResourceDesc();
        webDesc.path = path;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            Element root = doc.getDocumentElement();
            webDesc.label = WebResourceDesc.getChildElementText(root, "label");
            HashMap<String, WebLibDesc> libMap = new HashMap<String, WebLibDesc>();
            NodeList srcElements = root.getElementsByTagName("lib");
            int i = 0;
            while (i < srcElements.getLength()) {
                Element srcElement = (Element)srcElements.item(i);
                String libname = WebResourceDesc.getChildElementText(srcElement, "name");
                String src = WebResourceDesc.getChildElementText(srcElement, "src");
                String javadoc = WebResourceDesc.getChildElementText(srcElement, "javadoc");
                WebLibDesc libDesc = new WebLibDesc(webDesc, libname);
                libDesc.setSrc(src);
                libDesc.setJavadoc(javadoc);
                libMap.put(libname, libDesc);
                ++i;
            }
            webDesc.libMap = libMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return webDesc;
    }

    public static WebResourceDesc createByDescFile(String path) {
        WebResourceDesc webDesc = new WebResourceDesc();
        webDesc.path = path;
        webDesc.label = path;
        return webDesc;
    }

    private static String getChildElementText(Element element, String name) {
        Element child = (Element)element.getElementsByTagName(name).item(0);
        if (child == null) {
            return "";
        }
        NodeList list = child.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 3) {
                return node.getNodeValue();
            }
            ++i;
        }
        return "";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map getLibMap() {
        return this.libMap;
    }

    public void setLibMap(Map libMap) {
        this.libMap = libMap;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

