/*
 * Decompiled with CFR 0.152.
 */
package com.muimi.webwiz;

import com.muimi.webwiz.WebResourceDesc;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WebtoolsPlugin
extends AbstractUIPlugin {
    private static WebtoolsPlugin plugin;
    private ResourceBundle resourceBundle;

    public WebtoolsPlugin(IPluginDescriptor desc) {
        super(desc);
        plugin = this;
        WebtoolsPlugin.logInfo("WebtoolsPlugin(desc)");
    }

    public static WebtoolsPlugin getDefault() {
        return plugin;
    }

    public String getResourcePath(String path) {
        try {
            URL baseUrl = this.getDescriptor().getInstallURL();
            URL resourceUrl = new URL(baseUrl, path);
            String resourcePath = Platform.asLocalURL((URL)resourceUrl).getPath();
            return resourcePath;
        }
        catch (Exception e) {
            WebtoolsPlugin.logError("fail to read resource. path=" + path, e);
            return null;
        }
    }

    public static void logError(String message, Throwable e) {
        Status status = new Status(4, WebtoolsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, message, e);
        WebtoolsPlugin.log((IStatus)status);
    }

    public static void logInfo(String message) {
        Status status = new Status(1, WebtoolsPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, message, null);
        WebtoolsPlugin.log((IStatus)status);
    }

    public static void log(IStatus status) {
        WebtoolsPlugin.getDefault().getLog().log(status);
    }

    public WebResourceDesc[] getWebResourceDescs() {
        String rootPath = this.getResourcePath("resource");
        File rootDir = new File(rootPath);
        File[] dirs = rootDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (dirs == null) {
            return new WebResourceDesc[0];
        }
        WebResourceDesc[] descs = new WebResourceDesc[dirs.length];
        int i = 0;
        while (i < dirs.length) {
            File dir = dirs[i];
            File descFile = new File(dir, "desc.xml");
            descs[i] = descFile.exists() ? WebResourceDesc.createByDescFile(dir.getName(), descFile) : WebResourceDesc.createByDescFile(dir.getName());
            ++i;
        }
        return descs;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = WebtoolsPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

