/*
 * Created on 2004/06/06
 *
 */
package com.muimi.webwiz;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

/**
 * JSF@\ǉEBU[hy[WP
 * @author Shinji Miyamoto
 */
public class SelectContainerWizardPage extends WizardPage{

	private IProject project;
	private IPath webFolder;
	
	private Text webFolderText;
	private Button classpathCheckbox;
	private Button sourceAttachCheckbox;
	
	
	protected SelectContainerWizardPage(IStructuredSelection selection) {
		super("Select Folder");
		setTitle("Select Folder");
		setDescription("Select web folder and so on...");

		
    	Object selectElement = selection.getFirstElement();
    	IResource resource = getResource(selectElement);
    	if(resource instanceof IContainer){
    		webFolder = resource.getFullPath();
    	}
	}
	
	
	private IResource getResource(Object element){
    	if(element instanceof IJavaElement){
    		IJavaElement javaElement = (IJavaElement)element;
    		project = javaElement.getJavaProject().getProject();
    		IPath path = javaElement.getResource().getFullPath();    		
    		IWorkspace workspace = ResourcesPlugin.getWorkspace();
    		return workspace.getRoot().findMember(path);
    		
    	}else if(element instanceof IResource){
    		return (IResource)element;
    		
    	}else {
    		return null;
    	}
	}
	
	

    public void createControl(Composite parent) {
    	
    	Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
    	composite.setLayout(layout);

    	
    	//Web Folder
    	{
	    	Label label = new Label(composite, SWT.NULL);
	    	label.setText("Web Folder");
	    	
	        webFolderText = new Text(composite, SWT.BORDER);
			GridData data = new GridData(GridData.FILL_HORIZONTAL);
			data.widthHint = 200;
			webFolderText.setLayoutData(data);
			webFolderText.addModifyListener(new ModifyListener(){
				public void modifyText(ModifyEvent e) {
					validatePage();
				}
			});
	        
	        Button button = new Button(composite, SWT.BORDER);
	        button.setText("I");
	        

	        
	        button.addSelectionListener(new SelectionListener(){
				public void widgetSelected(SelectionEvent e) {
					
					ContainerSelectionDialog dialog = new ContainerSelectionDialog(
							Display.getDefault().getActiveShell(), 
							ResourcesPlugin.getWorkspace().getRoot(), 
							false,
							"select WebFolder");
					dialog.setInitialSelections(new Object[]{webFolder});
					int ret = dialog.open();
					if(ret == ContainerSelectionDialog.OK){
						IPath path = (IPath)dialog.getResult()[0];
						webFolderText.setText(path.toString());
					}
				}
				public void widgetDefaultSelected(SelectionEvent e) {
				}
	        });
    	}


    	{
    		Label label = new Label(composite, SWT.NULL);
        	label.setText("NXpXʂ");
        	sourceAttachCheckbox = new Button(composite, SWT.CHECK);
			GridData data = new GridData();
			data.horizontalSpan = 2;
			sourceAttachCheckbox.setLayoutData(data);
    	}    	
    	
    	{
    		Label label = new Label(composite, SWT.NULL);
        	label.setText("\[XYt");
        	classpathCheckbox = new Button(composite, SWT.CHECK);
			GridData data = new GridData();
			data.horizontalSpan = 2;
			classpathCheckbox.setLayoutData(data);
    	}
        
        setControl(composite);        
        initField();
    }
    
	private void initField() {
        if(webFolder != null){
        	webFolderText.setText(webFolder.toString());
        }
        classpathCheckbox.setSelection(true);
        sourceAttachCheckbox.setSelection(true);
	}
    
	private void validatePage(){
		String text = webFolderText.getText();
		if(text == null || text.length() == 0){
			setPageComplete(false);
			setErrorMessage("webFolder is required");
			return;
		}
		
		if(ResourcesPlugin.getWorkspace().getRoot().findMember(new Path(text)) == null){
			setPageComplete(false);
			setErrorMessage("webFolder is invalid");
			return;
		}
		
		setErrorMessage(null);
		setPageComplete(true);
	}
	
	
    public IContainer getWebFolder(){
    	String text = webFolderText.getText();
    	return (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(new Path(text));
    }
    public boolean isClasspathSelected(){
    	return classpathCheckbox.getSelection();
    }
    public boolean isSourceAttachSelected(){
    	return sourceAttachCheckbox.getSelection();
    }
    
}
