/*
 * Created on 2004/06/12
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.muimi.webwiz;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author miya
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class WebResourceDesc {

	private String label;
	private String path;
	private Map libMap;

	
	public WebResourceDesc(){
	}
	
	public static WebResourceDesc createByDescFile(String path, File file) {
		WebResourceDesc webDesc = new WebResourceDesc();
		webDesc.path = path;
		try{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		    DocumentBuilder builder = factory.newDocumentBuilder();
		    Document doc = builder.parse(file);
		    Element root = doc.getDocumentElement();
		    
		    webDesc.label = getChildElementText(root, "label");
		    
		    Map libMap = new HashMap();
		    NodeList srcElements = root.getElementsByTagName("lib");
		    for(int i=0; i<srcElements.getLength(); i++){
		    	Element srcElement = (Element)srcElements.item(i);
		    	String libname = getChildElementText(srcElement, "name");
		    	String src = getChildElementText(srcElement, "src");
		    	String javadoc = getChildElementText(srcElement, "javadoc");
		    	WebLibDesc libDesc = new WebLibDesc(webDesc, libname);
		    	libDesc.setSrc(src);
		    	libDesc.setJavadoc(javadoc);
		    	libMap.put(libname, libDesc);
		    } 
		    webDesc.libMap = libMap;
		    		    
		}catch(Exception e){
			e.printStackTrace();
		}
		return webDesc;	
	}
	
	public static WebResourceDesc createByDescFile(String path) {
		WebResourceDesc webDesc = new WebResourceDesc();
		webDesc.path = path;
		webDesc.label = path;
		return webDesc;
	}
	
	private static String getChildElementText(Element element, String name){
		Element child = (Element)element.getElementsByTagName(name).item(0);
		if(child == null){
			return "";
		}
		NodeList list = child.getChildNodes();
		for(int i=0; i<list.getLength(); i++){
			Node node = list.item(i);
			if(node.getNodeType() == Node.TEXT_NODE){
				return node.getNodeValue();
			}
		}
		return "";
	}
	
	
	
//	public String toString(){
//		return "label=" + label
//			+ "path=" + path
//			+ "srcpath=" + sourceMap
//			;
//	}

	
	

	public String getLabel() {
		return label;
	}
	public void setLabel(String label) {
		this.label = label;
	}
	public Map getLibMap() {
		return libMap;
	}
	public void setLibMap(Map libMap) {
		this.libMap = libMap;
	}
	public String getPath() {
		return path;
	}
	public void setPath(String path) {
		this.path = path;
	}
}
