/*
 * Created on 2004/06/02
 *
 */
package com.muimi.webwiz;


import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

import com.muimi.webwiz.WebWizBuilder;


/**
 * EBU[h
 * @author Shinji Miyamoto
 */
public class WebResourceImportWizard extends Wizard 
implements IImportWizard{

	private IWorkbench workbench;
	private IStructuredSelection selection;

	private SelectImportResourceWizardPage page1;
	private SelectContainerWizardPage page2;
	
	public WebResourceImportWizard(){
		setWindowTitle("Web Wizard");
	}
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
		this.selection = selection;
	}
	
    public void addPages() {

    	page1 = new SelectImportResourceWizardPage();
    	page1.setPageComplete(false);
        page2 = new SelectContainerWizardPage(selection);
        page2.setPageComplete(false);

        addPage(page1);
        addPage(page2);
    }
	
	public boolean performFinish() {
		
		WebWizBuilder builder = new WebWizBuilder();
		builder.setDesc(page1.getWebResourceDesc());
		builder.setWebFolder(page2.getWebFolder());
		builder.setClassPathAdd(page2.isClasspathSelected());
		builder.setSourceAttach(page2.isSourceAttachSelected());
		builder.build();
		
		return true;
	}    
}

