/*
 * Created on 2004/06/12
 *
 */
package com.muimi.webwiz;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

/**
 * @author Shinji Miyamoto
 */
public class WebWizBuilder {
	
	private IContainer webFolder;
	private WebResourceDesc webDesc;
	private boolean classPathAdd;
	private boolean sourceAttach;

	
	
	public void build(){
		
		//like assertion 
		if(webFolder == null){
			throw new IllegalStateException("Web Foler is null");
		}

		
		
		IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor)
					throws InvocationTargetException, InterruptedException {
				try {
					build_internal(monitor);
				} catch (Exception e) {
					WebtoolsPlugin.logError("fail to resource operation", e);
				}
			}
		};

		try {
			new ProgressMonitorDialog(new Shell()).run(true, true, op);

		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException ignore) {
			ignore.printStackTrace();
		} 
	}
	
	
	private void build_internal(IProgressMonitor monitor) throws Exception{
		monitor.beginTask("import resources", 10);		
		monitor.worked(1);
		importResources();
		monitor.worked(7);
		webFolder.refreshLocal(IResource.DEPTH_INFINITE, null);
		monitor.worked(1);
		
		if(classPathAdd){
			addClassPathEntry();
		}
		monitor.done();
	}

	
	private void importResources() throws Exception{
		String buildFileLoc = WebtoolsPlugin.getDefault().getResourcePath("script/copy.xml");
		String fromDirLoc = WebtoolsPlugin.getDefault().getResourcePath(asImportResourcePath());
		
		Properties prop = new Properties();
		String toDirLoc = webFolder.getLocation().toString();
		prop.setProperty("todir", toDirLoc);
		prop.setProperty("fromdir", fromDirLoc);

		AntRunner runner = new AntRunner();
		runner.setBuildFileLocation(buildFileLoc);
		runner.addUserProperties(prop);
		runner.run();
	}
	
	
	/**
	 * WEB-INF/libȉJARNXpXɒʂB
	 * ֘A\[X΁A\[XYts
	 * @throws CoreException
	 */
	private void addClassPathEntry() throws CoreException{

		IProject project = webFolder.getProject();
		IJavaProject jProject = JavaCore.create(project);
		
		List entries = new ArrayList();
		
		IProjectDescription desc =  project.getDescription();			

		IClasspathEntry[] rawEntries = jProject.getRawClasspath();
		for(int i=0; i<rawEntries.length; i++){
			entries.add(rawEntries[i]);
		}
				
		IResource[] jars = webFolder.getFolder(new Path("WEB-INF/lib")).members();
		for(int i=0; i<jars.length; i++){
			IResource jar = jars[i];
			IPath jarPath = jar.getFullPath();
			if(containEntry(entries, jarPath)){
				continue;
			}
			
			IPath srcPath = null;
			WebLibDesc libDesc = (WebLibDesc)webDesc.getLibMap().get(jar.getName());
			if(libDesc != null){
				srcPath = libDesc.getSourcePath();

				//javadoc
				URL javadocUrl = libDesc.getJavaDocURL();
				if(javadocUrl != null){
					JavaUI.setLibraryJavadocLocation(jarPath, javadocUrl);
				}
			}
						
			entries.add(
					JavaCore.newLibraryEntry(
					jarPath,
					srcPath, 
					null));
		}

		jProject.setRawClasspath((IClasspathEntry[])entries.toArray(new IClasspathEntry[0]), new NullProgressMonitor());
	}	
	
	

	
	private boolean containEntry(List entries, IPath path){
		for(int i=0; i<entries.size(); i++){
			IClasspathEntry entry = (IClasspathEntry)entries.get(i);
			if(entry.getPath().equals(path)){
				return true;
			}
		}
		return false;
	}
	
	
	private String asImportResourcePath(){
		return "resource/" + webDesc.getPath() + "/web";
	}

	

	

	

	


	//
	// setter and getters
	//

	public boolean isClassPathAdd() {
		return classPathAdd;
	}
	public void setClassPathAdd(boolean classPathAdd) {
		this.classPathAdd = classPathAdd;
	}
	public WebResourceDesc getDesc() {
		return webDesc;
	}
	public void setDesc(WebResourceDesc desc) {
		this.webDesc = desc;
	}
	public boolean isSourceAttach() {
		return sourceAttach;
	}
	public void setSourceAttach(boolean sourceAttach) {
		this.sourceAttach = sourceAttach;
	}
	public IContainer getWebFolder() {
		return webFolder;
	}
	public void setWebFolder(IContainer webFolder) {
		this.webFolder = webFolder;
	}
}
