/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.edocbook.core.Param;
import jp.sourceforge.edocbook.core.Template;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jp.sourceforge.edocbook.ui.popup";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void showErrorDialog(Throwable t) {
        Status status = new Status(4, PLUGIN_ID, 0, t.getMessage(), t);
        Activator.log(t);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"Error occured!", (IStatus)status);
    }

    public static void showMessageDialog(String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
        messageBox.setText("information");
        messageBox.setMessage(message);
        messageBox.open();
    }

    public static void log(Throwable t) {
        Status status = new Status(4, PLUGIN_ID, 4, t.getMessage(), t);
        Activator.getDefault().getLog().log((IStatus)status);
        t.printStackTrace();
    }

    public static Map<String, String> setupPreference(String keys) {
        LinkedHashMap<String, String> preferenceMap = new LinkedHashMap<String, String>();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String[] stringArray = Activator.convertKeys(store.getString(keys));
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.length() != 0) {
                preferenceMap.put(key, store.getString(key));
            }
            ++n2;
        }
        return preferenceMap;
    }

    private static String[] convertKeys(String keys) {
        if (keys == null) {
            return new String[0];
        }
        ArrayList<String> keyList = new ArrayList<String>();
        String[] stringArray = keys.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            keyList.add(key);
            ++n2;
        }
        return keyList.toArray(new String[0]);
    }

    public static List<Param> getPreferenceAsParam(String keys) {
        ArrayList<Param> params = new ArrayList<Param>(0);
        for (Map.Entry<String, String> entry : Activator.setupPreference(keys).entrySet()) {
            params.add(new Param(entry.getKey(), entry.getValue()));
        }
        return params;
    }

    public static List<Template> getPreferenceAsTemplate(String keys) {
        ArrayList<Template> templates = new ArrayList<Template>(0);
        for (Map.Entry<String, String> entry : Activator.setupPreference(keys).entrySet()) {
            templates.add(new Template(entry.getKey(), entry.getValue()));
        }
        return templates;
    }
}

