/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.popup.html.actions;

import java.util.List;
import java.util.Properties;
import jp.sourceforge.edocbook.core.DocbookFile;
import jp.sourceforge.edocbook.core.DocbookXsl;
import jp.sourceforge.edocbook.core.EDocbookRuntimeException;
import jp.sourceforge.edocbook.core.Param;
import jp.sourceforge.edocbook.core.Template;
import jp.sourceforge.edocbook.ui.popup.Activator;
import jp.sourceforge.edocbook.ui.popup.actions.AbstractCreateAction;
import org.eclipse.jface.action.IAction;

public abstract class AbstractHtmlCreateAction
extends AbstractCreateAction {
    public static final String PARAM_KEYS = "jp.sourceforge.edocbook.ui.popup.html.param_keys";
    public static final String TEMPLATE_KEYS = "jp.sourceforge.edocbook.ui.popup.html.template_keys";

    public void run(IAction action) {
        try {
            DocbookFile source = this.getSourceFile();
            if (source == null) {
                return;
            }
            this.createXslFile().apply(source);
            this.reflesh();
            Activator.showMessageDialog("Output completed.");
        }
        catch (EDocbookRuntimeException e) {
            Activator.showErrorDialog(e);
        }
    }

    @Override
    protected abstract DocbookXsl createXslFile();

    @Override
    protected Properties createOutputProperties() {
        Properties prop = new Properties();
        prop.put("doctype-public", "-//W3C//DTD HTML 4.01 Transitional//EN");
        prop.put("doctype-system", "http://www.w3.org/TR/html4/loose.dtd");
        prop.put("method", "html");
        prop.put("indent", "yes");
        prop.put("encoding", "UTF-8");
        return prop;
    }

    @Override
    protected List<Param> createParameters() {
        return Activator.getPreferenceAsParam(PARAM_KEYS);
    }

    @Override
    protected List<Template> createTemlates() {
        return Activator.getPreferenceAsTemplate(TEMPLATE_KEYS);
    }
}

