/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.ui.preferences.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.sourceforge.edocbook.core.Template;
import jp.sourceforge.edocbook.ui.preferences.dialog.TemplateEditComposite;
import jp.sourceforge.edocbook.ui.preferences.dialog.TemplateEditModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TemplateEditDialog
extends Dialog {
    private TemplateEditComposite composite;
    private TemplateEditModel model = new TemplateEditModel();
    private TemplateChangeListener listener;

    public TemplateEditDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public TemplateEditDialog(Shell parentShell, Template model) {
        super(parentShell);
        if (model != null) {
            this.model.setName(model.getName());
            this.model.setBody(model.getBody());
        }
        this.listener = new TemplateChangeListener();
        this.model.addPropertyChangeListener(this.listener);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Edit xsl:template");
        this.composite = new TemplateEditComposite(parent, 0, this.model);
        return this.composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setEnabled(this.model.getName().length() != 0);
    }

    public boolean close() {
        this.model.removePropertyChangeListener(this.listener);
        return super.close();
    }

    public Template getEditModel() {
        return new Template(this.model.getName(), this.model.getBody());
    }

    private class TemplateChangeListener
    implements PropertyChangeListener {
        private TemplateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Button okButton = TemplateEditDialog.this.getButton(0);
            okButton.setEnabled(((TemplateEditModel)e.getSource()).getName().length() != 0);
        }
    }
}

