/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.edocbook.core;

import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import jp.sourceforge.edocbook.core.DocbookFile;
import jp.sourceforge.edocbook.core.EDocbookRuntimeException;
import jp.sourceforge.edocbook.core.ResultFile;

public class DocbookTransformer {
    private Transformer transformer;

    public DocbookTransformer(Source xsl) {
        this.transformer = this.createTransformer(xsl);
    }

    public ResultFile transform(DocbookFile source, String extension) {
        try {
            assert (this.transformer != null);
            ResultFile result = new ResultFile(this.getReplaceExtensionFile(source, extension));
            this.transformer.transform(source.getSource(), result.getResult());
            return result;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new EDocbookRuntimeException(e);
        }
    }

    public void setOutputProperty(String key, String value) {
        this.transformer.setOutputProperty(key, value);
    }

    public void setParameter(String param, String value) {
        this.transformer.setParameter(param, value);
    }

    private File getReplaceExtensionFile(DocbookFile source, String ext) {
        String systemId = source.getSystemId();
        int idx = systemId.lastIndexOf(".");
        String newPath = String.valueOf(systemId.substring(0, idx)) + "." + ext;
        return new File(newPath);
    }

    private Transformer createTransformer(Source xsl) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer(xsl);
            assert (transformer != null);
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new EDocbookRuntimeException(e);
        }
    }
}

