package jp.ac.takushoku_u.cs;

/**
* LFTAnalysis饹LFTʬϤԤΥ饹Ǥ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2004ǯ1006
*/
public class LFTAnalysis{
	
/**
* ԤΥޥȥꥯݻޥȥꥯ
*/
	private Matrix teacherMatrix;
	
/**
* ؽԤΥޥȥꥯݻޥȥꥯ
*/
	private Matrix studentMatrix;
	
/**
* Ԥβãޥȥꥯݻޥȥꥯ
*/
	private Matrix reachTeacherMatrix;
	
/**
* ؽԤβãޥȥꥯݻޥȥꥯ
*/
	private Matrix reachStudentMatrix;
	
/**
* ԤΥޥȥꥯˤƻޤν٤ݻޥȥꥯ
*/
	private Matrix edgeTeacherMatrix;
	
/**
* ؽԤΥޥȥꥯˤƻޤν٤ݻޥȥꥯ
*/
	private Matrix edgeStudentMatrix;
	
/**
* ٤ݻѿ
*/
	private double resemble;
	
/**
* ã٤ݻѿ
*/
	private double attainment;
	
/**
* ԤȳؽԤΥޥȥꥯˤޥȥꥯ
*/
	private Matrix mixMatrix;
	
/**
* ͭޤɽ
*/
	private static final int LFT_BRANCH_TRUE = 1;
	
/**
* ͭޤʤɽ
*/
	private static final int LFT_BRANCH_FALSE = 0;
	
/**
* ˤޥȥꥯǶԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final int LFT_BRANCH_TEACHER = 3;
	
/**
* ˤޥȥꥯǳؽԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final int LFT_BRANCH_STUDENT = 4;
	
/**
* ޥȥꥯΥǥե͡
*/
	private static final int LFT_MATRIX_VALUE = 5;
	
/**
* ꤵƤǥեȤΥʬϤԤޥȥꥯꤷʬϤԤޤ<BR>
* ԤȳؽξΥޥȥꥯǤ0Ȥʤޤ
*/
	public LFTAnalysis(){
		Matrix baseTeacherMatrix = new Matrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		Matrix baseStudentMatrix = new Matrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		
		//ԤΥޥȥꥯꤷޤ
		setTeacherMatrix(baseTeacherMatrix);
		
		//ؽԤΥޥȥꥯꤷʬϤԤ
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯꤷʬϤԤޤ<BR>
* ؽԤΥޥȥꥯ϶ԤΥޥȥꥯƱǡǤ0Ȥʤޤ<BR>
* ԤΥޥȥꥯǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	public LFTAnalysis(Matrix baseTeacherMatrix){
		Matrix baseStudentMatrix =
		new Matrix(baseTeacherMatrix.getRowLength(), baseTeacherMatrix.getColLength(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
			
		//ԤΥޥȥꥯꤷޤ
		setTeacherMatrix(baseTeacherMatrix);
			
		//ؽԤΥޥȥꥯꤷʬϤԤ
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯꤷʬϤԤޤ<BR>
* ԤΥޥȥꥯȳؽԤΥޥȥꥯפξԤȤǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @param baseStudentMatrix ؽԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤޤϳؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public LFTAnalysis(Matrix baseTeacherMatrix, Matrix baseStudentMatrix){
		
		//ԤΥޥȥꥯꤷޤ
		setTeacherMatrix(baseTeacherMatrix);
			
		//ؽԤΥޥȥꥯꤷʬϤԤ
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* LFTʬϤԤޤ
*/
	private void Analysis(){
		calculateResemble();	//٤
		calculateAttainment();	//ã٤
		
		//ԤΥޥȥꥯȳؽԤΥޥȥꥯˤޥȥꥯ
		setAgreementMatrix(calculateAgreementMatrix(teacherMatrix, studentMatrix));
	}
	
/**
* ٤ޤ
*/
	private void calculateResemble(){
		double denominator = 0.0; //ʬ(OR)
		double numerator = 0.0; //ʬ(AND)
		
		//Фޥȥꥯ
		Matrix pairTeacherMatrix = new Matrix(getElement(), getElement());
		Matrix pairStudentMatrix = new Matrix(getElement(), getElement());
		
		//׻ǻѤޥȥꥯ
		Matrix resultMatrix = new Matrix(getElement(), getElement());
		for (int i = 0; i < getElement(); i++){
			for (int j = 0; j < getElement(); j++){
				
				//ԤΥޥȥꥯǤ2Ǵ֤˻ޤФǴ֤н
				if (teacherMatrix.getCell(i, j) > 0){
				pairTeacherMatrix.MatrixCopy(getPairMatrix(reachTeacherMatrix, i, j));
				}
				
				//ޤʤн϶
				else{
					pairTeacherMatrix.clearMatrix();
				}
				
				//ؽԤΥޥȥꥯǤ2Ǵ֤˻ޤФǴ֤н
				if (studentMatrix.getCell(i, j) > 0){
				pairStudentMatrix.MatrixCopy(getPairMatrix(reachStudentMatrix, i, j));
				}
				
				//ޤʤн϶
				else{
					pairStudentMatrix.clearMatrix();
				}
				
				//ʬη׻
				resultMatrix.MatrixCopy(pairTeacherMatrix.getOrMatrix(pairStudentMatrix));
				denominator = resultMatrix.getElement() + denominator;
				
				//ʬҤη׻
				resultMatrix.MatrixCopy(pairTeacherMatrix.getAndMatrix(pairStudentMatrix));
				numerator = resultMatrix.getElement() + numerator;
			}
		}
		
		setResemble(numerator / denominator);
	}
	
/**
* ã٤ޤ
*/
	private void calculateAttainment(){
		setAttainment(Math.sqrt(getResemble()) * 100);
	}

/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯˤޥȥꥯޤ<BR>
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤ3
* ؽԤΥޥȥꥯΤߤ˻ޤ4ޤ
* Υޥȥꥯι̾̾϶ԤΥޥȥꥯƱˤʤޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @param baseStudentMatrix ؽԤΥޥȥꥯ
* @return ˤޥȥꥯ
*/
	private Matrix calculateAgreementMatrix(Matrix baseTeacherMatrix, Matrix baseStudentMatrix){
		Matrix returnMatrix = new Matrix(getElement(), getElement(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
		
		for (int i = 0; i < getElement(); i++){
			for (int j = 0; j < getElement(); j++){
				if (baseTeacherMatrix.getCell(i,j) == baseStudentMatrix.getCell(i,j)){
					returnMatrix.setCell(i,j,baseTeacherMatrix.getCell(i,j));
				}
				else if (baseTeacherMatrix.getCell(i,j) == LFT_BRANCH_TRUE &&
					baseStudentMatrix.getCell(i,j) == LFT_BRANCH_FALSE){
					returnMatrix.setCell(i,j,LFT_BRANCH_TEACHER);
				}
				else{
					returnMatrix.setCell(i,j,LFT_BRANCH_STUDENT);
				}
			}
		}
		return returnMatrix;
	}
	
/**
* ܥޥȥꥯ򸵤ˤǴ֤нޤ
* @param nextMatrix Ĵ٤ܥޥȥꥯ
* @param startI ͭޤλ
* @param goalJ ͭޤν
* @return ɤǴ֤Фޥȥꥯ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	public Matrix getElementPairMatrix(Matrix nextMatrix, int startI, int goalJ){
		if (nextMatrix.isMatrixEntityPoint(startI, goalJ)){
			
			//ãޥȥꥯ
			Matrix lookMatrix = new Matrix(nextMatrix.getRowLength(), nextMatrix.getColLength(),
				nextMatrix.getRowNameArray(), nextMatrix.getColNameArray());
			lookMatrix.MatrixCopy(nextMatrix.getReachMatrix());
			lookMatrix.convertLogicMatrix();
			
			Matrix returnMatrix = new Matrix(lookMatrix.getRowLength(), lookMatrix.getColLength(), 
				lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
			
			//ޤ¸ߤ뤫ɤ
			if (nextMatrix.getCell(startI, goalJ) > 0){
				returnMatrix.MatrixCopy(getPairMatrix(lookMatrix, startI, goalJ));
			}
			return returnMatrix;
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* ãޥȥꥯ򸵤ˤǴ֤нޤ<BR>
* ܥޥȥꥯΤ١2Ǵ֤ܤƤ뤫ݾڤʤᡢ
* Υ᥽åɤѤϤǴƱΤܤƤ뤳Ȥåɬפޤ
* @param lookMatrix Ĵ٤ãޥȥꥯ
* @param startI ͭޤθֹ
* @param goalJ ͭޤֹ
* @return ɤǴ֤Фޥȥꥯ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	private Matrix getPairMatrix(Matrix lookMatrix, int startI, int goalJ){
		if (lookMatrix.isMatrixEntityPoint(startI, goalJ)){
			lookMatrix.convertLogicMatrix();
			Matrix returnMatrix = new Matrix(lookMatrix.getRowLength(),lookMatrix.getColLength(), 
				lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
			for (int i = 0; i < lookMatrix.getRowLength(); i++){
				for (int j = 0; j < lookMatrix.getColLength(); j++){
					if (lookMatrix.getCell(i, startI) * lookMatrix.getCell(goalJ, j) > 0){
						returnMatrix.setCell(i, j, LFT_BRANCH_TRUE);
					}
					else{
						returnMatrix.setCell(i, j, LFT_BRANCH_FALSE);
					}
				}
			}
			return returnMatrix;
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* ޥȥꥯ¸ߤޤν٤ޤ
* @param _matrix ٤оݤܥޥȥꥯ
* @return ޤν٤Ǽޥȥꥯ
*/
	
	private Matrix getImportantEdgeMatrix(Matrix _matrix){
		Matrix returnMatrix = new Matrix(_matrix.getRowLength(), _matrix.getColLength(),
			_matrix.getRowNameArray(), _matrix.getColNameArray());
		Matrix temporaryMatrix = new Matrix(_matrix.getRowLength(), _matrix.getColLength());
		double cont = Math.floor(getElement() / 2) * Math.floor((getElement() + 1) / 2);
		
		for (int i = 0;i < _matrix.getRowLength(); i++){
			for (int j = 0; j < _matrix.getColLength(); j++){
				double value = 0.0;
				
				//ޤ¸ߤ뤫ɤ
				if (_matrix.getCell(i, j) > 0){
					temporaryMatrix.MatrixCopy(getElementPairMatrix(_matrix, i, j));
					value = temporaryMatrix.getElement();
					value = value / cont;
				}
				returnMatrix.setCell(i, j, value);
			}
		}
		return returnMatrix;
	}
	
	
/**
* ԤΥޥȥꥯ֤ޤ
* @return ԤΥޥȥꥯ
* @see #getStudentMatrix()
*/
	public Matrix getTeacherMatrix(){
		return teacherMatrix;
	}
	
/**
* ؽԤΥޥȥꥯ֤ޤ
* @return ؽԤΥޥȥꥯ
* @see #getTeacherMatrix()
*/
	public Matrix getStudentMatrix(){
		return studentMatrix;
	}
	
/**
* 2֤ˤ붵ԤȳؽԤλޤξ֤֤ޤ
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤ3
* ؽԤΥޥȥꥯΤߤ˻ޤ4ޤ
* @param startI ͭޤλ
* @param goalJ ͭޤν
* @return ޤξ
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getAgreementMatrix()
*/
	public int getAgreementEdge(int startI, int goalJ){
		if (mixMatrix.isMatrixEntityPoint(startI, goalJ)){
			return (int) mixMatrix.getCell(startI, goalJ);
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯˤޥȥꥯ֤ޤ
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤ3
* ؽԤΥޥȥꥯΤߤ˻ޤ4ޤ
* Υޥȥꥯι̾̾϶ԤΥޥȥꥯƱˤʤޤ
* @return ˤޥȥꥯ
* @see #getAgreementEdge(int startI, int goalJ)
*/
	public Matrix getAgreementMatrix(){
		return mixMatrix;
	}
	
/**
* Ԥβãޥȥꥯ֤ޤ
* @return Ԥβãޥȥꥯ
* @see #getReachStudentMatrix()
*/
	public Matrix getReachTeacherMatrix(){
		return reachTeacherMatrix;
	}
	
/**
* ؽԤβãޥȥꥯ֤ޤ
* @return ؽԤβãޥȥꥯ
* @see #getReachTeacherMatrix()
*/
	public Matrix getReachStudentMatrix(){
		return reachStudentMatrix;
	}
	
/**
* ԤΥޥȥꥯˤꤷޤν٤֤ޤ
* @param startI ͭޤλ
* @param goalJ ͭޤν
* @return 
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getImportanceEdgeStudent(int startI, int goalJ)
* @see #getEdgeTeacherMatrix()
*/
	public double getImportanceEdgeTeacher(int startI, int goalJ){
		if (edgeTeacherMatrix.isMatrixEntityPoint(startI, goalJ)){
			return edgeTeacherMatrix.getCell(startI, goalJ);
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* Ԥλޤν٤᤿ޥȥꥯ֤ޤ
* @return ٤᤿ޥȥꥯ
* @see #getEdgeStudentMatrix()
* @see #getImportanceEdgeTeacher(int startI, int goalJ)
*/
	public Matrix getEdgeTeacherMatrix(){
		return edgeTeacherMatrix;
	}
	
/**
* ؽԤΥޥȥꥯˤꤷޤν٤֤ޤ
* @param startI ͭޤλ
* @param goalJ ͭޤν
* @return 
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getEdgeTeacherMatrix()
* @see #getImportanceEdgeStudent(int startI, int goalJ)
*/
	public double getImportanceEdgeStudent(int startI, int goalJ){
		if (edgeStudentMatrix.isMatrixEntityPoint(startI, goalJ)){
			return edgeStudentMatrix.getCell(startI, goalJ);
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* ؽԤλޤν٤᤿ޥȥꥯ֤ޤ
* @return ٤᤿ޥȥꥯ
* @see #getEdgeStudentMatrix()
* @see #getImportanceEdgeTeacher(int startI, int goalJ)
*/
	public Matrix getEdgeStudentMatrix(){
		return edgeStudentMatrix;
	}
	
/**
* ޥȥꥯˤǿ(Ԥޤ)֤ޤ
* @return ǿ
*/
	public int getElement(){
		return teacherMatrix.getRowLength();
	}
	
/**
* ԤΥޥȥꥯˤͭޤο֤ޤ
* @return ԤΥޥȥꥯˤͭޤο
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAgreementEdge()
*/
	public int getTeacherEdge(){
		return teacherMatrix.getElement();
	}
	
/**
* ؽԤΥޥȥꥯˤͭޤο֤ޤ
* @return ؽԤΥޥȥꥯˤͭޤο
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAgreementEdge()
*/
	public int getStudentEdge(){
		return studentMatrix.getElement();
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯΤɤ餫ˤǤ¸ߤͭޤο֤ޤ
* @return ɤ餫ˤǤ⤢ͭޤο
* @see #getAgreementEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
	public int getTotelEdge(){
		return mixMatrix.getElement();
	}
	
/**
* ԤΥޥȥꥯˤΤ¸ߤͭޤο֤ޤ
* @return ԤΥޥȥꥯˤΤ¸ߤͭޤο
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAgreementEdge()
*/
	public int getTeacherOnlyEdge(){
		int count = 0;
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_BRANCH_TEACHER){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ؽԤΥޥȥꥯˤΤ¸ߤͭޤο֤ޤ
* @return ؽԤΥޥȥꥯˤΤ¸ߤͭޤο
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAgreementEdge()
*/
	public int getStudentOnlyEdge(){
		int count = 0;
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_BRANCH_STUDENT){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ԤΥޥȥꥯˤؽԤΥޥȥꥯˤ¸ߤͭޤο֤ޤ
* @return ξԤˤͭޤο
* @see #getTotelEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
	public int getAgreementEdge(){
		int count = 0;
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_BRANCH_TRUE){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ٤֤ޤ
* @return 
*/
	public double getResemble(){
		return resemble;
	}
	
/**
* ã٤֤ޤ
* @return ã
*/
	public double getAttainment(){
		return attainment;
	}
	
/**
* ԤΥޥȥꥯꤷޤ<BR>
* Ʊ˶Ԥβãޥȥꥯꤵޤ
* @param baseTeacherMatrix 򤹤붵ԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	private void setTeacherMatrix(Matrix baseTeacherMatrix){
		if (baseTeacherMatrix.isSquare()){
			teacherMatrix = new Matrix();
			teacherMatrix.MatrixCopy(baseTeacherMatrix);
			teacherMatrix.convertLogicMatrix();
			reachTeacherMatrix = new Matrix();
			reachTeacherMatrix.MatrixCopy(teacherMatrix.getReachMatrix());
			reachTeacherMatrix.convertLogicMatrix();
			
			edgeTeacherMatrix = new Matrix();
			
			//ԤΥդλޤν٤
			edgeTeacherMatrix.MatrixCopy(getImportantEdgeMatrix(teacherMatrix));
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ؽԤΥޥȥꥯꤷʬϤԤޤ<BR>
* Ʊ˳ؽԤβãޥȥꥯꤵޤ
* @param baseStudentMatrix 򤹤ؽԤΥޥȥꥯ
* @exception NotSquareMatrixException ؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public void setStudentMatrix(Matrix baseStudentMatrix){
		if (baseStudentMatrix.isSquare()){
			if (teacherMatrix.isSameMatrixSize(baseStudentMatrix)){
				studentMatrix = new Matrix();
				studentMatrix.MatrixCopy(baseStudentMatrix);
				studentMatrix.convertLogicMatrix();
				reachStudentMatrix = new Matrix();
				reachStudentMatrix.MatrixCopy(studentMatrix.getReachMatrix());
				reachStudentMatrix.convertLogicMatrix();
				edgeStudentMatrix = new Matrix();
				
				//ؽԤΥդλޤν٤
				edgeStudentMatrix.MatrixCopy(getImportantEdgeMatrix(studentMatrix));
				
				//ʬϤԤ
				Analysis();
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ԤȳؽԤΥޥȥꥯˤޥȥꥯꤷޤ
* @param baseMatrix 򤹤ˤޥȥꥯ
*/
	private void setAgreementMatrix(Matrix baseMatrix){
		mixMatrix = new Matrix();
		mixMatrix.MatrixCopy(baseMatrix);
	}
	
/**
* ٤ꤷޤ
* @param baseResemble 
*/
	private void setResemble(double baseResemble){
		resemble = baseResemble;
	}
	
/**
* ã٤ꤷޤ
* @param baseAttainment ã
*/
	private void setAttainment(double baseAttainment){
		attainment = baseAttainment;
	}
	
}