package jp.ac.takushoku_u.cs;

/**
* Matrix饹Ǥϥޥȥꥯ򰷤ޤ<BR>
* ޥȥꥯʬϥǡ̾̾դݻǤ褦ˤʤޤ
* ޤޥȥꥯƱΤα黻ԤȤǤޤ<BR>
* @version 1.1
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2004ǯ0928
*/
public class Matrix{

/**
* ԤΥݻѿ
*/
    private int matrixRowSize;
	
/**
* Υݻѿ
*/
	private int matrixColSize;
	
/**
* ޥȥꥯγǤΥǡǼ2
*/
    private double[ ][ ] matrix;
	
/**
* ̾Ǽ
*/
	private String[ ] matrixRowName;
	
/**
* ̾Ǽ
*/
	private String[ ] matrixColName;
	
/**
* ޥȥꥯ򥯥ꥢȤ͡
*/
	private static final double MATRIX_CLEAR_VALUE = 0.0;
	
/**
* 2ιԥΥǥե͡
*/
	private static final int MATRIX_INIT_ROW_SIZE = 5;
	
/**
* 2󥵥Υǥե͡
*/
	private static final int MATRIX_INIT_COL_SIZE = 5;
	
/**
* False͡
*/
	private static final double MATRIX_VALUE_FALSE = 0.0;
	
/**
* True͡
*/
	private static final double MATRIX_VALUE_TRUE = 1.0;


/**
* ꤵƤ륵Υǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿20ǽޤ
* ̾̾Ϲֹֹꤵޤ
*/
	public Matrix(){
		setSizeMatrix(MATRIX_INIT_ROW_SIZE,MATRIX_INIT_COL_SIZE);
		clearMatrix();
		setRowNameNumber();
		setColNameNumber();
	}

/**
* ꤵ줿ԥ󥵥򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿20ǽޤ
* ̾̾Ϲֹֹꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public Matrix(int rowSize, int colSize){
		setSizeMatrix(rowSize,colSize);
		clearMatrix();
		setRowNameNumber();
		setColNameNumber();
	}
	
/**
* ꤵ줿ԥ󥵥򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* 줿20ǽޤ
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param nameNumber ̾̾γֹ
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public Matrix(int rowSize, int colSize, int nameNumber){
		setSizeMatrix(rowSize,colSize);
		clearMatrix();
		setRowNameNumber(nameNumber);
		setColNameNumber(nameNumber);
	}
	
/**
* ꤵ줿ԥ󥵥̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿20ǽޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
* @exception IndexOutOfBoundsException ԡˤäζۤǡΥ
* @exception NullPointerException  rowName ޤ colName  null ξ
*/
	public Matrix(int rowSize, int colSize, String[] rowName, String[] colName){
		setSizeMatrix(rowSize, colSize);
		clearMatrix();
		
		//̾̾Υԡ
		System.arraycopy(rowName, 0, matrixRowName, 0, rowName.length);
		System.arraycopy(colName, 0, matrixColName, 0, colName.length);
	}
	
/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* ̾̾Ϲֹֹꤵޤ
* @param originalMatrix ꤹ2
* @exception IndexOutOfBoundsException ԡˤäζۤǡΥ
* @exception NullPointerException  originalMatrix  null ξ
*/
	public Matrix(double[][] originalMatrix){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < originalMatrix.length; i++){
			System.arraycopy(originalMatrix[i], 0, matrix[i], 0, originalMatrix[i].length);
		}
		setRowNameNumber();
		setColNameNumber();
	}

/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param originalMatrix ꤹ2
* @param nameNumber ̾̾γֹ
* @exception IndexOutOfBoundsException ԡˤäζۤǡΥ
* @exception NullPointerException  originalMatrix  null ξ
*/
	public Matrix(double[][] originalMatrix, int nameNumber){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for(int i = 0; i < originalMatrix.length; i++){
			System.arraycopy(originalMatrix[i], 0, matrix[i], 0, originalMatrix[i].length);
		}
		setRowNameNumber(nameNumber);
		setColNameNumber(nameNumber);
	}

/**
* ꤵ줿2󡢹̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ
* @param originalMatrix ꤹ2
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception IndexOutOfBoundsException ԡˤäζۤǡΥ
* @exception NullPointerException  rowName , colName ޤ originalMatrix  null ξ
*/
	public Matrix(double[][] originalMatrix, String[] rowName, String[] colName){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < originalMatrix.length; i++){
			System.arraycopy(originalMatrix[i], 0, matrix[i], 0, originalMatrix[i].length);
		}
		
		//̾̾Υԡ
		System.arraycopy(rowName, 0, matrixRowName, 0, rowName.length);
		System.arraycopy(colName, 0, matrixColName, 0, colName.length);
	}


/**
* ꤵ줿1ͤꤷޤ
* @param row ֹ
* @param col ֹ
* @param value 
* @exception NotElementException ꤷ¸ߤʤ
*/
	public void setCell(int row,int col,double value){
		if (isMatrixEntityPoint(row, col)){
			matrix[row][col] = value;
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}

/**
* ޥȥꥯ¾Υޥȥꥯǡ̾̾Ƥ򥳥ԡޤ<BR>
* ԡΥޥȥꥯȰפʤϥԡΥޥȥꥯѹԡԤޤ
* @param originalMatrix ԡΥޥȥꥯ
* @see #MatrixElementCopy(Matrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void MatrixCopy(Matrix originalMatrix){
		
		//ǧפʤϥѹޤ
		if ((getRowLength() != originalMatrix.getRowLength()) ||
			(getColLength() != originalMatrix.getColLength())){
				setSizeMatrix(originalMatrix.getRowLength(), originalMatrix.getColLength());
		}
		
		//ԡ򤷤ޤ
			for (int i = 0; i < getRowLength(); i++){
				setRowName(i, originalMatrix.getRowName(i));
				for (int j = 0; j < getColLength(); j++){
					if (i == 0){
						setColName(j, originalMatrix.getColName(j));
					}
					setCell(i, j, originalMatrix.getCell(i, j));
				}
			}
	}
	
/**
* ֤ǳϤǤ饳ԡΥޥȥꥯλ֤Ǥ򥳥ԡޤ<BR>
* ԡ( baseRow , baseCol )ǻꤵ줿Ǥ򳫻ϰ֤ȤrowLength  colLength ʬ
* ( copyRow , copyCol )ꤵǤϤޤǤ˥ԡԤޤ
* ԡϰϤƤϤޤʤǤȹ̾̾ѹޤ
* @param originalMatrix ԡΥޥȥꥯ
* @param baseRow ԡΥޥȥꥯФ륳ԡιԳϰ
* @param baseCol ԡΥޥȥꥯФ륳ԡ󳫻ϰ
* @param copyRow ԡԳϰ
* @param copyCol ԡ󳫻ϰ
* @param rowLength ԡԤԤǿ
* @param colLength ԡԤǿ
* @exception SetValueOutOfBoundsException ԡ褬¸ߤʤϰϤˤ
* @see #MatrixCopy(Matrix originalMatrix)
*/
	public void MatrixElementCopy(Matrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
		
		//ԡΥǧޤ
		if ((getRowLength() - copyRow >= rowLength) &&
			(getColLength() - copyCol >= colLength) &&
			(originalMatrix.getRowLength() >= (rowLength + baseRow)) &&
			(originalMatrix.getColLength() >= (colLength + baseCol))){
			for (int i = 0 + copyRow; i < copyRow + rowLength; i++){
				for (int j = 0 + copyCol; j < copyCol + colLength; j++){
					setCell(i, j, originalMatrix.getCell(i, j));
				}
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* ޥȥꥯ¸ߤǤ0ˤޤ
*/
	public void clearMatrix(){
		for (int i = 0 ; i < matrixRowSize ; i++){
			for (int j = 0 ; j < matrixColSize ; j++){
				setCell(i, j, MATRIX_CLEAR_VALUE);
			}
		}
	}
	
/**
* Ԥι̾դޤ
* @param row ֹ
* @param rowName ̾
* @exception NotElementException ꤵ줿Ԥ¸ߤʤ
* @see #setColName(int col,String colName)
*/
	public void setRowName(int row,String rowName){
		if (isRowNumber(row)){
			matrixRowName[row] = rowName;
		}
		else{
			throw new NotElementException("row("+ row + ")");
		}
	}
	
/**
* ̾դޤ
* @param col ֹ
* @param colName ̾
* @exception NotElementException ꤵ줿¸ߤʤ
* @see #setRowName(int row,String rowName)
*/
	public void setColName(int col,String colName){
		if (isColNumber(col)){
			matrixColName[col] = colName;
		}
		else{
			throw new NotElementException("col("+ col+")");
		}
	}
	
	
/**
* ꤵ줿1֤ͤޤ
* @param row ֹ
* @param col ֹ
* @return ꤷ
* @exception NotElementException ꤵ줿¸ߤʤ
*/
	public double getCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			return matrix[row][col];
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* ޥȥꥯιԥ֤ޤ
* @return ԥ
* @see #getColLength()
*/
	public int getRowLength(){
		return matrixRowSize;
	}
	
/**
* ޥȥꥯ󥵥֤ޤ
* @return 󥵥
* @see #getRowLength()
*/
	public int getColLength(){
		return matrixColSize;
	}
	
/**
* ꤷԤˤͤιפ֤ޤ
* @param row ֹ
* @return ꤷԤι
* @exception NotElementException ꤷԤ¸ߤʤ
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public double getRowSum(int row){
		if (isRowNumber(row)){
			double val = 0.0;
			for (int i = 0; i < getColLength(); i++){
				val = getCell(row, i) + val;
			}
			return val;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* ƹԤΤ줾ιפ֤ޤ
* @return ƹԤιͤä
* @see #getColSumArray()
* @see #getRowSum(int row)
*/
	public double[] getRowSumArray(){
		double[] returnArray = new double[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowSum(i);
		}
		return returnArray;
	}
	
/**
* ꤷˤͤιפ֤ޤ
* @param col ֹ
* @return ꤷι
* @exception NotElementException ꤷ¸ߤʤ
* @see #getRowSum(int row)
* @see #getColSumArray()
*/
	public double getColSum(int col){
		if (isColNumber(col)){
			double val = 0.0;
			for (int i = 0; i < getRowLength(); i++){
				val = getCell(i, col) + val;
			}
			return val;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* Τ줾ιפ֤ޤ
* @return ιͤä
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public double[] getColSumArray(){
		double[] returnArray = new double[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColSum(i);
		}
		return returnArray;
	}
	
/**
* ꤷԤˤͤʿѤ֤ޤ
* @param row ֹ
* @return ꤷԤʿ
* @exception NotElementException ꤷԤ¸ߤʤ
* @see #getColAverage(int col)
* @see #getRowAverageArray()
*/
	public double getRowAverage(int row){
		if (isRowNumber(row)){
			double val;
			val = getRowSum(row) / getColLength();
			return val;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* ƹԤΤ줾ʿѤ֤ޤ
* @return ƹԤʿͤä
* @see #getColAverageArray()
* @see #getRowAverage(int row)
*/
	public double[] getRowAverageArray(){
		double[] returnArray = new double[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowAverage(i);
		}
		return returnArray;
	}
	
/**
* ꤷˤͤʿѤ֤ޤ
* @param col ֹ
* @return ꤷʿ
* @exception NotElementException ꤵ줿¸ߤʤ
* @see #getRowAverage(int row)
* @see #getColAverageArray()
*/
	public double getColAverage(int col){
		if (isColNumber(col)){
			double val;
			val = getColSum(col) / getRowLength();
			return val;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* Τ줾ʿѤ֤ޤ
* @return ʿͤä
* @see #getRowAverageArray()
* @see #getColAverage(int col)
*/
	public double[] getColAverageArray(){
		double[] returnArray = new double[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColAverage(i);
		}
		return returnArray;
	}
	
/**
* ޥȥꥯǤˤ֤ͤͤޤ
* @return ˤ
*/
	public double getMaxCell(){
		double maxValue;
		maxValue = getCell(0,0);		//
		for (int i = 0; i < getRowLength(); i++){		//ͤĴ٤
			for (int j = 0; j < getColLength(); j++){
				if (maxValue < getCell(i,j)){
					maxValue = getCell(i, j);
				}
			}
		}
		return maxValue;
	}
	
/**
* ꤷԤι֤̾ޤ
* @param  row 
* @return Ԥι̾
* @exception NotElementException ꤵ줿Ԥ¸ߤʤ
* @see #getColName(int col)
* @see #getRowNameArray()
*/
	public String getRowName(int row){
		if (isRowNumber(row)){
			return matrixRowName[row];
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* ޥȥꥯˤƤι֤̾ޤ
* @return ̾ä
* @see #getColNameArray()
* @see #getRowName(int row)
*/
	public String[] getRowNameArray(){
		String[] returnArray = new String[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowName(i);
		}
		return returnArray;
	}
	
/**
* ꤷι֤̾ޤ
* @param  col 
* @return Ԥ̾
* @exception NotElementException ꤵ줿¸ߤʤ
* @see #getRowName(int row)
* @see #getColNameArray()
*/
	public String getColName(int col){
		if (isColNumber(col)){
			return matrixColName[col];
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* ޥȥꥯˤƤ֤̾ޤ
* @return ̾ä
* @see #getRowNameArray()
* @see #getColName(int col)
*/
	public String[] getColNameArray(){
		String[] returnArray = new String[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColName(i);
		}
		return returnArray;
	}
	
/**
* ꤷ̾ιֹ֤ޤ
* @param rowName ̾
* @return Ԥιֹ
* @exception NotElementException ꤵ줿̾¸ߤʤ
* @see #getColNumber(String colName)
*/
	public int getRowNumber(String rowName){
		for (int i = 0; i < getRowLength(); i++){
			if (rowName.equals(matrixRowName[i])){
				return i;
			}
		}
		
		//¸ߤʤ
		throw new NotElementException("rowName(" + rowName + ")");
	}
	
/**
* ꤷֹ֤̾ޤ
* @param colName ̾
* @return Ԥֹ
* @exception NotElementException ꤷ̾¸ߤʤ
* @see #getRowNumber(String rowName)
*/
	public int getColNumber(String colName){
		for (int i = 0; i < getColLength(); i++){
			if (colName.equals(matrixColName[i])){
				return i;
			}
		}
		
		//¸ߤʤ
		throw new NotElementException("colName(" + colName + ")");
	}
	
/**
* ޥȥꥯ¸ߤǤΤǤ0ĶǤο֤ޤ
* @return ǿ
*/
	public int getElement(){
		int element = 0;
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) > 0){		//0Ķǿ
					element = element + 1;
				}
			}
		}
		return element;
	}
	
/**
* ޥȥꥯ˻ꤷǤ¸ߤ뤫åޤ
* @param row ֹ
* @param col ֹ
* @return Υޥȥꥯ˻ꤷǤ¸ߤtrue¸ߤʤfalse֤ޤ
*/
	public boolean isMatrixEntityPoint(int row,int col){
		return ((0 <= row && row < this.getRowLength()) &&
			(0 <= col && col < this.getColLength()));
	}

/**
* ޥȥꥯ˻ꤷֹ椬¸ߤ뤫åޤ
* @param row ֹ
* @return Υޥȥꥯ˻ꤷֹ椬¸ߤtrue¸ߤʤfalse֤ޤ
*/
	public boolean isRowNumber(int row){
		return ((0 <= row) && (row < this.getRowLength()));
	}
	
/**
* ޥȥꥯ˻ꤷֹ椬¸ߤ뤫åޤ
* @param col ֹ
* @return Υޥȥꥯ˻ꤷֹ椬¸ߤtrue¸ߤʤfalse֤ޤ
*/
	public boolean isColNumber(int col){
		return ((0 <= col) && (col < this.getColLength()));
	}
	
/**
* 2Ǥ礭ѹޤ
* @param rowSize ԥ
* @param colSize 󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	private void setSizeMatrix(int rowSize, int colSize){
		
		//ǤϤʤ
		if((rowSize >= 0) && ( colSize >= 0)){
			matrix = new double[rowSize][colSize];		//ǡ¸Ѥ2
			matrixRowSize = rowSize;		//ԥ
			matrixColSize = colSize;		//󥵥
			matrixRowName = new String[matrixRowSize];		//̾
			matrixColName = new String[matrixColSize];		//̾
		}
		else{
			throw new NegativeMatrixSizeException();
		}
	}
	
/**
* ̾˹ֹ̾Ȥꤷޤ<BR>
* ֹ0Ϥޤ뤿ᡢ0˹ֹ̾椬ƱֹȤʤޤ 
* @see #setColNameNumber()
* @see #setRowNameNumber(int start)
*/
	public void setRowNameNumber(){
		for (int i = 0; i < getRowLength(); i++){
			setRowName(i, i +"");
		}
	}
	
/**
* ̾startϤޤֹ̾Ȥꤷޤ
* @param start ǽιֹ̾
* @see #setColNameNumber(int start)
* @see #setRowNameNumber()
*/
	public void setRowNameNumber(int start){
		for (int i = 0; i < getRowLength(); i++){
			setRowName(i, i + start +"");
		}
	}
	
/**
* ֹ̾̾Ȥꤷޤ<BR>
* ֹ0Ϥޤ뤿ᡢ0ֹ̾椬ƱֹȤʤޤ 
* @see #setRowNameNumber()
* @see #setColNameNumber(int start)
*/
	public void setColNameNumber(){
		for (int i = 0; i < getColLength(); i++){
			setColName(i, i +"");
		}
	}
	
/**
* ̾startϤޤֹ̾Ȥꤷޤ
* @param start ǽֹ̾
* @see #setRowNameNumber(int start)
* @see #setColNameNumber()
*/
	public void setColNameNumber(int start){
		for (int i = 0; i < getColLength(); i++){
			setColName(i, i + start +"");
		}
	}
	

	
	
/**
* ޥȥꥯǤ012ͤѴޤ
* 0ʲο0ˡ0ۤ1Ѵޤ
*/
	public void convertLogicMatrix(){
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) <= 0){
					setCell(i, j, MATRIX_VALUE_FALSE);
				}
				else{
					setCell(i, j, MATRIX_VALUE_TRUE);
				}
			}
		}
	}
	
/**
* 2ĤΥޥȥꥯΥƱåޤ
* @param compareMatrix Ĵ٤ޥȥꥯ
* @return ƱǤTrue򡢰㤦False֤ޤ
*/
	public boolean isSameMatrixSize(Matrix compareMatrix){
		return getRowLength() == compareMatrix.getRowLength()
			&& getColLength() == compareMatrix.getColLength();
	}
	
/**
* 2ĤΥޥȥꥯΥ軻ԤȤǤ뤫åޤ
* @param compareMatrix Ĵ٤ޥȥꥯ
* @return ƱǤTrue򡢰㤦False֤ޤ
*/
	private boolean isMultiplyMatrixSize(Matrix compareMatrix){
		return getColLength() == compareMatrix.getRowLength();
	}
	
/**
* Υޥȥꥯ󤫥åޤ
* @return ʤTrue򡢰㤦False֤ޤ
*/
	public boolean isSquare(){
		return getRowLength() == getColLength();
	}
	
/**
* ¾ΥޥȥꥯȤ(And)֤ޤ<BR>
* α黻˹ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #convertLogicMatrix()
* @see #getOrMatrix(Matrix calculateMatrix)
* @see #getXOrMatrix(Matrix calculateMatrix)
* @see #getNotMatrix()
*/
	public Matrix getAndMatrix(Matrix calculateMatrix){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤѤ
					returnMatrix.setCell(i, j, (int) getCell(i,j) &
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ¾ΥޥȥꥯȤ(OR)֤ޤ<BR>
* α黻˹ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #convertLogicMatrix()
* @see #getAndMatrix(Matrix calculateMatrix)
* @see #getXOrMatrix(Matrix calculateMatrix)
* @see #getNotMatrix()
*/
	public Matrix getOrMatrix(Matrix calculateMatrix){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤ¤
					returnMatrix.setCell(i, j, (int) getCell(i,j) |
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ¾ΥޥȥꥯȤ¾Ū(eXclusive OR)֤ޤ<BR>
* α黻˹ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #convertLogicMatrix()
* @see #getAndMatrix(Matrix calculateMatrix)
* @see #getOrMatrix(Matrix calculateMatrix)
* @see #getNotMatrix()
*/
	public Matrix getXOrMatrix(Matrix calculateMatrix){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫ɤ
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤ¾Ū¤
					returnMatrix.setCell(i, j, (int) getCell(i,j) ^
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯ(NOT)֤ޤ<BR>
* α黻ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @return 黻̤Υޥȥꥯ
* @see #convertLogicMatrix()
* @see #getAndMatrix(Matrix calculateMatrix)
* @see #getOrMatrix(Matrix calculateMatrix)
* @see #getXOrMatrix(Matrix calculateMatrix)
*/
	public Matrix getNotMatrix(){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//ͤΥޥȥꥯѴ
		convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//α黻Ԥ
					if (getCell(i,j) > 0){
						returnMatrix.setCell(i, j, 0);
					}
					else{
						returnMatrix.setCell(i, j, 1);
					}
				}
			}
		return returnMatrix;
	}
	
/**
* ޥȥꥯƱΤѤ֤ޤ<BR>
* ֤ޥȥꥯΥϱ黻Υޥȥꥯιԥ߱黻оݤΥޥȥꥯ󥵥Ȥʤޤ
* @param calculateMatrix 軻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥ黻Ԥʤξ
*/
	public Matrix getMultiplyMatrix(Matrix calculateMatrix){
		Matrix returnMatrix = new Matrix(getRowLength(), calculateMatrix.getColLength(),
			getRowNameArray(), calculateMatrix.getColNameArray());
		
		//黻Ԥ뤫ɤ
		if (isMultiplyMatrixSize(calculateMatrix)){
			for (int i = 0; i < returnMatrix.getRowLength(); i++){
				for (int j = 0; j < returnMatrix.getColLength(); j++){
					
					//ξ軻Ԥ
					//׻ a_i1 * a_1j + a_i2 * a_2j +  + a_in * a_nj
					double value = 0.0;
					for (int k = 0; k < getColLength(); k++){
							value = getCell(i, k) * calculateMatrix.getCell(k, j) + value;
					}
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
			return returnMatrix;
	}
	
/**
* exponetؿȤ٤׻ޥȥꥯ֤ޤ
* @param exponent ߾λؿ
* @return n򤷤ޥȥꥯ
* @exception SetValueOutOfBoundsException ؿ0ʲͤꤷ
* @exception NotSquareMatrixException ޥȥꥯǤʤ
*/
	public Matrix getExponentMatrix(int exponent){
		Matrix initMatrix = new Matrix(matrix, getRowNameArray(), getColNameArray());
		Matrix returnMatrix = new Matrix(matrix, getRowNameArray(), getColNameArray());
		
		//󤫤ɤޤؿ0ʲͤꤵ줿
		if (isSquare()){
			if (exponent > 0){
			
				//Υޥȥꥯn軻(1ξϸΥޥȥꥯΤޤ)
				for (int i = 1; i < exponent; i++){
				
					//i褷ޥȥꥯ˸Υޥȥꥯݤi+1ˤ
					returnMatrix.MatrixCopy(returnMatrix.getMultiplyMatrix(initMatrix));
				}
			}
			
			//ؿ0ʲͤꤵ줿
			else{
				throw new SetValueOutOfBoundsException("exponent(" + exponent + ")");
			}
		}
		
		//ޥȥꥯǤʤ
		else{
			throw new NotSquareMatrixException();
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯǤñ̹ˤޤ
* @exception NotSquareMatrixException ޥȥꥯǤʤ
*/
	public void createElementaryMatrix(){
		if (isSquare()){
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//гʬΤ1
					if (i == j){
						setCell(i, j, MATRIX_VALUE_TRUE);
					}
					else{
						setCell(i, j, MATRIX_VALUE_FALSE);
					}
				}
			}
		}
		
		//ޥȥꥯǤʤ
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ΥޥȥꥯƱñ̹ޤ
* @return ñ̹
*/
	private Matrix getElementaryMatrix(){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		returnMatrix.createElementaryMatrix();
		return returnMatrix;
	}
	
/**
* ޥȥꥯܥޥȥꥯȤβãޥȥꥯ֤ޤ<BR>
* α黻˹ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @return ãޥȥꥯ
* @exception NotSquareMatrixException ޥȥꥯǤϤʤ
* @see #convertLogicMatrix()
*/
	public Matrix getReachMatrix(){
		
		//󤫤ɤ
		if (isSquare()){
		//ΥޥȥꥯܥޥȥꥯȤ
		Matrix returnMatrix = new Matrix(matrix, getRowNameArray(), getColNameArray());
		
		//ͤΥޥȥꥯѴ
		returnMatrix.convertLogicMatrix();
		
		//ñ̹Ȥ¤
		returnMatrix.MatrixCopy(returnMatrix.getOrMatrix(getElementaryMatrix()));
		
		//n-1褹
		// (I + A)n-1 Iñ̹ +
		returnMatrix.MatrixCopy(returnMatrix.getExponentMatrix(getRowLength() - 1));
		
		//ͤΥޥȥꥯѴ
		returnMatrix.convertLogicMatrix();
		return returnMatrix;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
	
//ʲƥѥ᥽å
/*
/**
* ޥȥꥯintɸϤ˽Ϥޤ

	public void outputIntMatrix(){
		System.out.print("       ");
		for (int j = 0; j < getColLength(); j++){		//̾
			System.out.print(getColName(j) + " ");
		}
		System.out.println();
		for (int i = 0 ; i < getRowLength(); i++){
			if (i < 9){
			System.out.print(getRowName(i) + " ");		//̾
			}
			else{
				System.out.print(getRowName(i) + " ");
			}
			for (int j = 0; j < getColLength(); j++){		//ǽ
				if (j == (getColLength() - 1)){
					System.out.println("     "+(int)getCell(i, j));
				}
				else{
					System.out.print("     "+(int)getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* ޥȥꥯdoubleɸϤ˽Ϥޤ

	public void outputDoubleMatrix(){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.000");		//ʲ3ޤǽ
		System.out.print("       ");
		for (int j = 0; j < getColLength(); j++){
			System.out.print(getColName(j) + " ");		//̾
		}
		System.out.println();
		for (int i = 0 ; i < getRowLength(); i++){
			System.out.print(getRowName(i) + "  ");		//̾
			for (int j = 0; j < getColLength(); j++){		//ǽ
				if (j == (getColLength() - 1)){
					System.out.println(df.format(getCell(i, j)));
				}
				else{
					System.out.print(df.format(getCell(i, j) )+" ");
				}
			}
		}
		System.out.println();
	}
	*/
	
}