package jp.ac.takushoku_u.cs;

/**
* LFTAnalysisNXLFT͂s߂̃NXłB
* @version 1.0
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N1006
*/
public class LFTAnalysis{
	
/**
* ҂̃}gNXێ}gNXB
*/
	private Matrix teacherMatrix;
	
/**
* wK҂̃}gNXێ}gNXB
*/
	private Matrix studentMatrix;
	
/**
* ҂̉B}gNXێ}gNXB
*/
	private Matrix reachTeacherMatrix;
	
/**
* wK҂̉B}gNXێ}gNXB
*/
	private Matrix reachStudentMatrix;
	
/**
* ҂̃}gNXɂe}̏dvxێ}gNXB
*/
	private Matrix edgeTeacherMatrix;
	
/**
* wK҂̃}gNXɂe}̏dvxێ}gNXB
*/
	private Matrix edgeStudentMatrix;
	
/**
* ގxێϐB
*/
	private double resemble;
	
/**
* BxێϐB
*/
	private double attainment;
	
/**
* ҂ƊwK҂̃}gNXꏏɂ}gNXB
*/
	private Matrix mixMatrix;
	
/**
* L}ꍇ\萔B
*/
	private static final int LFT_BRANCH_TRUE = 1;
	
/**
* L}Ȃꍇ\萔B
*/
	private static final int LFT_BRANCH_FALSE = 0;
	
/**
* ꏏɂ}gNXŋ҂̃}gNXɂ̂ݎ}ꍇ\萔B
*/
	private static final int LFT_BRANCH_TEACHER = 3;
	
/**
* ꏏɂ}gNXŊwK҂̃}gNXɂ̂ݎ}ꍇ\萔B
*/
	private static final int LFT_BRANCH_STUDENT = 4;
	
/**
* }gNXTCỸftHglB
*/
	private static final int LFT_MATRIX_VALUE = 5;
	
/**
* ݒ肳ĂftHg̃TCYŕ͂s}gNXݒ肵A͂s܂B<BR>
* ҂ƊwKҗ̃}gNX̗vf͑S0ƂȂ܂B
*/
	public LFTAnalysis(){
		Matrix baseTeacherMatrix = new Matrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		Matrix baseStudentMatrix = new Matrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		
		//҂̃}gNXݒ肵܂
		setTeacherMatrix(baseTeacherMatrix);
		
		//wK҂̃}gNXݒ肵A͂s
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ҂̃}gNXݒ肵A͂s܂B<BR>
* wK҂̃}gNX͋҂̃}gNXTCYƓŁAvf͑S0ƂȂ܂B<BR>
* ҂̃}gNX͐słKv܂B
* @param baseTeacherMatrix ҂̃}gNX
* @exception NotSquareMatrixException ҂̃}gNXsł͂Ȃꍇ
*/
	public LFTAnalysis(Matrix baseTeacherMatrix){
		Matrix baseStudentMatrix =
		new Matrix(baseTeacherMatrix.getRowLength(), baseTeacherMatrix.getColLength(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
			
		//҂̃}gNXݒ肵܂
		setTeacherMatrix(baseTeacherMatrix);
			
		//wK҂̃}gNXݒ肵A͂s
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNXݒ肵A͂s܂B<BR>
* ҂̃}gNXƊwK҂̃}gNXTCYvA҂ƂsłKv܂B
* @param baseTeacherMatrix ҂̃}gNX
* @param baseStudentMatrix wK҂̃}gNX
* @exception NotSquareMatrixException ҂܂͊wK҂̃}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException ҂̃}gNXƊwK҂̃}gNXTCYvȂꍇ
*/
	public LFTAnalysis(Matrix baseTeacherMatrix, Matrix baseStudentMatrix){
		
		//҂̃}gNXݒ肵܂
		setTeacherMatrix(baseTeacherMatrix);
			
		//wK҂̃}gNXݒ肵A͂s
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* LFT͂s܂B
*/
	private void Analysis(){
		calculateResemble();	//ގx߂
		calculateAttainment();	//Bx߂
		
		//҂̃}gNXƊwK҂̃}gNXꏏɂ}gNX߂
		setAgreementMatrix(calculateAgreementMatrix(teacherMatrix, studentMatrix));
	}
	
/**
* ގx߂܂B
*/
	private void calculateResemble(){
		double denominator = 0.0; //(OR)
		double numerator = 0.0; //q(AND)
		
		//vf΂߂}gNX
		Matrix pairTeacherMatrix = new Matrix(getElement(), getElement());
		Matrix pairStudentMatrix = new Matrix(getElement(), getElement());
		
		//vZߒŎgp}gNX
		Matrix resultMatrix = new Matrix(getElement(), getElement());
		for (int i = 0; i < getElement(); i++){
			for (int j = 0; j < getElement(); j++){
				
				//҂̃}gNXł2vfԂɎ}΂̗vfԂ̗vfΏW߂
				if (teacherMatrix.getCell(i, j) > 0){
				pairTeacherMatrix.MatrixCopy(getPairMatrix(reachTeacherMatrix, i, j));
				}
				
				//}ȂΗvfΏW͋W
				else{
					pairTeacherMatrix.clearMatrix();
				}
				
				//wK҂̃}gNXł2vfԂɎ}΂̗vfԂ̗vfΏW߂
				if (studentMatrix.getCell(i, j) > 0){
				pairStudentMatrix.MatrixCopy(getPairMatrix(reachStudentMatrix, i, j));
				}
				
				//}ȂΗvfΏW͋W
				else{
					pairStudentMatrix.clearMatrix();
				}
				
				//̌vZ
				resultMatrix.MatrixCopy(pairTeacherMatrix.getOrMatrix(pairStudentMatrix));
				denominator = resultMatrix.getElement() + denominator;
				
				//q̌vZ
				resultMatrix.MatrixCopy(pairTeacherMatrix.getAndMatrix(pairStudentMatrix));
				numerator = resultMatrix.getElement() + numerator;
			}
		}
		
		setResemble(numerator / denominator);
	}
	
/**
* Bx߂܂B
*/
	private void calculateAttainment(){
		setAttainment(Math.sqrt(getResemble()) * 100);
	}

/**
* ҂̃}gNXƊwK҂̃}gNXꏏɂ}gNX߂܂B<BR>
* ǂ}0Aǂ}1A҂̃}gNX݂̂Ɏ}ꍇ3A
* wK҂̃}gNX݂̂Ɏ}ꍇ4܂B
* ̃}gNX̍sƗ񖼂͋҂̃}gNXƓɂȂ܂B
* @param baseTeacherMatrix ҂̃}gNX
* @param baseStudentMatrix wK҂̃}gNX
* @return ꏏɂ}gNX
*/
	private Matrix calculateAgreementMatrix(Matrix baseTeacherMatrix, Matrix baseStudentMatrix){
		Matrix returnMatrix = new Matrix(getElement(), getElement(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
		
		for (int i = 0; i < getElement(); i++){
			for (int j = 0; j < getElement(); j++){
				if (baseTeacherMatrix.getCell(i,j) == baseStudentMatrix.getCell(i,j)){
					returnMatrix.setCell(i,j,baseTeacherMatrix.getCell(i,j));
				}
				else if (baseTeacherMatrix.getCell(i,j) == LFT_BRANCH_TRUE &&
					baseStudentMatrix.getCell(i,j) == LFT_BRANCH_FALSE){
					returnMatrix.setCell(i,j,LFT_BRANCH_TEACHER);
				}
				else{
					returnMatrix.setCell(i,j,LFT_BRANCH_STUDENT);
				}
			}
		}
		return returnMatrix;
	}
	
/**
* אڃ}gNXɂvfԂ̗vfΏW߂܂B
* @param nextMatrix ׂאڃ}gNX
* @param startI L}̎n_
* @param goalJ L}̐̏I_
* @return ǂ̗vfԂvf΂}gNX
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	public Matrix getElementPairMatrix(Matrix nextMatrix, int startI, int goalJ){
		if (nextMatrix.isMatrixEntityPoint(startI, goalJ)){
			
			//B}gNX𐶐
			Matrix lookMatrix = new Matrix(nextMatrix.getRowLength(), nextMatrix.getColLength(),
				nextMatrix.getRowNameArray(), nextMatrix.getColNameArray());
			lookMatrix.MatrixCopy(nextMatrix.getReachMatrix());
			lookMatrix.convertLogicMatrix();
			
			Matrix returnMatrix = new Matrix(lookMatrix.getRowLength(), lookMatrix.getColLength(), 
				lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
			
			//}݂邩ǂ
			if (nextMatrix.getCell(startI, goalJ) > 0){
				returnMatrix.MatrixCopy(getPairMatrix(lookMatrix, startI, goalJ));
			}
			return returnMatrix;
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* B}gNXɂvfԂ̗vfΏW߂܂B<BR>
* אڃ}gNX狁߂̂ɔׁA2vfԂאڂĂ邩ۏ؂Ȃ߁A
* ̃\bhgpꍇ̗͂vfԓmאڂĂ邱Ƃ`FbNKv܂B
* @param lookMatrix ׂB}gNX
* @param startI L}̗̌vfԍ
* @param goalJ L}̗̐vfԍ
* @return ǂ̗vfԂvf΂}gNX
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	private Matrix getPairMatrix(Matrix lookMatrix, int startI, int goalJ){
		if (lookMatrix.isMatrixEntityPoint(startI, goalJ)){
			lookMatrix.convertLogicMatrix();
			Matrix returnMatrix = new Matrix(lookMatrix.getRowLength(),lookMatrix.getColLength(), 
				lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
			for (int i = 0; i < lookMatrix.getRowLength(); i++){
				for (int j = 0; j < lookMatrix.getColLength(); j++){
					if (lookMatrix.getCell(i, startI) * lookMatrix.getCell(goalJ, j) > 0){
						returnMatrix.setCell(i, j, LFT_BRANCH_TRUE);
					}
					else{
						returnMatrix.setCell(i, j, LFT_BRANCH_FALSE);
					}
				}
			}
			return returnMatrix;
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* }gNXɑ݂}̏dvx߂܂B
* @param _matrix dvx߂Ώۂ̗אڃ}gNX
* @return }̏dvxi[}gNX
*/
	
	private Matrix getImportantEdgeMatrix(Matrix _matrix){
		Matrix returnMatrix = new Matrix(_matrix.getRowLength(), _matrix.getColLength(),
			_matrix.getRowNameArray(), _matrix.getColNameArray());
		Matrix temporaryMatrix = new Matrix(_matrix.getRowLength(), _matrix.getColLength());
		double cont = Math.floor(getElement() / 2) * Math.floor((getElement() + 1) / 2);
		
		for (int i = 0;i < _matrix.getRowLength(); i++){
			for (int j = 0; j < _matrix.getColLength(); j++){
				double value = 0.0;
				
				//}݂邩ǂ
				if (_matrix.getCell(i, j) > 0){
					temporaryMatrix.MatrixCopy(getElementPairMatrix(_matrix, i, j));
					value = temporaryMatrix.getElement();
					value = value / cont;
				}
				returnMatrix.setCell(i, j, value);
			}
		}
		return returnMatrix;
	}
	
	
/**
* ҂̃}gNXԂ܂B
* @return ҂̃}gNX
* @see #getStudentMatrix()
*/
	public Matrix getTeacherMatrix(){
		return teacherMatrix;
	}
	
/**
* wK҂̃}gNXԂ܂B
* @return wK҂̃}gNX
* @see #getTeacherMatrix()
*/
	public Matrix getStudentMatrix(){
		return studentMatrix;
	}
	
/**
* 2_Ԃɂ鋳҂ƊwK҂̎}̏ԂԂ܂B
* ǂ}0Aǂ}1A҂̃}gNX݂̂Ɏ}ꍇ3A
* wK҂̃}gNX݂̂Ɏ}ꍇ4܂B
* @param startI L}̎n_
* @param goalJ L}̏I_
* @return }̏
* @exception NotElementException w肵vfԍ݂Ȃꍇ
* @see #getAgreementMatrix()
*/
	public int getAgreementEdge(int startI, int goalJ){
		if (mixMatrix.isMatrixEntityPoint(startI, goalJ)){
			return (int) mixMatrix.getCell(startI, goalJ);
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNXꏏɂ}gNXԂ܂B
* ǂ}0Aǂ}1A҂̃}gNX݂̂Ɏ}ꍇ3A
* wK҂̃}gNX݂̂Ɏ}ꍇ4܂B
* ̃}gNX̍sƗ񖼂͋҂̃}gNXƓɂȂ܂B
* @return ꏏɂ}gNX
* @see #getAgreementEdge(int startI, int goalJ)
*/
	public Matrix getAgreementMatrix(){
		return mixMatrix;
	}
	
/**
* ҂̉B}gNXԂ܂B
* @return ҂̉B}gNX
* @see #getReachStudentMatrix()
*/
	public Matrix getReachTeacherMatrix(){
		return reachTeacherMatrix;
	}
	
/**
* wK҂̉B}gNXԂ܂B
* @return wK҂̉B}gNX
* @see #getReachTeacherMatrix()
*/
	public Matrix getReachStudentMatrix(){
		return reachStudentMatrix;
	}
	
/**
* ҂̃}gNXɂw肵}̏dvxԂ܂B
* @param startI L}̎n_
* @param goalJ L}̏I_
* @return dvx
* @exception NotElementException w肵vfԍ݂Ȃꍇ
* @see #getImportanceEdgeStudent(int startI, int goalJ)
* @see #getEdgeTeacherMatrix()
*/
	public double getImportanceEdgeTeacher(int startI, int goalJ){
		if (edgeTeacherMatrix.isMatrixEntityPoint(startI, goalJ)){
			return edgeTeacherMatrix.getCell(startI, goalJ);
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* ҂̎}̏dvx߂}gNXԂ܂B
* @return dvx߂}gNX
* @see #getEdgeStudentMatrix()
* @see #getImportanceEdgeTeacher(int startI, int goalJ)
*/
	public Matrix getEdgeTeacherMatrix(){
		return edgeTeacherMatrix;
	}
	
/**
* wK҂̃}gNXɂw肵}̏dvxԂ܂B
* @param startI L}̎n_
* @param goalJ L}̏I_
* @return dvx
* @exception NotElementException w肵vfԍ݂Ȃꍇ
* @see #getEdgeTeacherMatrix()
* @see #getImportanceEdgeStudent(int startI, int goalJ)
*/
	public double getImportanceEdgeStudent(int startI, int goalJ){
		if (edgeStudentMatrix.isMatrixEntityPoint(startI, goalJ)){
			return edgeStudentMatrix.getCell(startI, goalJ);
		}
		else{
			throw new NotElementException("point(" + startI + "," + goalJ + ")");
		}
	}
	
/**
* wK҂̎}̏dvx߂}gNXԂ܂B
* @return dvx߂}gNX
* @see #getEdgeStudentMatrix()
* @see #getImportanceEdgeTeacher(int startI, int goalJ)
*/
	public Matrix getEdgeStudentMatrix(){
		return edgeStudentMatrix;
	}
	
/**
* }gNXɂvf(s܂͗)Ԃ܂B
* @return vf
*/
	public int getElement(){
		return teacherMatrix.getRowLength();
	}
	
/**
* ҂̃}gNXɂL}̐Ԃ܂B
* @return ҂̃}gNXɂL}̐
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAgreementEdge()
*/
	public int getTeacherEdge(){
		return teacherMatrix.getElement();
	}
	
/**
* wK҂̃}gNXɂL}̐Ԃ܂B
* @return wK҂̃}gNXɂL}̐
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAgreementEdge()
*/
	public int getStudentEdge(){
		return studentMatrix.getElement();
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNX̂ǂ炩ɂł݂L}̐Ԃ܂B
* @return ǂ炩ɂłL}̐
* @see #getAgreementEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
	public int getTotelEdge(){
		return mixMatrix.getElement();
	}
	
/**
* ҂̃}gNXɂ̂ݑ݂L}̐Ԃ܂B
* @return ҂̃}gNXɂ̂ݑ݂L}̐
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAgreementEdge()
*/
	public int getTeacherOnlyEdge(){
		int count = 0;
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_BRANCH_TEACHER){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* wK҂̃}gNXɂ̂ݑ݂L}̐Ԃ܂B
* @return wK҂̃}gNXɂ̂ݑ݂L}̐
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAgreementEdge()
*/
	public int getStudentOnlyEdge(){
		int count = 0;
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_BRANCH_STUDENT){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ҂̃}gNXɂwK҂̃}gNXɂ݂L}̐Ԃ܂B
* @return ҂ɂL}̐
* @see #getTotelEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
	public int getAgreementEdge(){
		int count = 0;
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_BRANCH_TRUE){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ގxԂ܂B
* @return ގx
*/
	public double getResemble(){
		return resemble;
	}
	
/**
* BxԂ܂B
* @return Bx
*/
	public double getAttainment(){
		return attainment;
	}
	
/**
* ҂̃}gNXݒ肵܂B<BR>
* ɋ҂̉B}gNXݒ肳܂B
* @param baseTeacherMatrix ݒ鋳҂̃}gNX
* @exception NotSquareMatrixException ҂̃}gNXsł͂Ȃꍇ
*/
	private void setTeacherMatrix(Matrix baseTeacherMatrix){
		if (baseTeacherMatrix.isSquare()){
			teacherMatrix = new Matrix();
			teacherMatrix.MatrixCopy(baseTeacherMatrix);
			teacherMatrix.convertLogicMatrix();
			reachTeacherMatrix = new Matrix();
			reachTeacherMatrix.MatrixCopy(teacherMatrix.getReachMatrix());
			reachTeacherMatrix.convertLogicMatrix();
			
			edgeTeacherMatrix = new Matrix();
			
			//҂̃Ot̎}̏dvx߂
			edgeTeacherMatrix.MatrixCopy(getImportantEdgeMatrix(teacherMatrix));
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* wK҂̃}gNXݒ肵A͂s܂B<BR>
* ɊwK҂̉B}gNXݒ肳܂B
* @param baseStudentMatrix ݒwK҂̃}gNX
* @exception NotSquareMatrixException wK҂̃}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException ҂̃}gNXƊwK҂̃}gNXTCYvȂꍇ
*/
	public void setStudentMatrix(Matrix baseStudentMatrix){
		if (baseStudentMatrix.isSquare()){
			if (teacherMatrix.isSameMatrixSize(baseStudentMatrix)){
				studentMatrix = new Matrix();
				studentMatrix.MatrixCopy(baseStudentMatrix);
				studentMatrix.convertLogicMatrix();
				reachStudentMatrix = new Matrix();
				reachStudentMatrix.MatrixCopy(studentMatrix.getReachMatrix());
				reachStudentMatrix.convertLogicMatrix();
				edgeStudentMatrix = new Matrix();
				
				//wK҂̃Ot̎}̏dvx߂
				edgeStudentMatrix.MatrixCopy(getImportantEdgeMatrix(studentMatrix));
				
				//͂s
				Analysis();
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ҂ƊwK҂̃}gNXꏏɂ}gNXݒ肵܂B
* @param baseMatrix ݒꏏɂ}gNX
*/
	private void setAgreementMatrix(Matrix baseMatrix){
		mixMatrix = new Matrix();
		mixMatrix.MatrixCopy(baseMatrix);
	}
	
/**
* ގxݒ肵܂B
* @param baseResemble ގx
*/
	private void setResemble(double baseResemble){
		resemble = baseResemble;
	}
	
/**
* Bxݒ肵܂B
* @param baseAttainment Bx
*/
	private void setAttainment(double baseAttainment){
		attainment = baseAttainment;
	}
	
}