package jp.ac.takushoku_u.cs;

/**
* MatrixNXł̓}gNX܂B<BR>
* }gNX̓̕f[^sƗ񖼂tĕێł悤ɂȂ܂B
* ܂}gNXm̉ZsƂł܂B<BR>
* @version 1.1
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N0928
*/
public class Matrix{

/**
* s̃TCYێϐB
*/
    private int matrixRowSize;
	
/**
* ̃TCYێϐB
*/
	private int matrixColSize;
	
/**
* }gNX̊evf̃f[^i[2zB
*/
    private double[ ][ ] matrix;
	
/**
* si[zB
*/
	private String[ ] matrixRowName;
	
/**
* 񖼊i[zB
*/
	private String[ ] matrixColName;
	
/**
* }gNXNAƂ̒lB
*/
	private static final double MATRIX_CLEAR_VALUE = 0.0;
	
/**
* 2z̍sTCỸftHglB
*/
	private static final int MATRIX_INIT_ROW_SIZE = 5;
	
/**
* 2z̗TCỸftHglB
*/
	private static final int MATRIX_INIT_COL_SIZE = 5;
	
/**
* False鎞̘_lB
*/
	private static final double MATRIX_VALUE_FALSE = 0.0;
	
/**
* True鎞̘_lB
*/
	private static final double MATRIX_VALUE_TRUE = 1.0;


/**
* ݒ肳ĂTCỸf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑S0ŏ܂B
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
*/
	public Matrix(){
		setSizeMatrix(MATRIX_INIT_ROW_SIZE,MATRIX_INIT_COL_SIZE);
		clearMatrix();
		setRowNameNumber();
		setColNameNumber();
	}

/**
* w肳ꂽsTCYƗTCYɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑S0ŏ܂B
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public Matrix(int rowSize, int colSize){
		setSizeMatrix(rowSize,colSize);
		clearMatrix();
		setRowNameNumber();
		setColNameNumber();
	}
	
/**
* w肳ꂽsTCYƗTCYɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* ꂽ2z͑S0ŏ܂B
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param nameNumber sї񖼂̊Jnԍ
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public Matrix(int rowSize, int colSize, int nameNumber){
		setSizeMatrix(rowSize,colSize);
		clearMatrix();
		setRowNameNumber(nameNumber);
		setColNameNumber(nameNumber);
	}
	
/**
* w肳ꂽsTCYATCYAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑S0ŏ܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param rowName w肷s
* @param colName w肷
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  rowName ܂ colName  null ̏ꍇ
*/
	public Matrix(int rowSize, int colSize, String[] rowName, String[] colName){
		setSizeMatrix(rowSize, colSize);
		clearMatrix();
		
		//sї񖼂̃Rs[
		System.arraycopy(rowName, 0, matrixRowName, 0, rowName.length);
		System.arraycopy(colName, 0, matrixColName, 0, colName.length);
	}
	
/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param originalMatrix w肷2z
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public Matrix(double[][] originalMatrix){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for (int i = 0; i < originalMatrix.length; i++){
			System.arraycopy(originalMatrix[i], 0, matrix[i], 0, originalMatrix[i].length);
		}
		setRowNameNumber();
		setColNameNumber();
	}

/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param originalMatrix w肷2z
* @param nameNumber sї񖼂̊Jnԍ
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public Matrix(double[][] originalMatrix, int nameNumber){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for(int i = 0; i < originalMatrix.length; i++){
			System.arraycopy(originalMatrix[i], 0, matrix[i], 0, originalMatrix[i].length);
		}
		setRowNameNumber(nameNumber);
		setColNameNumber(nameNumber);
	}

/**
* w肳ꂽ2zAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B
* @param originalMatrix w肷2z
* @param rowName w肷s
* @param colName w肷
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  rowName , colName ܂ originalMatrix  null ̏ꍇ
*/
	public Matrix(double[][] originalMatrix, String[] rowName, String[] colName){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for (int i = 0; i < originalMatrix.length; i++){
			System.arraycopy(originalMatrix[i], 0, matrix[i], 0, originalMatrix[i].length);
		}
		
		//sї񖼂̃Rs[
		System.arraycopy(rowName, 0, matrixRowName, 0, rowName.length);
		System.arraycopy(colName, 0, matrixColName, 0, colName.length);
	}


/**
* w肳ꂽ1_֒lݒ肵܂B
* @param row wsԍ
* @param col wԍ
* @param value ݒl
* @exception NotElementException w肵_݂Ȃꍇ
*/
	public void setCell(int row,int col,double value){
		if (isMatrixEntityPoint(row, col)){
			matrix[row][col] = value;
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}

/**
* }gNXɑ̃}gNX̗vfAsA񖼂̑SĂRs[܂B<BR>
* Rs[̃}gNXTCYƈvȂꍇ̓Rs[̃}gNXTCYɕύXARs[s܂B
* @param originalMatrix Rs[̃}gNX
* @see #MatrixElementCopy(Matrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void MatrixCopy(Matrix originalMatrix){
		
		//TCYmFAvȂꍇ̓TCYύX܂
		if ((getRowLength() != originalMatrix.getRowLength()) ||
			(getColLength() != originalMatrix.getColLength())){
				setSizeMatrix(originalMatrix.getRowLength(), originalMatrix.getColLength());
		}
		
		//Rs[܂
			for (int i = 0; i < getRowLength(); i++){
				setRowName(i, originalMatrix.getRowName(i));
				for (int j = 0; j < getColLength(); j++){
					if (i == 0){
						setColName(j, originalMatrix.getColName(j));
					}
					setCell(i, j, originalMatrix.getCell(i, j));
				}
			}
	}
	
/**
* wʒuŊJnwvfRs[̃}gNX̎wʒuɗvfRs[܂B<BR>
* Rs[̗vf( baseRow , baseCol )Ŏw肳ꂽvfJnʒuƂArowLength s colLength 񕪂
* vf( copyRow , copyCol )w肳vfn܂vfɃRs[s܂B
* Rs[͈̔͂ɓĂ͂܂ȂvfƍsA񖼂͕ύX܂B
* @param originalMatrix Rs[̃}gNX
* @param baseRow Rs[̃}gNXɑ΂Rs[̍sJnʒu
* @param baseCol Rs[̃}gNXɑ΂Rs[̗Jnʒu
* @param copyRow Rs[sJnʒu
* @param copyCol Rs[Jnʒu
* @param rowLength Rs[ss̗vf
* @param colLength Rs[s̗vf
* @exception SetValueOutOfBoundsException Rs[悪݂Ȃ͈͂ɂꍇ
* @see #MatrixCopy(Matrix originalMatrix)
*/
	public void MatrixElementCopy(Matrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
		
		//Rs[̃TCYmF܂
		if ((getRowLength() - copyRow >= rowLength) &&
			(getColLength() - copyCol >= colLength) &&
			(originalMatrix.getRowLength() >= (rowLength + baseRow)) &&
			(originalMatrix.getColLength() >= (colLength + baseCol))){
			for (int i = 0 + copyRow; i < copyRow + rowLength; i++){
				for (int j = 0 + copyCol; j < copyCol + colLength; j++){
					setCell(i, j, originalMatrix.getCell(i, j));
				}
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* }gNXɑ݂vfS0ɂ܂B
*/
	public void clearMatrix(){
		for (int i = 0 ; i < matrixRowSize ; i++){
			for (int j = 0 ; j < matrixColSize ; j++){
				setCell(i, j, MATRIX_CLEAR_VALUE);
			}
		}
	}
	
/**
* ws̍st܂B
* @param row wsԍ
* @param rowName s
* @exception NotElementException w肳ꂽs݂Ȃꍇ
* @see #setColName(int col,String colName)
*/
	public void setRowName(int row,String rowName){
		if (isRowNumber(row)){
			matrixRowName[row] = rowName;
		}
		else{
			throw new NotElementException("row("+ row + ")");
		}
	}
	
/**
* w̗񖼂t܂B
* @param col wԍ
* @param colName s
* @exception NotElementException w肳ꂽ񂪑݂Ȃꍇ
* @see #setRowName(int row,String rowName)
*/
	public void setColName(int col,String colName){
		if (isColNumber(col)){
			matrixColName[col] = colName;
		}
		else{
			throw new NotElementException("col("+ col+")");
		}
	}
	
	
/**
* w肳ꂽ1_̒lԂ܂B
* @param row wsԍ
* @param col wԍ
* @return w肵_̒l
* @exception NotElementException w肳ꂽ_݂Ȃꍇ
*/
	public double getCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			return matrix[row][col];
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* }gNX̍sTCYԂ܂B
* @return sTCY
* @see #getColLength()
*/
	public int getRowLength(){
		return matrixRowSize;
	}
	
/**
* }gNX̗TCYԂ܂B
* @return TCY
* @see #getRowLength()
*/
	public int getColLength(){
		return matrixColSize;
	}
	
/**
* w肵sɂl̍vԂ܂B
* @param row wsԍ
* @return w肵s̍vl
* @exception NotElementException w肵s݂Ȃꍇ
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public double getRowSum(int row){
		if (isRowNumber(row)){
			double val = 0.0;
			for (int i = 0; i < getColLength(); i++){
				val = getCell(row, i) + val;
			}
			return val;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* eŝꂼ̍vzŕԂ܂B
* @return es̍vlz
* @see #getColSumArray()
* @see #getRowSum(int row)
*/
	public double[] getRowSumArray(){
		double[] returnArray = new double[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowSum(i);
		}
		return returnArray;
	}
	
/**
* w肵ɂl̍vԂ܂B
* @param col wԍ
* @return w肵̍vl
* @exception NotElementException w肵񂪑݂Ȃꍇ
* @see #getRowSum(int row)
* @see #getColSumArray()
*/
	public double getColSum(int col){
		if (isColNumber(col)){
			double val = 0.0;
			for (int i = 0; i < getRowLength(); i++){
				val = getCell(i, col) + val;
			}
			return val;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* êꂼ̍vzŕԂ܂B
* @return e̍vlz
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public double[] getColSumArray(){
		double[] returnArray = new double[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColSum(i);
		}
		return returnArray;
	}
	
/**
* w肵sɂl̕ςԂ܂B
* @param row wsԍ
* @return w肵s̕ϒl
* @exception NotElementException w肵s݂Ȃꍇ
* @see #getColAverage(int col)
* @see #getRowAverageArray()
*/
	public double getRowAverage(int row){
		if (isRowNumber(row)){
			double val;
			val = getRowSum(row) / getColLength();
			return val;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* eŝꂼ̕ςzŕԂ܂B
* @return es̕ϒlz
* @see #getColAverageArray()
* @see #getRowAverage(int row)
*/
	public double[] getRowAverageArray(){
		double[] returnArray = new double[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowAverage(i);
		}
		return returnArray;
	}
	
/**
* w肵ɂl̕ςԂ܂B
* @param col wԍ
* @return w肵̕ϒl
* @exception NotElementException w肳ꂽ񂪑݂Ȃꍇ
* @see #getRowAverage(int row)
* @see #getColAverageArray()
*/
	public double getColAverage(int col){
		if (isColNumber(col)){
			double val;
			val = getColSum(col) / getRowLength();
			return val;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* êꂼ̕ςzŕԂ܂B
* @return e̕ϒlz
* @see #getRowAverageArray()
* @see #getColAverage(int col)
*/
	public double[] getColAverageArray(){
		double[] returnArray = new double[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColAverage(i);
		}
		return returnArray;
	}
	
/**
* }gNX̗vfɂlőlԂ܂B
* @return vfɂől
*/
	public double getMaxCell(){
		double maxValue;
		maxValue = getCell(0,0);		//l
		for (int i = 0; i < getRowLength(); i++){		//ől𒲂ׂ
			for (int j = 0; j < getColLength(); j++){
				if (maxValue < getCell(i,j)){
					maxValue = getCell(i, j);
				}
			}
		}
		return maxValue;
	}
	
/**
* w肵s̍sԂ܂B
* @param  row ws
* @return ws̍s
* @exception NotElementException w肳ꂽs݂Ȃꍇ
* @see #getColName(int col)
* @see #getRowNameArray()
*/
	public String getRowName(int row){
		if (isRowNumber(row)){
			return matrixRowName[row];
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* }gNXɂSĂ̍szŕԂ܂B
* @return s̓z
* @see #getColNameArray()
* @see #getRowName(int row)
*/
	public String[] getRowNameArray(){
		String[] returnArray = new String[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowName(i);
		}
		return returnArray;
	}
	
/**
* w肵̍sԂ܂B
* @param  col w
* @return ws̗
* @exception NotElementException w肳ꂽ񂪑݂Ȃꍇ
* @see #getRowName(int row)
* @see #getColNameArray()
*/
	public String getColName(int col){
		if (isColNumber(col)){
			return matrixColName[col];
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* }gNXɂSĂ̗񖼂zŕԂ܂B
* @return 񖼂̓z
* @see #getRowNameArray()
* @see #getColName(int col)
*/
	public String[] getColNameArray(){
		String[] returnArray = new String[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColName(i);
		}
		return returnArray;
	}
	
/**
* w肵s̍sԍԂ܂B
* @param rowName ws
* @return ws̍sԍ
* @exception NotElementException w肳ꂽs݂Ȃꍇ
* @see #getColNumber(String colName)
*/
	public int getRowNumber(String rowName){
		for (int i = 0; i < getRowLength(); i++){
			if (rowName.equals(matrixRowName[i])){
				return i;
			}
		}
		
		//݂Ȃꍇ
		throw new NotElementException("rowName(" + rowName + ")");
	}
	
/**
* w肵񖼂̗ԍԂ܂B
* @param colName w
* @return ws̗ԍ
* @exception NotElementException w肵񖼂݂Ȃꍇ
* @see #getRowNumber(String rowName)
*/
	public int getColNumber(String colName){
		for (int i = 0; i < getColLength(); i++){
			if (colName.equals(matrixColName[i])){
				return i;
			}
		}
		
		//݂Ȃꍇ
		throw new NotElementException("colName(" + colName + ")");
	}
	
/**
* }gNXɑ݂vf̂Avf0𒴂vf̐Ԃ܂B
* @return vf
*/
	public int getElement(){
		int element = 0;
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) > 0){		//0𒴂vf𐔂
					element = element + 1;
				}
			}
		}
		return element;
	}
	
/**
* }gNXɎw肵vf݂邩`FbN܂B
* @param row wsԍ
* @param col wԍ
* @return ̃}gNXɎw肵vf݂trueA݂ȂfalseԂ܂B
*/
	public boolean isMatrixEntityPoint(int row,int col){
		return ((0 <= row && row < this.getRowLength()) &&
			(0 <= col && col < this.getColLength()));
	}

/**
* }gNXɎw肵sԍ݂邩`FbN܂B
* @param row wsԍ
* @return ̃}gNXɎw肵sԍ݂trueA݂ȂfalseԂ܂B
*/
	public boolean isRowNumber(int row){
		return ((0 <= row) && (row < this.getRowLength()));
	}
	
/**
* }gNXɎw肵ԍ݂邩`FbN܂B
* @param col wԍ
* @return ̃}gNXɎw肵ԍ݂trueA݂ȂfalseԂ܂B
*/
	public boolean isColNumber(int col){
		return ((0 <= col) && (col < this.getColLength()));
	}
	
/**
* 2vf̑傫ύX܂B
* @param rowSize sTCY
* @param colSize TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	private void setSizeMatrix(int rowSize, int colSize){
		
		//TCY͕ł͂Ȃ
		if((rowSize >= 0) && ( colSize >= 0)){
			matrix = new double[rowSize][colSize];		//f[^ۑp2z̐
			matrixRowSize = rowSize;		//sTCY̐
			matrixColSize = colSize;		//TCY̐
			matrixRowName = new String[matrixRowSize];		//sz̐
			matrixColName = new String[matrixColSize];		//񖼔z̐
		}
		else{
			throw new NegativeMatrixSizeException();
		}
	}
	
/**
* szɍsԍsƂĐݒ肵܂B<BR>
* sԍ0n܂邽߁A0珇ɍssԍԍƂȂ܂B 
* @see #setColNameNumber()
* @see #setRowNameNumber(int start)
*/
	public void setRowNameNumber(){
		for (int i = 0; i < getRowLength(); i++){
			setRowName(i, i +"");
		}
	}
	
/**
* szstartn܂ԍsƂĐݒ肵܂B
* @param start ŏ̍sԍ
* @see #setColNameNumber(int start)
* @see #setRowNameNumber()
*/
	public void setRowNameNumber(int start){
		for (int i = 0; i < getRowLength(); i++){
			setRowName(i, i + start +"");
		}
	}
	
/**
* 񖼂zɗԍ񖼂ƂĐݒ肵܂B<BR>
* ԍ0n܂邽߁A0珇ɗ񖼂ԍԍƂȂ܂B 
* @see #setRowNameNumber()
* @see #setColNameNumber(int start)
*/
	public void setColNameNumber(){
		for (int i = 0; i < getColLength(); i++){
			setColName(i, i +"");
		}
	}
	
/**
* 񖼂zstartn܂ԍ񖼂ƂĐݒ肵܂B
* @param start ŏ̗񖼔ԍ
* @see #setRowNameNumber(int start)
* @see #setColNameNumber()
*/
	public void setColNameNumber(int start){
		for (int i = 0; i < getColLength(); i++){
			setColName(i, i + start +"");
		}
	}
	

	
	
/**
* }gNX̗vf012lɕϊ܂B
* 0ȉ̐0ɁA0z鐔1ɕϊ܂B
*/
	public void convertLogicMatrix(){
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) <= 0){
					setCell(i, j, MATRIX_VALUE_FALSE);
				}
				else{
					setCell(i, j, MATRIX_VALUE_TRUE);
				}
			}
		}
	}
	
/**
* 2̃}gNX̃TCY`FbN܂B
* @param compareMatrix ׂ}gNX
* @return TCYłTrueAႤꍇFalseԂ܂B
*/
	public boolean isSameMatrixSize(Matrix compareMatrix){
		return getRowLength() == compareMatrix.getRowLength()
			&& getColLength() == compareMatrix.getColLength();
	}
	
/**
* 2̃}gNX̃TCYZsƂł邩`FbN܂B
* @param compareMatrix ׂ}gNX
* @return TCYłTrueAႤꍇFalseԂ܂B
*/
	private boolean isMultiplyMatrixSize(Matrix compareMatrix){
		return getColLength() == compareMatrix.getRowLength();
	}
	
/**
* ̃}gNXs񂩃`FbN܂B
* @return sȂTrueAႤꍇFalseԂ܂B
*/
	public boolean isSquare(){
		return getRowLength() == getColLength();
	}
	
/**
* ̃}gNXƂ̘_(And)Ԃ܂B<BR>
* ̉Z𐳏ɍsꍇconvertLogicMatrix\bhs܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #convertLogicMatrix()
* @see #getOrMatrix(Matrix calculateMatrix)
* @see #getXOrMatrix(Matrix calculateMatrix)
* @see #getNotMatrix()
*/
	public Matrix getAndMatrix(Matrix calculateMatrix){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̘_ς߂
					returnMatrix.setCell(i, j, (int) getCell(i,j) &
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ̃}gNXƂ̘_a(OR)Ԃ܂B<BR>
* ̉Z𐳏ɍsꍇconvertLogicMatrix\bhs܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #convertLogicMatrix()
* @see #getAndMatrix(Matrix calculateMatrix)
* @see #getXOrMatrix(Matrix calculateMatrix)
* @see #getNotMatrix()
*/
	public Matrix getOrMatrix(Matrix calculateMatrix){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̘_a߂
					returnMatrix.setCell(i, j, (int) getCell(i,j) |
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ̃}gNXƂ̔rI_a(eXclusive OR)Ԃ܂B<BR>
* ̉Z𐳏ɍsꍇconvertLogicMatrix\bhs܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #convertLogicMatrix()
* @see #getAndMatrix(Matrix calculateMatrix)
* @see #getOrMatrix(Matrix calculateMatrix)
* @see #getNotMatrix()
*/
	public Matrix getXOrMatrix(Matrix calculateMatrix){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩ǂ
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̔rI_a߂
					returnMatrix.setCell(i, j, (int) getCell(i,j) ^
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* }gNX̔ے(NOT)Ԃ܂B<BR>
* ̉ZsꍇconvertLogicMatrix\bhs܂B
* @return Zʂ̃}gNX
* @see #convertLogicMatrix()
* @see #getAndMatrix(Matrix calculateMatrix)
* @see #getOrMatrix(Matrix calculateMatrix)
* @see #getXOrMatrix(Matrix calculateMatrix)
*/
	public Matrix getNotMatrix(){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//_l̃}gNXɕϊ
		convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ے̉Zs
					if (getCell(i,j) > 0){
						returnMatrix.setCell(i, j, 0);
					}
					else{
						returnMatrix.setCell(i, j, 1);
					}
				}
			}
		return returnMatrix;
	}
	
/**
* }gNXm̐ςԂ܂B<BR>
* Ԃ}gNX̃TCY͉Z̃}gNX̍sTCY~ZΏۂ̃}gNX̗TCYƂȂ܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYZsȂTCY̏ꍇ
*/
	public Matrix getMultiplyMatrix(Matrix calculateMatrix){
		Matrix returnMatrix = new Matrix(getRowLength(), calculateMatrix.getColLength(),
			getRowNameArray(), calculateMatrix.getColNameArray());
		
		//Zs邩ǂ
		if (isMultiplyMatrixSize(calculateMatrix)){
			for (int i = 0; i < returnMatrix.getRowLength(); i++){
				for (int j = 0; j < returnMatrix.getColLength(); j++){
					
					//s̏Zs
					//vZ a_i1 * a_1j + a_i2 * a_2j + c + a_in * a_nj
					double value = 0.0;
					for (int k = 0; k < getColLength(); k++){
							value = getCell(i, k) * calculateMatrix.getCell(k, j) + value;
					}
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
			return returnMatrix;
	}
	
/**
* exponetwƂׂvZ}gNXԂ܂B
* @param exponent ݏ̎w
* @return n}gNX
* @exception SetValueOutOfBoundsException w0ȉ̒lw肵ꍇ
* @exception NotSquareMatrixException }gNXsłȂꍇ
*/
	public Matrix getExponentMatrix(int exponent){
		Matrix initMatrix = new Matrix(matrix, getRowNameArray(), getColNameArray());
		Matrix returnMatrix = new Matrix(matrix, getRowNameArray(), getColNameArray());
		
		//s񂩂ǂA܂w0ȉ̒lw肳ꂽꍇ
		if (isSquare()){
			if (exponent > 0){
			
				//̃}gNXnZ(1̏ꍇ͌̃}gNX̂܂)
				for (int i = 1; i < exponent; i++){
				
					//i悵}gNXɌ̃}gNX|Ai+1ɂ
					returnMatrix.MatrixCopy(returnMatrix.getMultiplyMatrix(initMatrix));
				}
			}
			
			//w0ȉ̒lw肳ꂽꍇ
			else{
				throw new SetValueOutOfBoundsException("exponent(" + exponent + ")");
			}
		}
		
		//}gNXsłȂꍇ
		else{
			throw new NotSquareMatrixException();
		}
		return returnMatrix;
	}
	
/**
* }gNX̗vfPʍsɂ܂B
* @exception NotSquareMatrixException }gNXsłȂꍇ
*/
	public void createElementaryMatrix(){
		if (isSquare()){
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//Ίp̂1
					if (i == j){
						setCell(i, j, MATRIX_VALUE_TRUE);
					}
					else{
						setCell(i, j, MATRIX_VALUE_FALSE);
					}
				}
			}
		}
		
		//}gNXsłȂꍇ
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ̃}gNXƓTCY̒Pʍs𐶐܂B
* @return Pʍs
*/
	private Matrix getElementaryMatrix(){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		returnMatrix.createElementaryMatrix();
		return returnMatrix;
	}
	
/**
* }gNXאڃ}gNXƂ̉B}gNXԂ܂B<BR>
* ̉Z𐳏ɍsꍇconvertLogicMatrix\bhs܂B
* @return B}gNX
* @exception NotSquareMatrixException }gNXsł͂Ȃꍇ
* @see #convertLogicMatrix()
*/
	public Matrix getReachMatrix(){
		
		//s񂩂ǂ
		if (isSquare()){
		//̃}gNXאڃ}gNXƂĐ
		Matrix returnMatrix = new Matrix(matrix, getRowNameArray(), getColNameArray());
		
		//_l̃}gNXɕϊ
		returnMatrix.convertLogicMatrix();
		
		//PʍsƂ̘_a
		returnMatrix.MatrixCopy(returnMatrix.getOrMatrix(getElementaryMatrix()));
		
		//n-1悷
		// (I + A)n-1 I͒Pʍs +͘_a
		returnMatrix.MatrixCopy(returnMatrix.getExponentMatrix(getRowLength() - 1));
		
		//_l̃}gNXɕϊ
		returnMatrix.convertLogicMatrix();
		return returnMatrix;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
	
//ȉeXgp\bh
/*
/**
* }gNXint^ŕWo͂ɏo͂܂B

	public void outputIntMatrix(){
		System.out.print("       ");
		for (int j = 0; j < getColLength(); j++){		//񖼏o
			System.out.print(getColName(j) + " ");
		}
		System.out.println();
		for (int i = 0 ; i < getRowLength(); i++){
			if (i < 9){
			System.out.print(getRowName(i) + " ");		//so
			}
			else{
				System.out.print(getRowName(i) + " ");
			}
			for (int j = 0; j < getColLength(); j++){		//vfo
				if (j == (getColLength() - 1)){
					System.out.println("     "+(int)getCell(i, j));
				}
				else{
					System.out.print("     "+(int)getCell(i, j));
				}
			}
		}
		System.out.println();
	}
	
/**
* }gNXdouble^ŕWo͂ɏo͂܂B

	public void outputDoubleMatrix(){
		java.text.NumberFormat df = new java.text.DecimalFormat("0.000");		//_ȉ3܂ŏo
		System.out.print("       ");
		for (int j = 0; j < getColLength(); j++){
			System.out.print(getColName(j) + " ");		//񖼏o
		}
		System.out.println();
		for (int i = 0 ; i < getRowLength(); i++){
			System.out.print(getRowName(i) + "  ");		//so
			for (int j = 0; j < getColLength(); j++){		//vfo
				if (j == (getColLength() - 1)){
					System.out.println(df.format(getCell(i, j)));
				}
				else{
					System.out.print(df.format(getCell(i, j) )+" ");
				}
			}
		}
		System.out.println();
	}
	*/
	
}