package jp.ac.takushoku_u.cs;

/**
* SSAnalysisNXSS͂vZ邽߂̃NXłB<BR>
* 1n܂łniK̃AP[gf[^𕪐͂邱Ƃł܂B
* @version 1.12
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N1022
*/
public class SSAnalysis{

/**
* ͌̃}gNXێ}gNXB
*/
	private Matrix matrix;

/**
* AP[ǧ^ێϐB
*/
	private int scaleType;

/**
* ]̍őlێϐB
*/
	private int valueRating;

/**
* lێϐB
*/
	private double thresholdValue;

/**
* AP[ǧ^iI^j\萔B
*/
	private static final int SSANALYSIS_SCALE_TYPE_ASCENDING = 1;

/**
* AP[ǧ^iII^j\萔B
*/
	private static final int SSANALYSIS_SCALE_TYPE_MIDDLE = 2;

/**
* AP[ǧ^iIII^j\萔B
*/
	private static final int SSANALYSIS_SCALE_TYPE_NONSORT = 3;

/**
* }gNX̑傫̏lB
*/
	private static final int SSANALYSIS_MATRIX_VALUE = 5;

/**
* l̏lB
*/
	private static final double SSANALYSIS_THRESHOLD = 0.93;

/**
* ]l̍ől̏lB
*/
	private static final int SSANALYSIS_VALUE_RANGE = 1;

/**
* AP[ǧ^̏lB
*/
	private static final int SSANALYSIS_SCALE_TYPE = SSANALYSIS_SCALE_TYPE_ASCENDING;

/**
* SS}gNXƃXPg}gNXɓl(֘AꍇjB
*/
	private static final int SSANALYSIS_SEQUENCE_TRUE = 1;

/**
* SS}gNXƃXPg}gNXɓl(֘AȂꍇjB
*/
	private static final int SSANALYSIS_SEQUENCE_FALSE = 0;

/**
* ݒ肳ĂftHg̃TCYŕ͂s}gNXݒ肵܂B<BR>
* ͂s}gNX̗vf͑S0ɁAAP[ǧ^I^A
* ]̍ől̓}gNX̍őlɁAl̓ftHglƂȂ܂B
*/
	public SSAnalysis(){
		Matrix baseMatrix = new Matrix(SSANALYSIS_MATRIX_VALUE,SSANALYSIS_MATRIX_VALUE);		//}gNX̍쐬
		setMatrix(baseMatrix);		//}gNX̐
		setScale(SSANALYSIS_SCALE_TYPE);		//AP[ǧ^̐
		matrix.clearMatrix();		//}gNX̗vf
		setRating(SSANALYSIS_VALUE_RANGE);		//]̍ől̐ݒ
		setThreshold(SSANALYSIS_THRESHOLD);		//l̐ݒ
	}

/**
* ɕ͂s}gNXݒ肵܂B<BR>
* AP[ǧ^I^A]̍ől̓}gNX̍őlɁAl̓ftHgƂȂ܂B
* @param baseMatrix ͂s}gNX
*/
	public SSAnalysis(Matrix baseMatrix){
		setMatrix(baseMatrix);
		setScale(SSANALYSIS_SCALE_TYPE);
		setRating((int) matrix.getMaxCell());
		setThreshold(SSANALYSIS_THRESHOLD);
	}

/**
* ɕ͂s}gNXƃAP[ǧ^ݒ肵܂B<BR>
* ]̍ől̓}gNX̍őlɁAl̓ftHgƂȂ܂B
* @param baseMatrix ͂s}gNX
* @param scale AP[ǧ^
* @exception SetValueOutOfBoundsException AP[ǧ^słꍇ
*/
	public SSAnalysis(Matrix baseMatrix, int scale){
		setMatrix(baseMatrix);
		setScale(scale);
		setRating((int) matrix.getMaxCell());
		setThreshold(SSANALYSIS_THRESHOLD);
	}

/**
* ɕ͂s}gNXAAP[ǧ^Alݒ肵܂B<BR>
* ]̍ől̓}gNX̍őlƂȂ܂B
* @param baseMatrix ͂s}gNX
* @param scale AP[ǧ^
* @param threshold l
* @exception SetValueOutOfBoundsException AP[ǧ^słꍇAlݒł͈͊Ȍꍇ
*/
	public SSAnalysis(Matrix baseMatrix, int scale, double threshold){
		setMatrix(baseMatrix);
		setScale(scale);
		setRating((int) matrix.getMaxCell());
		setThreshold(threshold);
	}

/**
* ɕ͂s}gNXAAP[ǧ^AlA]̍őlݒ肵܂B<BR>
* ]̍ől͐ݒ肵lƃ}gNX̍ől̂ꂩ傫ƂȂ܂B
* @param baseMatrix ͂s}gNX
* @param scale AP[ǧ^
* @param threshold l
* @param rating ]̍ől
* @exception SetValueOutOfBoundsException AP[ǧ^słꍇA܂͂lݒł͈͊Ȍꍇ
*/
	public SSAnalysis(Matrix baseMatrix, int scale, double threshold, int rating){
		setMatrix(baseMatrix);
		setScale(scale);
		setRating(rating);
		setThreshold(threshold);
	}


/**
* SS}gNXԂ܂B
* @return SS}gNX
* @see #getCoefficientMatrix()
* @see #getSkeletonMatrix()
*/
	public Matrix getSSMatrix(){
		
		//ԂSS}gNX
		Matrix returnMatrix = new Matrix(matrix.getColLength(), matrix.getColLength(), 
			matrix.getColNameArray(), matrix.getColNameArray());
		
		//i܁jW\߂
		Matrix coefficientMatrix = new Matrix(matrix.getColLength(), matrix.getColLength());
		coefficientMatrix.MatrixCopy(getCoefficientMatrix());
		
		int value;
		for (int i = 0; i <  matrix.getColLength(); i++){
			for (int j = 0; j <  matrix.getColLength(); j++){
				if (thresholdValue <= coefficientMatrix.getCell(i, j)){	//邩ǂ0,1ݒ肷
					value = SSANALYSIS_SEQUENCE_TRUE;
				}
				else{
					value = SSANALYSIS_SEQUENCE_FALSE;
				}
				returnMatrix.setCell(i, j, value);
			}
		}
		return returnMatrix;
	}

/**
* i܁jW\}gNXŕԂ܂B
* @return W\}gNX
* @see #getSSMatrix()
* @see #getSkeletonMatrix()
*/
	public Matrix getCoefficientMatrix(){
		
		//Ԃi܁jW\
		 Matrix returnMatrix = new Matrix(matrix.getColLength(), matrix.getColLength(),
		 	matrix.getColNameArray(), matrix.getColNameArray());
		
		for (int i = 0; i < matrix.getColLength(); i++){
			for (int j = 0; j < matrix.getColLength(); j++){
				returnMatrix.setCell(i, j, getCoefficient(i, j));
			}
		}
		return returnMatrix;
	}

/**
* 鍀Ij獀Ikւ̏i܁jW߂܂B
* @param Ij Ij
* @param Ik Ik
* @return Ij獀Ikւ̏W
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	public double getCoefficient(int Ij, int Ik){
		if (matrix.isMatrixEntityPoint(Ij, Ik)){
			double value = 0;
			if (getScaleType() == SSANALYSIS_SCALE_TYPE_ASCENDING){		//I^
				value = getAscendingCoefficient(Ij, Ik);
			}
			else if (getScaleType() == SSANALYSIS_SCALE_TYPE_MIDDLE){	//II^
				value = getMiddleCoefficient(Ij, Ik);
			}
			else if (getScaleType() == SSANALYSIS_SCALE_TYPE_NONSORT){	//III^
				value = getNonSortCoefficient(Ij, Ik);
			}
			else{		//ftHg
				value = getAscendingCoefficient(Ij, Ik);
			}
			return value;
		}
		else{
			throw new NotElementException
				("point(" + Ij + "," + Ik + ")");
		}
	}

/**
* 鍀IjƍIkԂ̓xz\߂܂B
* @param Ij Ij
* @param Ik Ik
* @return Ij獀Ikւ̓xz\
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	public Matrix getFrequencyMatrix(int Ij, int Ik){
		if (matrix.isMatrixEntityPoint(Ij, Ik)){
			
			//Ԃxz\
			Matrix returnTable = new Matrix(getMaxValue(), getMaxValue());
			returnTable.clearMatrix();
			for (int i = 0; i < matrix.getRowLength(); i++){		//xz\̍쐬
				double value = returnTable.getCell((int) matrix.getCell(i, Ij) -1,
					(int) matrix.getCell(i, Ik) -1) +1;
				returnTable.setCell((int) matrix.getCell(i, Ij) -1,
					(int) matrix.getCell(i, Ik) -1, value);
			}
			 return returnTable;
		}
		else{		//w肵vf݂Ȃꍇ
			throw new NotElementException
				("point(" + Ij + "," + Ik + ")");
		}
	}

/**
* I^̏W߂܂B
* @param Ij Ij
* @param Ik Ik
* @return Ij獀Ikւ̏W
*/
	private double getAscendingCoefficient(int Ij, int Ik){
		double value = 0;
		Matrix frequencyMatrix = new Matrix(getMaxValue(), getMaxValue());
		frequencyMatrix = getFrequencyMatrix(Ij, Ik);	//xz\߂

		for (int i = 1; i <= ( frequencyMatrix.getRowLength() - 1); i++){	//W߂
			for (int j=i+1; j <=  frequencyMatrix.getColLength(); j++){
				value = (j - i) * frequencyMatrix.getCell(j-1, i-1) + value;
			}
		}
		value = 1 - value / (matrix.getRowLength() * ( frequencyMatrix.getColLength() - 1));
		return value;
	}

/**
* II^̏W߂܂B
* @param Ij Ij
* @param Ik Ik
* @return I獀Jւ̏W
*/
	private double getMiddleCoefficient(int Ij, int Ik){
		double value = 0;
		double centerRating = (getMaxValue() + 1) / 2;		//]̒l
		double numeratorU = (matrix.getRowLength() *
			(getMaxValue() - 1) * (getMaxValue() - 1)) / 4;	//q
		double gravity;		//d((r-m0)^2-(q-m0)^2)
		Matrix frequencyMatrix = new Matrix(getMaxValue(), getMaxValue());
		frequencyMatrix = getFrequencyMatrix(Ij, Ik);		//xz\߂

		for (int i = 1; i <= getMaxValue(); i++){		//W߂
			for (int j = 1; j <= getMaxValue(); j++){
				if (Math.abs(i - centerRating) > Math.abs(j - centerRating)){
					gravity = ((i - centerRating) * (i - centerRating)) -
					((j - centerRating) * (j - centerRating));
					value = ((gravity * frequencyMatrix.getCell(j-1, i-1)) / numeratorU) + value;
				}
			}
		}
		value = 1- value;
		return value;
	}

/**
* III^̕ܐW߂܂B
* @param Ij Ij
* @param Ik Ik
* @return I獀Jւ̕ܐW
*/
	private double getNonSortCoefficient(int Ij, int Ik){
		double value = 0;

		//VO}̍őld0
		double numeratorD = ((matrix.getRowLength() * matrix.getRowLength()) *
			(getMaxValue() - 1)) / (2 * getMaxValue());
		Matrix frequencyMatrix = new Matrix(getMaxValue(), getMaxValue());
		frequencyMatrix.MatrixCopy(getFrequencyMatrix(Ij, Ik));	//xz\߂

		for (int i = 1; i <= getMaxValue(); i++){		//ܐW߂
			for (int j = 1; j <= getMaxValue(); j++){
				for (int k = 1; k <= getMaxValue(); k++){
					if (j != k){		//r!=r'Ȃ
						value = (frequencyMatrix.getCell(j, i) *
							frequencyMatrix.getCell(k, i)) + value;
					}
				}
			}
		}
		value = 1 - (value / numeratorD);
		return value;
	}

/**
* SSOt`߂̃XPg}gNXԂ܂B
* ̃}gNXSSOt`ۂ̗אڃ}gNX\܂B
* @return XPg}gNX
* @see #getSSMatrix()
* @see #getCoefficientMatrix()
*/
	public Matrix getSkeletonMatrix(){
		Matrix SkeletonMatrix = new Matrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		
		int[] highOrder = new int[matrix.getColLength()];
		System.arraycopy(getGraphElementArray(), 0, highOrder, 0, highOrder.length);
		SkeletonMatrix.clearMatrix();
		
		//SS}gNX𓾂
		Matrix ssMatrix = new Matrix(matrix.getColLength(), matrix.getColLength());
		ssMatrix.MatrixCopy(getSSMatrix());
		
		for (int i = 0; i < SkeletonMatrix.getRowLength(); i++){
			int searchRow = highOrder[i];	 //ۂɌssiϕ]l̗̍vfj
			int branchCount = 0;		//̗vf瑼̗vfɂ}`
			boolean isUnder = true;		//̗vf]lႢvf

			for (int j = SkeletonMatrix.getRowLength() - 1; j >= 0; j--){
				int searchCol = highOrder[j];	//ۂɌsivfj

				if (searchRow == searchCol){		//vf𒲂ׂ悤ƂĂ邩
					isUnder = false;
					branchCount = 0;		//x
				}
				else{
				//̗vfƏ֌W邩ǂ
					if (ssMatrix.getCell(searchRow, searchCol) == SSANALYSIS_SEQUENCE_TRUE){

						/*
						* }`ł邩
						* 1.̗vf]lႢvfĂ邩
						* 2.̗vf瑼̗vfɎ}܂`ĂȂ
						* 3.̗vf̗vf}`Ă邩 
						*/
						if ((branchCount == 0) || (isUnder)||
								(SkeletonMatrix.getCell(searchCol,searchRow) ==
									SSANALYSIS_SEQUENCE_TRUE)){
							SkeletonMatrix.setCell
										(searchRow, searchCol, SSANALYSIS_SEQUENCE_TRUE);
							branchCount = branchCount + 1;
							}
						else{		//̗vfɎ}`ĂꍇAǂ̗vfɎ}`T
							int counter = 0;	//JE^[
							for (int k = ssMatrix.getRowLength() - 1; k > j; k--){
								
								//`}̗̐vf猟sĂvf֏֘ASĂ̎}ɂĂȂT
								if ((SkeletonMatrix.getCell(searchRow, highOrder[k]) ==
										SSANALYSIS_SEQUENCE_TRUE) &&
									(ssMatrix.getCell(highOrder[k], searchCol) ==
											SSANALYSIS_SEQUENCE_FALSE)){
										counter = counter + 1;		//Ȃꍇ̓JE^[𑝂₷
									}
							}

							//`SĂ̑̎}̐悩炻̗vf֏֘AȂꍇ͎}`
							if (branchCount == counter){
								SkeletonMatrix.setCell
									(searchRow, searchCol, SSANALYSIS_SEQUENCE_TRUE);
								branchCount = branchCount + 1;
							}
						}
					}
				}
			}
		}
		return SkeletonMatrix;
	}

/**
* ڂOt`ɕבւڔԍ̔zԂ܂B
* @return Ot`ɕ׊ԍiځjz
* @see #getGraphHeightArray()
*/
	public int[] getGraphElementArray(){

		if (getScaleType() == SSANALYSIS_SCALE_TYPE_ASCENDING){		//I^
			return getAscendingGraphArray();
		}
		else if (getScaleType() == SSANALYSIS_SCALE_TYPE_MIDDLE){		//II^
			return getMiddleGraphArray();
		}
		else if (getScaleType() == SSANALYSIS_SCALE_TYPE_NONSORT){		//III^
			return getNonSortGraphArray();
		}
		else{		//YȂꍇ
			return getAscendingGraphArray();
		}
	}

/**
* SSOt`ۂ̏cƂȂeڂ̒lzŕԂ܂B
* @return eڂ̏cƂȂlz
* @see #getGraphElementArray()
*/
	public double[] getGraphHeightArray(){
		double[] returnArray = new double[matrix.getColLength()];

		if (getScaleType() == SSANALYSIS_SCALE_TYPE_ASCENDING){		//I^
			System.arraycopy(getAscendingAverageArray(), 0, returnArray, 0, returnArray.length);
		}
		else if (getScaleType() == SSANALYSIS_SCALE_TYPE_MIDDLE){	//II^
			System.arraycopy(getMiddleAverageArray(), 0, returnArray, 0, returnArray.length);
		}
		else if (getScaleType() == SSANALYSIS_SCALE_TYPE_NONSORT){	//III^
			System.arraycopy(getNonSortCategoryArray(), 0, returnArray, 0, returnArray.length);
		}
		else{		//ftHg
			System.arraycopy(getAscendingAverageArray(), 0, returnArray, 0, returnArray.length);
		}
		return returnArray;
	}

/**
* eڂ̕]蕽ϒl̔zԂ܂B<BR>
* I^͂̍ۂɎgp܂B
* @return ϒl̔z񂪓z
*/
	private double[] getAscendingAverageArray(){
		double[]  returnArray = new double[matrix.getColLength()];		//eڂ̕ϒli[
		System.arraycopy(matrix.getColAverageArray(), 0, returnArray, 0, returnArray.length);
		return returnArray;
	}

/**
* ڂOt`ɕבւڔԍ̔zԂ܂B<BR>
* ϕ]l̍ɍڔԍוς܂B
* I^͂̍ۂɗp܂B
* @return Ot`ɕ׊ԍiځjz
*/
	private int[] getAscendingGraphArray(){
		double[]  averageRating = new double[matrix.getColLength()];		//eڂ̕ϒli[
		int[] returnArray = new int[matrix.getColLength()];		//ϕ]l̍ɕׂ̗ԍiځj
		System.arraycopy(getGraphHeightArray(), 0, averageRating, 0, averageRating.length);
		
		for (int i = 0; i < averageRating.length; i++){
			double maxAverage = averageRating[0];		//l
			int maxNumber = 0;
			for (int j = 1; j <  averageRating.length; j++){		//rs
				if (maxAverage < averageRating[j]){
					maxAverage = averageRating[j];
					maxNumber = j;
				}
			}
			averageRating[maxNumber] = 0;	 //rΏۂ͂
			returnArray[i] = maxNumber;
		}
		return returnArray;
	}

/**
* ]̒lOĂx\}gNXԂ܂B<BR>
* II^͂̍ۂɗp܂B
* @return ̃}gNX̗vf𒆉lΒl}gNX
*/
	private Matrix getMiddleMomentMatrix(){
		Matrix returnMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(), matrix.getRowNameArray(),
			matrix.getColNameArray());
		double centerRating = (getMaxValue() + 1) / 2;		//]̒l
		for (int i = 0; i < matrix.getRowLength(); i++){
			for (int j = 0; j < matrix.getColLength(); j++){
				returnMatrix.setCell(i, j, Math.abs(matrix.getCell(i, j) - centerRating));
			}
		}
		return returnMatrix;
	}

/**
* ]̒lOĂl̔zԂ܂B<BR>
* II^͂̍ۂɗp܂B
* @return lΒl̔z񂪓z
*/
	private double[] getMiddleAverageArray(){
		Matrix calculationMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(), matrix.getRowNameArray(),
			matrix.getColNameArray());
		calculationMatrix.MatrixCopy(getMiddleMomentMatrix());
		return calculationMatrix.getColAverageArray();
	}

/**
* ڂOt`ɕבւڔԍ̔zԂ܂B
* II^͂̍ۂɗp܂B
* @return Ot`ɕ׊ԍiځjz
*/
	private int[] getMiddleGraphArray(){
		double[]  averageRating = new double[matrix.getColLength()];		//eڂ̒Oꂽvli[
		int[] returnArray = new int[matrix.getColLength()];	//OꂽlȂɕׂ̗ԍiځj
		System.arraycopy(getGraphHeightArray(), 0, averageRating, 0, averageRating.length);
		for (int i = 0; i < averageRating.length; i++){
			double minAverage = averageRating[0];	//l
			int minNumber = 0;
			for (int j = 1; j <  averageRating.length; j++){  //rs
				if (averageRating[j] < minAverage){
					minAverage = averageRating[j];
					minNumber = j;
				}
			}
			averageRating[minNumber] = getMaxValue() * matrix.getRowLength(); //rΏۂ͂
			returnArray[i] = minNumber;
		}
		return returnArray;
	}

/**
* eڂ̗LJeS[߂zԂ܂B<BR>
* III^͂̍ۂɗp܂B
* @return LJeS[z
*/
	private double[] getNonSortCategoryArray(){
		double[] returnArray = new double[matrix.getColLength()];
		Matrix frequencyTable = new Matrix(getMaxValue(), getMaxValue());

		for (int i = 0; i < matrix.getColLength(); i++){		//LJeS[߂
			double value = 0;
			frequencyTable.MatrixCopy(getFrequencyMatrix(i,i));
			for (int j = 0; j < getMaxValue(); j++){
				value = (frequencyTable.getCell(j,j) / matrix.getRowLength())
				* (frequencyTable.getCell(j,j) / matrix.getRowLength()) + value;
			}
			returnArray[i] = 1 / value;
		}
		return returnArray;
	}

/**
* ڂOt`ɕבւڔԍ̔zԂ܂B<BR>
* III^͂̍ۂɗp܂B
* @return Ot`ɕ׊ԍiځjz
*/
	private int[] getNonSortGraphArray(){
		int[] returnArray = new int[matrix.getColLength()];

		double[]  averageRating = new double[matrix.getColLength()];		//eڂ̗LJeR[li[
		System.arraycopy(getGraphHeightArray(), 0, averageRating, 0, averageRating.length);
		for (int i = 0; i < averageRating.length; i++){
			double minAverage = averageRating[0];	//l
			int minNumber = 0;
			for (int j = 1; j <  averageRating.length; j++){  //rs
				if(averageRating[j] < minAverage){
					minAverage = averageRating[j];
					minNumber = j;
				}
			}
			averageRating[minNumber] = getMaxValue() * matrix.getRowLength(); //rΏۂ͂
			returnArray[i] = minNumber;
		}
		return returnArray;
	}

/**
* ͂sÕ}gNXԂ܂B
* @return ͂sǑ̃}gNX
*/
	public Matrix getMatrix(){
		return matrix;
	}

/**
* AP[ǧ^Ԃ܂B
* @return AP[ǧ^
*/
	public int getScaleType(){
		return scaleType;
	}

/**
* ]̍őlԂ܂B
* @return ]̍ől
*/
	public int getMaxValue(){
		return valueRating;
	}

/**
* lԂ܂B
* @return l
*/
	public double getThreshold(){
		return thresholdValue;
	}

/**
* SS͂̑ΏۂƂȂ}gNXݒ肵܂B
* @param baseMatrix ݒ肷镪͑Ώۂ̃}gNX
* @see #setElement(int row, int col, int value)
*/
	public void setMatrix(Matrix baseMatrix){
		matrix = new Matrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
		matrix.MatrixCopy(baseMatrix);		//}gNX̐ݒ
	}

/**
* SS͂̑ΏۂƂȂ}gNX̗vfC܂B
* @param row Cvf̍s
* @param col Cvf̗
* @param value Cl
* @exception NotElementException w肵vf݂Ȃꍇ
* @see #setMatrix(Matrix baseMatrix)
*/
	public void setElement(int row, int col, int value){
		if (matrix.isMatrixEntityPoint(row, col)){
			matrix.setCell(row, col, value);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}
	
/**
* lݒ肵܂B<BR>
* l01܂ł̊ԂŐݒ肵܂B
* @param threshold ݒ肷邵l
* @exception SetValueOutOfBoundsException lݒł͈͊Ȍꍇ
*/
	public void setThreshold(double threshold){
		if(isThreshold(threshold)){
			thresholdValue = threshold;
		}
		else{		//G[̏ꍇ
			throw new SetValueOutOfBoundsException("Threshold(" + threshold + ")");
		}
	}


/**
* AP[ǧ^ݒ肵܂B<BR>
* AP[ǧ^ 1 A 2 A 3 ̂ꂩŐݒ肵܂B
* @param scale ݒ肷AP[ǧ^
* @exception SetValueOutOfBoundsException AP[ǧ^słꍇ
*/
	private void setScale(int scale){
		if (isScale(scale)){
			scaleType = scale;
		}
		else{		//G[̏ꍇ
			throw new SetValueOutOfBoundsException("scale(" + scale + ")");
		}
	}

/**
* ]̍őlݒ肵܂B<BR>
* ݒ肷l͑ΏۂƂȂ錳̃}gNX̗vfɂől̕傫ꍇ͍őlݒ肵܂B<BR>
* ̍ۍőlłꍇ́A_ȉ؂グɂ܂B
* @param rating ݒ肷]̍ől
*/
	private void setRating(int rating){
		if (isRating(rating)){
			valueRating = rating;
		}
		else{		//G[̏ꍇ
			valueRating = (int)Math.ceil(matrix.getMaxCell());
		}
	}

/**
* AP[ǧ^`FbN܂B
* @param checkScale `FbNAP[ǧ^
* @return AP[ǧ^łtrueA͈͊OłfalseԂ܂
*/
	private boolean isScale(int checkScale){
		return ((checkScale == SSANALYSIS_SCALE_TYPE_ASCENDING) ||
			(checkScale == SSANALYSIS_SCALE_TYPE_MIDDLE) ||
		(checkScale == SSANALYSIS_SCALE_TYPE_NONSORT));
	}

/**
* l͈͓`FbN܂B
* @param checkThreshold `FbN邵l
* @return l͈͓łtrueA͈͊OłfalseԂ܂
*/
	private boolean isThreshold(double checkThreshold){
		return ((0 <= checkThreshold) && (checkThreshold <= 1));
	}

/**
* ]̍ől͂s}gNX̗vf̍ől傫`FbN܂B
* @param checkRating `FbN邵l
* @return ]̍ől̕傫trueAfalseԂ܂
*/
	private boolean isRating(int checkRating){
		return (matrix.getMaxCell() <= checkRating);
	}

}